/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.commons.discovery;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.core.style.ToStringCreator;

@ConfigurationProperties(value="spring.cloud.kubernetes.discovery")
public class KubernetesDiscoveryProperties {
    private boolean enabled = true;
    private boolean allNamespaces = false;
    private boolean waitCacheReady = true;
    private long cacheLoadingTimeoutSeconds = 60L;
    private boolean includeNotReadyAddresses = false;
    private String filter;
    private Set<Integer> knownSecurePorts = Stream.of(443, 8443).collect(Collectors.toCollection(HashSet::new));
    private Map<String, String> serviceLabels = new HashMap<String, String>();
    private String primaryPortName;
    private Metadata metadata = new Metadata();
    private int order = 0;

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public Set<Integer> getKnownSecurePorts() {
        return this.knownSecurePorts;
    }

    public void setKnownSecurePorts(Set<Integer> knownSecurePorts) {
        this.knownSecurePorts = knownSecurePorts;
    }

    public Map<String, String> getServiceLabels() {
        return this.serviceLabels;
    }

    public void setServiceLabels(Map<String, String> serviceLabels) {
        this.serviceLabels = serviceLabels;
    }

    public String getPrimaryPortName() {
        return this.primaryPortName;
    }

    public void setPrimaryPortName(String primaryPortName) {
        this.primaryPortName = primaryPortName;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public boolean isAllNamespaces() {
        return this.allNamespaces;
    }

    public void setAllNamespaces(boolean allNamespaces) {
        this.allNamespaces = allNamespaces;
    }

    public boolean isIncludeNotReadyAddresses() {
        return this.includeNotReadyAddresses;
    }

    public void setIncludeNotReadyAddresses(boolean includeNotReadyAddresses) {
        this.includeNotReadyAddresses = includeNotReadyAddresses;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public boolean isWaitCacheReady() {
        return this.waitCacheReady;
    }

    public void setWaitCacheReady(boolean waitCacheReady) {
        this.waitCacheReady = waitCacheReady;
    }

    public long getCacheLoadingTimeoutSeconds() {
        return this.cacheLoadingTimeoutSeconds;
    }

    public void setCacheLoadingTimeoutSeconds(long cacheLoadingTimeoutSeconds) {
        this.cacheLoadingTimeoutSeconds = cacheLoadingTimeoutSeconds;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("enabled", this.enabled).append("filter", (Object)this.filter).append("knownSecurePorts", this.knownSecurePorts).append("serviceLabels", this.serviceLabels).append("metadata", (Object)this.metadata).toString();
    }

    public static class Metadata {
        private boolean addLabels = true;
        private String labelsPrefix;
        private boolean addAnnotations = true;
        private String annotationsPrefix;
        private boolean addPorts = true;
        private String portsPrefix = "port.";

        public boolean isAddLabels() {
            return this.addLabels;
        }

        public void setAddLabels(boolean addLabels) {
            this.addLabels = addLabels;
        }

        public String getLabelsPrefix() {
            return this.labelsPrefix;
        }

        public void setLabelsPrefix(String labelsPrefix) {
            this.labelsPrefix = labelsPrefix;
        }

        public boolean isAddAnnotations() {
            return this.addAnnotations;
        }

        public void setAddAnnotations(boolean addAnnotations) {
            this.addAnnotations = addAnnotations;
        }

        public String getAnnotationsPrefix() {
            return this.annotationsPrefix;
        }

        public void setAnnotationsPrefix(String annotationsPrefix) {
            this.annotationsPrefix = annotationsPrefix;
        }

        public boolean isAddPorts() {
            return this.addPorts;
        }

        public void setAddPorts(boolean addPorts) {
            this.addPorts = addPorts;
        }

        public String getPortsPrefix() {
            return this.portsPrefix;
        }

        public void setPortsPrefix(String portsPrefix) {
            this.portsPrefix = portsPrefix;
        }

        public String toString() {
            return new ToStringCreator((Object)this).append("addLabels", this.addLabels).append("labelsPrefix", (Object)this.labelsPrefix).append("addAnnotations", this.addAnnotations).append("annotationsPrefix", (Object)this.annotationsPrefix).append("addPorts", this.addPorts).append("portsPrefix", (Object)this.portsPrefix).toString();
        }
    }
}

