/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.models.Activity;
import com.azure.resourcemanager.datafactory.models.Expression;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class ForEachActivityTypeProperties {
    @JsonProperty(value="isSequential")
    private Boolean isSequential;
    @JsonProperty(value="batchCount")
    private Integer batchCount;
    @JsonProperty(value="items", required=true)
    private Expression items;
    @JsonProperty(value="activities", required=true)
    private List<Activity> activities;
    private static final ClientLogger LOGGER = new ClientLogger(ForEachActivityTypeProperties.class);

    public Boolean isSequential() {
        return this.isSequential;
    }

    public ForEachActivityTypeProperties withIsSequential(Boolean isSequential) {
        this.isSequential = isSequential;
        return this;
    }

    public Integer batchCount() {
        return this.batchCount;
    }

    public ForEachActivityTypeProperties withBatchCount(Integer batchCount) {
        this.batchCount = batchCount;
        return this;
    }

    public Expression items() {
        return this.items;
    }

    public ForEachActivityTypeProperties withItems(Expression items) {
        this.items = items;
        return this;
    }

    public List<Activity> activities() {
        return this.activities;
    }

    public ForEachActivityTypeProperties withActivities(List<Activity> activities) {
        this.activities = activities;
        return this;
    }

    public void validate() {
        if (this.items() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property items in model ForEachActivityTypeProperties"));
        }
        this.items().validate();
        if (this.activities() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property activities in model ForEachActivityTypeProperties"));
        }
        this.activities().forEach(e -> e.validate());
    }
}

