/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.DataFactoryManager;
import com.azure.resourcemanager.datafactory.fluent.TriggerRunsClient;
import com.azure.resourcemanager.datafactory.fluent.models.TriggerRunsQueryResponseInner;
import com.azure.resourcemanager.datafactory.implementation.TriggerRunsQueryResponseImpl;
import com.azure.resourcemanager.datafactory.models.RunFilterParameters;
import com.azure.resourcemanager.datafactory.models.TriggerRuns;
import com.azure.resourcemanager.datafactory.models.TriggerRunsQueryResponse;

public final class TriggerRunsImpl
implements TriggerRuns {
    private static final ClientLogger LOGGER = new ClientLogger(TriggerRunsImpl.class);
    private final TriggerRunsClient innerClient;
    private final DataFactoryManager serviceManager;

    public TriggerRunsImpl(TriggerRunsClient innerClient, DataFactoryManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<Void> rerunWithResponse(String resourceGroupName, String factoryName, String triggerName, String runId, Context context) {
        return this.serviceClient().rerunWithResponse(resourceGroupName, factoryName, triggerName, runId, context);
    }

    @Override
    public void rerun(String resourceGroupName, String factoryName, String triggerName, String runId) {
        this.serviceClient().rerun(resourceGroupName, factoryName, triggerName, runId);
    }

    @Override
    public Response<Void> cancelWithResponse(String resourceGroupName, String factoryName, String triggerName, String runId, Context context) {
        return this.serviceClient().cancelWithResponse(resourceGroupName, factoryName, triggerName, runId, context);
    }

    @Override
    public void cancel(String resourceGroupName, String factoryName, String triggerName, String runId) {
        this.serviceClient().cancel(resourceGroupName, factoryName, triggerName, runId);
    }

    @Override
    public Response<TriggerRunsQueryResponse> queryByFactoryWithResponse(String resourceGroupName, String factoryName, RunFilterParameters filterParameters, Context context) {
        Response<TriggerRunsQueryResponseInner> inner = this.serviceClient().queryByFactoryWithResponse(resourceGroupName, factoryName, filterParameters, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new TriggerRunsQueryResponseImpl((TriggerRunsQueryResponseInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public TriggerRunsQueryResponse queryByFactory(String resourceGroupName, String factoryName, RunFilterParameters filterParameters) {
        TriggerRunsQueryResponseInner inner = this.serviceClient().queryByFactory(resourceGroupName, factoryName, filterParameters);
        if (inner != null) {
            return new TriggerRunsQueryResponseImpl(inner, this.manager());
        }
        return null;
    }

    private TriggerRunsClient serviceClient() {
        return this.innerClient;
    }

    private DataFactoryManager manager() {
        return this.serviceManager;
    }
}

