/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.models.ExecutePipelineActivityTypeProperties;
import com.azure.resourcemanager.datafactory.models.ActivityDependency;
import com.azure.resourcemanager.datafactory.models.ControlActivity;
import com.azure.resourcemanager.datafactory.models.ExecutePipelineActivityPolicy;
import com.azure.resourcemanager.datafactory.models.PipelineReference;
import com.azure.resourcemanager.datafactory.models.UserProperty;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import java.util.Map;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonTypeName(value="ExecutePipeline")
public final class ExecutePipelineActivity
extends ControlActivity {
    @JsonProperty(value="policy")
    private ExecutePipelineActivityPolicy policy;
    @JsonProperty(value="typeProperties", required=true)
    private ExecutePipelineActivityTypeProperties innerTypeProperties = new ExecutePipelineActivityTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(ExecutePipelineActivity.class);

    public ExecutePipelineActivityPolicy policy() {
        return this.policy;
    }

    public ExecutePipelineActivity withPolicy(ExecutePipelineActivityPolicy policy) {
        this.policy = policy;
        return this;
    }

    private ExecutePipelineActivityTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public ExecutePipelineActivity withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public ExecutePipelineActivity withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public ExecutePipelineActivity withDependsOn(List<ActivityDependency> dependsOn) {
        super.withDependsOn((List)dependsOn);
        return this;
    }

    @Override
    public ExecutePipelineActivity withUserProperties(List<UserProperty> userProperties) {
        super.withUserProperties((List)userProperties);
        return this;
    }

    public PipelineReference pipeline() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().pipeline();
    }

    public ExecutePipelineActivity withPipeline(PipelineReference pipeline) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ExecutePipelineActivityTypeProperties();
        }
        this.innerTypeProperties().withPipeline(pipeline);
        return this;
    }

    public Map<String, Object> parameters() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().parameters();
    }

    public ExecutePipelineActivity withParameters(Map<String, Object> parameters) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ExecutePipelineActivityTypeProperties();
        }
        this.innerTypeProperties().withParameters(parameters);
        return this;
    }

    public Boolean waitOnCompletion() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().waitOnCompletion();
    }

    public ExecutePipelineActivity withWaitOnCompletion(Boolean waitOnCompletion) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ExecutePipelineActivityTypeProperties();
        }
        this.innerTypeProperties().withWaitOnCompletion(waitOnCompletion);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.policy() != null) {
            this.policy().validate();
        }
        if (this.innerTypeProperties() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model ExecutePipelineActivity"));
        }
        this.innerTypeProperties().validate();
    }
}

