/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.models.AzureBatchLinkedServiceTypeProperties;
import com.azure.resourcemanager.datafactory.models.CredentialReference;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeReference;
import com.azure.resourcemanager.datafactory.models.LinkedService;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import com.azure.resourcemanager.datafactory.models.ParameterSpecification;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import java.util.Map;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonTypeName(value="AzureBatch")
public final class AzureBatchLinkedService
extends LinkedService {
    @JsonProperty(value="typeProperties", required=true)
    private AzureBatchLinkedServiceTypeProperties innerTypeProperties = new AzureBatchLinkedServiceTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(AzureBatchLinkedService.class);

    private AzureBatchLinkedServiceTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public AzureBatchLinkedService withConnectVia(IntegrationRuntimeReference connectVia) {
        super.withConnectVia(connectVia);
        return this;
    }

    @Override
    public AzureBatchLinkedService withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public AzureBatchLinkedService withParameters(Map<String, ParameterSpecification> parameters) {
        super.withParameters(parameters);
        return this;
    }

    @Override
    public AzureBatchLinkedService withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    public Object accountName() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().accountName();
    }

    public AzureBatchLinkedService withAccountName(Object accountName) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureBatchLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withAccountName(accountName);
        return this;
    }

    public SecretBase accessKey() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().accessKey();
    }

    public AzureBatchLinkedService withAccessKey(SecretBase accessKey) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureBatchLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withAccessKey(accessKey);
        return this;
    }

    public Object batchUri() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().batchUri();
    }

    public AzureBatchLinkedService withBatchUri(Object batchUri) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureBatchLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withBatchUri(batchUri);
        return this;
    }

    public Object poolName() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().poolName();
    }

    public AzureBatchLinkedService withPoolName(Object poolName) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureBatchLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withPoolName(poolName);
        return this;
    }

    public LinkedServiceReference linkedServiceName() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().linkedServiceName();
    }

    public AzureBatchLinkedService withLinkedServiceName(LinkedServiceReference linkedServiceName) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureBatchLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withLinkedServiceName(linkedServiceName);
        return this;
    }

    public Object encryptedCredential() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().encryptedCredential();
    }

    public AzureBatchLinkedService withEncryptedCredential(Object encryptedCredential) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureBatchLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withEncryptedCredential(encryptedCredential);
        return this;
    }

    public CredentialReference credential() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().credential();
    }

    public AzureBatchLinkedService withCredential(CredentialReference credential) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureBatchLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withCredential(credential);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerTypeProperties() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model AzureBatchLinkedService"));
        }
        this.innerTypeProperties().validate();
    }
}

