/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.implementation;

import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.azure.resourcemanager.storage.fluent.models.StorageAccountInner;
import com.azure.resourcemanager.storage.implementation.BlobServiceEncryptionStatusImpl;
import com.azure.resourcemanager.storage.implementation.FileServiceEncryptionStatusImpl;
import com.azure.resourcemanager.storage.implementation.QueueServiceEncryptionStatusImpl;
import com.azure.resourcemanager.storage.implementation.TableServiceEncryptionStatusImpl;
import com.azure.resourcemanager.storage.models.Encryption;
import com.azure.resourcemanager.storage.models.EncryptionService;
import com.azure.resourcemanager.storage.models.EncryptionServices;
import com.azure.resourcemanager.storage.models.KeySource;
import com.azure.resourcemanager.storage.models.KeyType;
import com.azure.resourcemanager.storage.models.KeyVaultProperties;
import com.azure.resourcemanager.storage.models.StorageAccountCreateParameters;
import com.azure.resourcemanager.storage.models.StorageAccountEncryptionKeySource;
import com.azure.resourcemanager.storage.models.StorageAccountEncryptionStatus;
import com.azure.resourcemanager.storage.models.StorageAccountUpdateParameters;
import com.azure.resourcemanager.storage.models.StorageService;
import java.util.HashMap;
import java.util.Map;

final class StorageEncryptionHelper {
    private final boolean isInCreateMode;
    private final StorageAccountInner inner;
    private final StorageAccountCreateParameters createParameters;
    private final StorageAccountUpdateParameters updateParameters;

    StorageEncryptionHelper(StorageAccountCreateParameters createParameters) {
        this.isInCreateMode = true;
        this.createParameters = createParameters;
        this.updateParameters = null;
        this.inner = null;
    }

    StorageEncryptionHelper(StorageAccountUpdateParameters updateParameters, StorageAccountInner inner) {
        this.isInCreateMode = false;
        this.createParameters = null;
        this.updateParameters = updateParameters;
        this.inner = inner;
    }

    static StorageAccountEncryptionKeySource encryptionKeySource(StorageAccountInner inner) {
        if (inner.encryption() == null || inner.encryption().keySource() == null) {
            return null;
        }
        return StorageAccountEncryptionKeySource.fromString(inner.encryption().keySource().toString());
    }

    static Map<StorageService, StorageAccountEncryptionStatus> encryptionStatuses(StorageAccountInner inner) {
        HashMap<StorageService, StorageAccountEncryptionStatus> statuses = new HashMap<StorageService, StorageAccountEncryptionStatus>();
        EncryptionServices services = null;
        if (inner.encryption() != null) {
            services = inner.encryption().services();
        }
        statuses.put(StorageService.BLOB, new BlobServiceEncryptionStatusImpl(services));
        statuses.put(StorageService.FILE, new FileServiceEncryptionStatusImpl(services));
        statuses.put(StorageService.TABLE, new TableServiceEncryptionStatusImpl(services));
        statuses.put(StorageService.QUEUE, new QueueServiceEncryptionStatusImpl(services));
        return statuses;
    }

    boolean infrastructureEncryptionEnabled() {
        return this.inner != null && this.inner.encryption() != null && ResourceManagerUtils.toPrimitiveBoolean((Boolean)this.inner.encryption().requireInfrastructureEncryption());
    }

    StorageEncryptionHelper withBlobEncryption() {
        Encryption encryption = this.getEncryptionConfig(true);
        if (encryption.services() == null) {
            encryption.withServices(new EncryptionServices());
        }
        if (encryption.services().blob() == null) {
            encryption.services().withBlob(new EncryptionService());
        }
        encryption.services().blob().withEnabled(true);
        if (encryption.keySource() == null) {
            encryption.withKeySource(KeySource.MICROSOFT_STORAGE);
        }
        return this;
    }

    StorageEncryptionHelper withFileEncryption() {
        Encryption encryption = this.getEncryptionConfig(true);
        if (encryption.services() == null) {
            encryption.withServices(new EncryptionServices());
        }
        if (encryption.services().file() == null) {
            encryption.services().withFile(new EncryptionService());
        }
        encryption.services().file().withEnabled(true);
        if (encryption.keySource() == null) {
            encryption.withKeySource(KeySource.MICROSOFT_STORAGE);
        }
        return this;
    }

    StorageEncryptionHelper withTableEncryption() {
        Encryption encryption = this.getEncryptionConfig(true);
        if (encryption.services() == null) {
            encryption.withServices(new EncryptionServices());
        }
        if (encryption.services().table() == null) {
            encryption.services().withTable(new EncryptionService());
        }
        encryption.services().table().withEnabled(true);
        encryption.services().table().withKeyType(KeyType.ACCOUNT);
        if (encryption.keySource() == null) {
            encryption.withKeySource(KeySource.MICROSOFT_STORAGE);
        }
        return this;
    }

    StorageEncryptionHelper withQueueEncryption() {
        Encryption encryption = this.getEncryptionConfig(true);
        if (encryption.services() == null) {
            encryption.withServices(new EncryptionServices());
        }
        if (encryption.services().queue() == null) {
            encryption.services().withQueue(new EncryptionService());
        }
        encryption.services().queue().withEnabled(true);
        encryption.services().queue().withKeyType(KeyType.ACCOUNT);
        if (encryption.keySource() == null) {
            encryption.withKeySource(KeySource.MICROSOFT_STORAGE);
        }
        return this;
    }

    StorageEncryptionHelper withInfrastructureEncryption() {
        Encryption encryption = this.getEncryptionConfig(true);
        encryption.withRequireInfrastructureEncryption(true);
        return this;
    }

    StorageEncryptionHelper withEncryptionKeyFromKeyVault(String keyVaultUri, String keyName, String keyVersion) {
        Encryption encryption = this.getEncryptionConfig(true);
        encryption.withKeySource(KeySource.MICROSOFT_KEYVAULT);
        encryption.withKeyVaultProperties(new KeyVaultProperties().withKeyVaultUri(keyVaultUri).withKeyName(keyName).withKeyVersion(keyVersion));
        return this;
    }

    StorageEncryptionHelper withoutBlobEncryption() {
        Encryption encryption = this.getEncryptionConfig(true);
        if (encryption.services() == null) {
            encryption.withServices(new EncryptionServices());
        }
        if (encryption.services().blob() == null) {
            encryption.services().withBlob(new EncryptionService());
        }
        encryption.services().blob().withEnabled(false);
        if (encryption.keySource() == null) {
            encryption.withKeySource(KeySource.MICROSOFT_STORAGE);
        }
        return this;
    }

    StorageEncryptionHelper withoutFileEncryption() {
        Encryption encryption = this.getEncryptionConfig(true);
        if (encryption.services() == null) {
            encryption.withServices(new EncryptionServices());
        }
        if (encryption.services().file() == null) {
            encryption.services().withFile(new EncryptionService());
        }
        encryption.services().file().withEnabled(false);
        if (encryption.keySource() == null) {
            encryption.withKeySource(KeySource.MICROSOFT_STORAGE);
        }
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Encryption getEncryptionConfig(boolean createIfNotExists) {
        if (this.isInCreateMode) {
            if (this.createParameters.encryption() != null) return this.createParameters.encryption();
            if (!createIfNotExists) return null;
            this.createParameters.withEncryption(new Encryption());
            return this.createParameters.encryption();
        }
        if (this.updateParameters.encryption() != null) return this.updateParameters.encryption();
        if (this.inner.encryption() == null) {
            if (!createIfNotExists) return null;
            this.updateParameters.withEncryption(new Encryption());
            return this.updateParameters.encryption();
        } else {
            Encryption clonedEncryption = new Encryption();
            clonedEncryption.withKeySource(this.inner.encryption().keySource());
            if (this.inner.encryption().requireInfrastructureEncryption() != null) {
                clonedEncryption.withRequireInfrastructureEncryption(this.inner.encryption().requireInfrastructureEncryption());
            }
            if (this.inner.encryption().keyVaultProperties() != null) {
                clonedEncryption.withKeyVaultProperties(new KeyVaultProperties());
                clonedEncryption.keyVaultProperties().withKeyName(this.inner.encryption().keyVaultProperties().keyName()).withKeyVaultUri(this.inner.encryption().keyVaultProperties().keyVaultUri()).withKeyVersion(this.inner.encryption().keyVaultProperties().keyVersion());
            }
            if (this.inner.encryption().services() != null) {
                clonedEncryption.withServices(new EncryptionServices());
                if (this.inner.encryption().services().blob() != null) {
                    clonedEncryption.services().withBlob(new EncryptionService());
                    clonedEncryption.services().blob().withEnabled(this.inner.encryption().services().blob().enabled()).withKeyType(this.inner.encryption().services().blob().keyType());
                }
                if (this.inner.encryption().services().file() != null) {
                    clonedEncryption.services().withFile(new EncryptionService());
                    clonedEncryption.services().file().withEnabled(this.inner.encryption().services().file().enabled()).withKeyType(this.inner.encryption().services().file().keyType());
                }
                if (this.inner.encryption().services().table() != null) {
                    clonedEncryption.services().withTable(new EncryptionService());
                    clonedEncryption.services().table().withEnabled(this.inner.encryption().services().table().enabled()).withKeyType(this.inner.encryption().services().table().keyType());
                }
                if (this.inner.encryption().services().queue() != null) {
                    clonedEncryption.services().withQueue(new EncryptionService());
                    clonedEncryption.services().queue().withEnabled(this.inner.encryption().services().queue().enabled()).withKeyType(this.inner.encryption().services().queue().keyType());
                }
            }
            this.updateParameters.withEncryption(clonedEncryption);
        }
        return this.updateParameters.encryption();
    }
}

