/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.service.MonitorService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.model.Server;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.plugin.api.monitor.DatabaseMetrics;
import org.apache.dolphinscheduler.registry.api.enums.RegistryNodeType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="MONITOR_TAG")
@RestController
@RequestMapping(value={"/monitor"})
public class MonitorController
extends BaseController {
    @Autowired
    private MonitorService monitorService;

    @Operation(summary="listServer", description="SERVER_LIST_NOTES")
    @GetMapping(value={"/{nodeType}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.LIST_MASTERS_ERROR)
    public Result<List<Server>> listServer(@PathVariable(value="nodeType") RegistryNodeType nodeType) {
        List<Server> servers = this.monitorService.listServer(nodeType);
        return Result.success(servers);
    }

    @Operation(summary="queryDatabaseState", description="QUERY_DATABASE_STATE_NOTES")
    @GetMapping(value={"/databases"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_DATABASE_STATE_ERROR)
    public Result<List<DatabaseMetrics>> queryDatabaseState(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser) {
        List<DatabaseMetrics> databaseMetrics = this.monitorService.queryDatabaseState(loginUser);
        return Result.success(databaseMetrics);
    }
}

