/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ServiceException;
import org.apache.dolphinscheduler.api.service.AccessTokenService;
import org.apache.dolphinscheduler.api.service.impl.BaseServiceImpl;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.common.enums.AuthorizationType;
import org.apache.dolphinscheduler.common.enums.UserType;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.common.utils.EncryptionUtils;
import org.apache.dolphinscheduler.dao.entity.AccessToken;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.AccessTokenMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AccessTokenServiceImpl
extends BaseServiceImpl
implements AccessTokenService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AccessTokenServiceImpl.class);
    @Autowired
    private AccessTokenMapper accessTokenMapper;

    @Override
    public PageInfo<AccessToken> queryAccessTokenList(User loginUser, String searchVal, Integer pageNo, Integer pageSize) {
        PageInfo<AccessToken> pageInfo = new PageInfo<AccessToken>(pageNo, pageSize);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        int userId = loginUser.getId();
        if (loginUser.getUserType() == UserType.ADMIN_USER) {
            userId = 0;
        }
        IPage accessTokenList = this.accessTokenMapper.selectAccessTokenPage(page, searchVal, userId);
        pageInfo.setTotal((int)accessTokenList.getTotal());
        pageInfo.setTotalList(accessTokenList.getRecords());
        return pageInfo;
    }

    @Override
    public List<AccessToken> queryAccessTokenByUser(User loginUser, Integer userId) {
        if (loginUser.getUserType().equals((Object)UserType.GENERAL_USER) && loginUser.getId() != userId) {
            throw new ServiceException(Status.USER_NO_OPERATION_PERM);
        }
        userId = loginUser.getUserType().equals((Object)UserType.ADMIN_USER) ? 0 : userId;
        List accessTokenList = this.accessTokenMapper.queryAccessTokenByUser(userId.intValue());
        return accessTokenList;
    }

    @Override
    public AccessToken createToken(User loginUser, int userId, String expireTime, String token) {
        if (!this.canOperatorPermissions(loginUser, null, AuthorizationType.ACCESS_TOKEN, "security:token:create") && loginUser.getId() != userId) {
            throw new ServiceException(Status.USER_NO_OPERATION_PERM);
        }
        if (userId <= 0) {
            throw new ServiceException(Status.REQUEST_PARAMS_NOT_VALID_ERROR, "User id: " + userId + " should not less than or equals to 0.");
        }
        if (StringUtils.isBlank((CharSequence)token)) {
            token = EncryptionUtils.getMd5((String)(userId + expireTime + System.currentTimeMillis()));
        }
        AccessToken accessToken = new AccessToken();
        accessToken.setUserId(userId);
        accessToken.setExpireTime(DateUtils.stringToDate((String)expireTime));
        accessToken.setToken(token);
        accessToken.setCreateTime(new Date());
        accessToken.setUpdateTime(new Date());
        int insert = this.accessTokenMapper.insert((Object)accessToken);
        if (insert > 0) {
            return accessToken;
        }
        throw new ServiceException(Status.CREATE_ACCESS_TOKEN_ERROR);
    }

    @Override
    public String generateToken(User loginUser, int userId, String expireTime) {
        return EncryptionUtils.getMd5((String)(userId + expireTime + System.currentTimeMillis()));
    }

    @Override
    public void deleteAccessTokenById(User loginUser, int id) {
        if (!this.canOperatorPermissions(loginUser, null, AuthorizationType.ACCESS_TOKEN, "security:token:delete")) {
            throw new ServiceException(Status.USER_NO_OPERATION_PERM);
        }
        AccessToken accessToken = (AccessToken)this.accessTokenMapper.selectById((Serializable)Integer.valueOf(id));
        if (accessToken == null) {
            throw new ServiceException(Status.ACCESS_TOKEN_NOT_EXIST, id);
        }
        if (accessToken.getUserId() != loginUser.getId().intValue() && !loginUser.getUserType().equals((Object)UserType.ADMIN_USER)) {
            throw new ServiceException(Status.USER_NO_OPERATION_PERM);
        }
        this.accessTokenMapper.deleteById((Serializable)Integer.valueOf(id));
    }

    @Override
    public AccessToken updateToken(User loginUser, int id, int userId, String expireTime, String token) {
        if (!this.canOperatorPermissions(loginUser, null, AuthorizationType.ACCESS_TOKEN, "security:token:update")) {
            throw new ServiceException(Status.USER_NO_OPERATION_PERM);
        }
        AccessToken accessToken = (AccessToken)this.accessTokenMapper.selectById((Serializable)Integer.valueOf(id));
        if (accessToken == null) {
            log.error("Access token does not exist, accessTokenId:{}.", (Object)id);
            throw new ServiceException(Status.ACCESS_TOKEN_NOT_EXIST, id);
        }
        if (accessToken.getUserId() != loginUser.getId().intValue() && !loginUser.getUserType().equals((Object)UserType.ADMIN_USER)) {
            throw new ServiceException(Status.USER_NO_OPERATION_PERM);
        }
        if (StringUtils.isBlank((CharSequence)token)) {
            token = EncryptionUtils.getMd5((String)(userId + expireTime + System.currentTimeMillis()));
        }
        accessToken.setUserId(userId);
        accessToken.setExpireTime(DateUtils.stringToDate((String)expireTime));
        accessToken.setToken(token);
        accessToken.setUpdateTime(new Date());
        int i = this.accessTokenMapper.updateById((Object)accessToken);
        if (i <= 0) {
            throw new ServiceException(Status.ACCESS_TOKEN_NOT_EXIST, id);
        }
        return accessToken;
    }
}

