/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.validator.resource;

import org.apache.dolphinscheduler.api.dto.resources.CreateFileDto;
import org.apache.dolphinscheduler.api.validator.resource.AbstractResourceValidator;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.repository.TenantDao;
import org.apache.dolphinscheduler.plugin.storage.api.StorageOperator;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class CreateFileDtoValidator
extends AbstractResourceValidator<CreateFileDto> {
    public CreateFileDtoValidator(StorageOperator storageOperator, TenantDao tenantDao) {
        super(storageOperator, tenantDao);
    }

    @Override
    public void validate(CreateFileDto createFileDto) {
        String fileAbsolutePath = createFileDto.getFileAbsolutePath();
        User loginUser = createFileDto.getLoginUser();
        MultipartFile file = createFileDto.getFile();
        this.exceptionResourceAbsolutePathInvalidated(fileAbsolutePath);
        this.exceptionResourceExists(fileAbsolutePath);
        this.exceptionFileInvalidated(file);
        this.exceptionUserNoResourcePermission(loginUser, fileAbsolutePath);
        this.exceptionResourceIsNotFile(fileAbsolutePath);
    }
}

