/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.EdgeModelSummary;
import com.amazonaws.services.sagemaker.model.transform.DeviceSummaryMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class DeviceSummary
implements Serializable,
Cloneable,
StructuredPojo {
    private String deviceName;
    private String deviceArn;
    private String description;
    private String deviceFleetName;
    private String iotThingName;
    private Date registrationTime;
    private Date latestHeartbeat;
    private List<EdgeModelSummary> models;
    private String agentVersion;

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public DeviceSummary withDeviceName(String deviceName) {
        this.setDeviceName(deviceName);
        return this;
    }

    public void setDeviceArn(String deviceArn) {
        this.deviceArn = deviceArn;
    }

    public String getDeviceArn() {
        return this.deviceArn;
    }

    public DeviceSummary withDeviceArn(String deviceArn) {
        this.setDeviceArn(deviceArn);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public DeviceSummary withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setDeviceFleetName(String deviceFleetName) {
        this.deviceFleetName = deviceFleetName;
    }

    public String getDeviceFleetName() {
        return this.deviceFleetName;
    }

    public DeviceSummary withDeviceFleetName(String deviceFleetName) {
        this.setDeviceFleetName(deviceFleetName);
        return this;
    }

    public void setIotThingName(String iotThingName) {
        this.iotThingName = iotThingName;
    }

    public String getIotThingName() {
        return this.iotThingName;
    }

    public DeviceSummary withIotThingName(String iotThingName) {
        this.setIotThingName(iotThingName);
        return this;
    }

    public void setRegistrationTime(Date registrationTime) {
        this.registrationTime = registrationTime;
    }

    public Date getRegistrationTime() {
        return this.registrationTime;
    }

    public DeviceSummary withRegistrationTime(Date registrationTime) {
        this.setRegistrationTime(registrationTime);
        return this;
    }

    public void setLatestHeartbeat(Date latestHeartbeat) {
        this.latestHeartbeat = latestHeartbeat;
    }

    public Date getLatestHeartbeat() {
        return this.latestHeartbeat;
    }

    public DeviceSummary withLatestHeartbeat(Date latestHeartbeat) {
        this.setLatestHeartbeat(latestHeartbeat);
        return this;
    }

    public List<EdgeModelSummary> getModels() {
        return this.models;
    }

    public void setModels(Collection<EdgeModelSummary> models) {
        if (models == null) {
            this.models = null;
            return;
        }
        this.models = new ArrayList<EdgeModelSummary>(models);
    }

    public DeviceSummary withModels(EdgeModelSummary ... models) {
        if (this.models == null) {
            this.setModels(new ArrayList<EdgeModelSummary>(models.length));
        }
        for (EdgeModelSummary ele : models) {
            this.models.add(ele);
        }
        return this;
    }

    public DeviceSummary withModels(Collection<EdgeModelSummary> models) {
        this.setModels(models);
        return this;
    }

    public void setAgentVersion(String agentVersion) {
        this.agentVersion = agentVersion;
    }

    public String getAgentVersion() {
        return this.agentVersion;
    }

    public DeviceSummary withAgentVersion(String agentVersion) {
        this.setAgentVersion(agentVersion);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDeviceName() != null) {
            sb.append("DeviceName: ").append(this.getDeviceName()).append(",");
        }
        if (this.getDeviceArn() != null) {
            sb.append("DeviceArn: ").append(this.getDeviceArn()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getDeviceFleetName() != null) {
            sb.append("DeviceFleetName: ").append(this.getDeviceFleetName()).append(",");
        }
        if (this.getIotThingName() != null) {
            sb.append("IotThingName: ").append(this.getIotThingName()).append(",");
        }
        if (this.getRegistrationTime() != null) {
            sb.append("RegistrationTime: ").append(this.getRegistrationTime()).append(",");
        }
        if (this.getLatestHeartbeat() != null) {
            sb.append("LatestHeartbeat: ").append(this.getLatestHeartbeat()).append(",");
        }
        if (this.getModels() != null) {
            sb.append("Models: ").append(this.getModels()).append(",");
        }
        if (this.getAgentVersion() != null) {
            sb.append("AgentVersion: ").append(this.getAgentVersion());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceSummary)) {
            return false;
        }
        DeviceSummary other = (DeviceSummary)obj;
        if (other.getDeviceName() == null ^ this.getDeviceName() == null) {
            return false;
        }
        if (other.getDeviceName() != null && !other.getDeviceName().equals(this.getDeviceName())) {
            return false;
        }
        if (other.getDeviceArn() == null ^ this.getDeviceArn() == null) {
            return false;
        }
        if (other.getDeviceArn() != null && !other.getDeviceArn().equals(this.getDeviceArn())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getDeviceFleetName() == null ^ this.getDeviceFleetName() == null) {
            return false;
        }
        if (other.getDeviceFleetName() != null && !other.getDeviceFleetName().equals(this.getDeviceFleetName())) {
            return false;
        }
        if (other.getIotThingName() == null ^ this.getIotThingName() == null) {
            return false;
        }
        if (other.getIotThingName() != null && !other.getIotThingName().equals(this.getIotThingName())) {
            return false;
        }
        if (other.getRegistrationTime() == null ^ this.getRegistrationTime() == null) {
            return false;
        }
        if (other.getRegistrationTime() != null && !other.getRegistrationTime().equals(this.getRegistrationTime())) {
            return false;
        }
        if (other.getLatestHeartbeat() == null ^ this.getLatestHeartbeat() == null) {
            return false;
        }
        if (other.getLatestHeartbeat() != null && !other.getLatestHeartbeat().equals(this.getLatestHeartbeat())) {
            return false;
        }
        if (other.getModels() == null ^ this.getModels() == null) {
            return false;
        }
        if (other.getModels() != null && !other.getModels().equals(this.getModels())) {
            return false;
        }
        if (other.getAgentVersion() == null ^ this.getAgentVersion() == null) {
            return false;
        }
        return other.getAgentVersion() == null || other.getAgentVersion().equals(this.getAgentVersion());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDeviceName() == null ? 0 : this.getDeviceName().hashCode());
        hashCode = 31 * hashCode + (this.getDeviceArn() == null ? 0 : this.getDeviceArn().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getDeviceFleetName() == null ? 0 : this.getDeviceFleetName().hashCode());
        hashCode = 31 * hashCode + (this.getIotThingName() == null ? 0 : this.getIotThingName().hashCode());
        hashCode = 31 * hashCode + (this.getRegistrationTime() == null ? 0 : this.getRegistrationTime().hashCode());
        hashCode = 31 * hashCode + (this.getLatestHeartbeat() == null ? 0 : this.getLatestHeartbeat().hashCode());
        hashCode = 31 * hashCode + (this.getModels() == null ? 0 : this.getModels().hashCode());
        hashCode = 31 * hashCode + (this.getAgentVersion() == null ? 0 : this.getAgentVersion().hashCode());
        return hashCode;
    }

    public DeviceSummary clone() {
        try {
            return (DeviceSummary)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DeviceSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

