/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.internal.crypto;

import com.qcloud.cos.internal.crypto.COSKeyWrapScheme;
import com.qcloud.cos.internal.crypto.ContentCryptoScheme;
import com.qcloud.cos.internal.crypto.CryptoMode;
import java.security.SecureRandom;

final class COSCryptoScheme {
    static final String AES = "AES";
    static final String RSA = "RSA";
    private static final SecureRandom srand = new SecureRandom();
    private final COSKeyWrapScheme kwScheme;
    private final ContentCryptoScheme contentCryptoScheme;

    private COSCryptoScheme(ContentCryptoScheme contentCryptoScheme, COSKeyWrapScheme kwScheme) {
        this.contentCryptoScheme = contentCryptoScheme;
        this.kwScheme = kwScheme;
    }

    SecureRandom getSecureRandom() {
        return srand;
    }

    ContentCryptoScheme getContentCryptoScheme() {
        return this.contentCryptoScheme;
    }

    COSKeyWrapScheme getKeyWrapScheme() {
        return this.kwScheme;
    }

    static boolean isAesGcm(String cipherAlgorithm) {
        return ContentCryptoScheme.AES_GCM.getCipherAlgorithm().equals(cipherAlgorithm);
    }

    static COSCryptoScheme from(CryptoMode mode) {
        switch (mode) {
            case AesCbcEncryption: {
                return new COSCryptoScheme(ContentCryptoScheme.AES_CBC, new COSKeyWrapScheme());
            }
            case AesCtrEncryption: {
                return new COSCryptoScheme(ContentCryptoScheme.AES_CTR, new COSKeyWrapScheme());
            }
            case AuthenticatedEncryption: 
            case StrictAuthenticatedEncryption: {
                return new COSCryptoScheme(ContentCryptoScheme.AES_GCM, new COSKeyWrapScheme());
            }
        }
        throw new IllegalStateException();
    }
}

