/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.monitor.fluent.ActionGroupsClient;
import com.azure.resourcemanager.monitor.fluent.models.ActionGroupResourceInner;
import com.azure.resourcemanager.monitor.fluent.models.TestNotificationDetailsResponseInner;
import com.azure.resourcemanager.monitor.implementation.MonitorClientImpl;
import com.azure.resourcemanager.monitor.models.ActionGroupList;
import com.azure.resourcemanager.monitor.models.ActionGroupPatchBody;
import com.azure.resourcemanager.monitor.models.EnableRequest;
import com.azure.resourcemanager.monitor.models.NotificationRequestBody;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsGet;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ActionGroupsClientImpl
implements InnerSupportsGet<ActionGroupResourceInner>,
InnerSupportsListing<ActionGroupResourceInner>,
InnerSupportsDelete<Void>,
ActionGroupsClient {
    private final ActionGroupsService service;
    private final MonitorClientImpl client;

    ActionGroupsClientImpl(MonitorClientImpl client) {
        this.service = (ActionGroupsService)RestProxy.create(ActionGroupsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ActionGroupResourceInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String actionGroupName, ActionGroupResourceInner actionGroup) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (actionGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter actionGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (actionGroup == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter actionGroup is required and cannot be null."));
        }
        actionGroup.validate();
        String apiVersion = "2022-06-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, actionGroupName, this.client.getSubscriptionId(), "2022-06-01", actionGroup, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ActionGroupResourceInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String actionGroupName, ActionGroupResourceInner actionGroup, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (actionGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter actionGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (actionGroup == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter actionGroup is required and cannot be null."));
        }
        actionGroup.validate();
        String apiVersion = "2022-06-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, actionGroupName, this.client.getSubscriptionId(), "2022-06-01", actionGroup, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ActionGroupResourceInner> createOrUpdateAsync(String resourceGroupName, String actionGroupName, ActionGroupResourceInner actionGroup) {
        return this.createOrUpdateWithResponseAsync(resourceGroupName, actionGroupName, actionGroup).flatMap(res -> Mono.justOrEmpty((Object)((Object)((ActionGroupResourceInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ActionGroupResourceInner createOrUpdate(String resourceGroupName, String actionGroupName, ActionGroupResourceInner actionGroup) {
        return (ActionGroupResourceInner)((Object)this.createOrUpdateAsync(resourceGroupName, actionGroupName, actionGroup).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ActionGroupResourceInner> createOrUpdateWithResponse(String resourceGroupName, String actionGroupName, ActionGroupResourceInner actionGroup, Context context) {
        return (Response)this.createOrUpdateWithResponseAsync(resourceGroupName, actionGroupName, actionGroup, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ActionGroupResourceInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String actionGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (actionGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter actionGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2022-06-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getByResourceGroup(this.client.getEndpoint(), resourceGroupName, actionGroupName, this.client.getSubscriptionId(), "2022-06-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ActionGroupResourceInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String actionGroupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (actionGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter actionGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2022-06-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getByResourceGroup(this.client.getEndpoint(), resourceGroupName, actionGroupName, this.client.getSubscriptionId(), "2022-06-01", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ActionGroupResourceInner> getByResourceGroupAsync(String resourceGroupName, String actionGroupName) {
        return this.getByResourceGroupWithResponseAsync(resourceGroupName, actionGroupName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((ActionGroupResourceInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ActionGroupResourceInner getByResourceGroup(String resourceGroupName, String actionGroupName) {
        return (ActionGroupResourceInner)((Object)this.getByResourceGroupAsync(resourceGroupName, actionGroupName).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ActionGroupResourceInner> getByResourceGroupWithResponse(String resourceGroupName, String actionGroupName, Context context) {
        return (Response)this.getByResourceGroupWithResponseAsync(resourceGroupName, actionGroupName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String actionGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (actionGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter actionGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2022-06-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, actionGroupName, this.client.getSubscriptionId(), "2022-06-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String actionGroupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (actionGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter actionGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2022-06-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, actionGroupName, this.client.getSubscriptionId(), "2022-06-01", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String actionGroupName) {
        return this.deleteWithResponseAsync(resourceGroupName, actionGroupName).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String actionGroupName) {
        this.deleteAsync(resourceGroupName, actionGroupName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceGroupName, String actionGroupName, Context context) {
        return (Response)this.deleteWithResponseAsync(resourceGroupName, actionGroupName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ActionGroupResourceInner>> updateWithResponseAsync(String resourceGroupName, String actionGroupName, ActionGroupPatchBody actionGroupPatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (actionGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter actionGroupName is required and cannot be null."));
        }
        if (actionGroupPatch == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter actionGroupPatch is required and cannot be null."));
        }
        actionGroupPatch.validate();
        String apiVersion = "2022-06-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, actionGroupName, "2022-06-01", actionGroupPatch, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ActionGroupResourceInner>> updateWithResponseAsync(String resourceGroupName, String actionGroupName, ActionGroupPatchBody actionGroupPatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (actionGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter actionGroupName is required and cannot be null."));
        }
        if (actionGroupPatch == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter actionGroupPatch is required and cannot be null."));
        }
        actionGroupPatch.validate();
        String apiVersion = "2022-06-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, actionGroupName, "2022-06-01", actionGroupPatch, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ActionGroupResourceInner> updateAsync(String resourceGroupName, String actionGroupName, ActionGroupPatchBody actionGroupPatch) {
        return this.updateWithResponseAsync(resourceGroupName, actionGroupName, actionGroupPatch).flatMap(res -> Mono.justOrEmpty((Object)((Object)((ActionGroupResourceInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ActionGroupResourceInner update(String resourceGroupName, String actionGroupName, ActionGroupPatchBody actionGroupPatch) {
        return (ActionGroupResourceInner)((Object)this.updateAsync(resourceGroupName, actionGroupName, actionGroupPatch).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ActionGroupResourceInner> updateWithResponse(String resourceGroupName, String actionGroupName, ActionGroupPatchBody actionGroupPatch, Context context) {
        return (Response)this.updateWithResponseAsync(resourceGroupName, actionGroupName, actionGroupPatch, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> postTestNotificationsWithResponseAsync(NotificationRequestBody notificationRequest) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (notificationRequest == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter notificationRequest is required and cannot be null."));
        }
        notificationRequest.validate();
        String apiVersion = "2022-06-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.postTestNotifications(this.client.getEndpoint(), this.client.getSubscriptionId(), "2022-06-01", notificationRequest, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> postTestNotificationsWithResponseAsync(NotificationRequestBody notificationRequest, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (notificationRequest == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter notificationRequest is required and cannot be null."));
        }
        notificationRequest.validate();
        String apiVersion = "2022-06-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.postTestNotifications(this.client.getEndpoint(), this.client.getSubscriptionId(), "2022-06-01", notificationRequest, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<TestNotificationDetailsResponseInner>, TestNotificationDetailsResponseInner> beginPostTestNotificationsAsync(NotificationRequestBody notificationRequest) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.postTestNotificationsWithResponseAsync(notificationRequest);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)TestNotificationDetailsResponseInner.class), (Type)((Object)TestNotificationDetailsResponseInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<TestNotificationDetailsResponseInner>, TestNotificationDetailsResponseInner> beginPostTestNotificationsAsync(NotificationRequestBody notificationRequest, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.postTestNotificationsWithResponseAsync(notificationRequest, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)TestNotificationDetailsResponseInner.class), (Type)((Object)TestNotificationDetailsResponseInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<TestNotificationDetailsResponseInner>, TestNotificationDetailsResponseInner> beginPostTestNotifications(NotificationRequestBody notificationRequest) {
        return this.beginPostTestNotificationsAsync(notificationRequest).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<TestNotificationDetailsResponseInner>, TestNotificationDetailsResponseInner> beginPostTestNotifications(NotificationRequestBody notificationRequest, Context context) {
        return this.beginPostTestNotificationsAsync(notificationRequest, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TestNotificationDetailsResponseInner> postTestNotificationsAsync(NotificationRequestBody notificationRequest) {
        return this.beginPostTestNotificationsAsync(notificationRequest).last().flatMap(arg_0 -> ((MonitorClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<TestNotificationDetailsResponseInner> postTestNotificationsAsync(NotificationRequestBody notificationRequest, Context context) {
        return this.beginPostTestNotificationsAsync(notificationRequest, context).last().flatMap(arg_0 -> ((MonitorClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public TestNotificationDetailsResponseInner postTestNotifications(NotificationRequestBody notificationRequest) {
        return (TestNotificationDetailsResponseInner)this.postTestNotificationsAsync(notificationRequest).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public TestNotificationDetailsResponseInner postTestNotifications(NotificationRequestBody notificationRequest, Context context) {
        return (TestNotificationDetailsResponseInner)this.postTestNotificationsAsync(notificationRequest, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createNotificationsAtResourceGroupLevelWithResponseAsync(String resourceGroupName, NotificationRequestBody notificationRequest) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (notificationRequest == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter notificationRequest is required and cannot be null."));
        }
        notificationRequest.validate();
        String apiVersion = "2022-06-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createNotificationsAtResourceGroupLevel(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, "2022-06-01", notificationRequest, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createNotificationsAtResourceGroupLevelWithResponseAsync(String resourceGroupName, NotificationRequestBody notificationRequest, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (notificationRequest == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter notificationRequest is required and cannot be null."));
        }
        notificationRequest.validate();
        String apiVersion = "2022-06-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createNotificationsAtResourceGroupLevel(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, "2022-06-01", notificationRequest, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<TestNotificationDetailsResponseInner>, TestNotificationDetailsResponseInner> beginCreateNotificationsAtResourceGroupLevelAsync(String resourceGroupName, NotificationRequestBody notificationRequest) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createNotificationsAtResourceGroupLevelWithResponseAsync(resourceGroupName, notificationRequest);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)TestNotificationDetailsResponseInner.class), (Type)((Object)TestNotificationDetailsResponseInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<TestNotificationDetailsResponseInner>, TestNotificationDetailsResponseInner> beginCreateNotificationsAtResourceGroupLevelAsync(String resourceGroupName, NotificationRequestBody notificationRequest, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createNotificationsAtResourceGroupLevelWithResponseAsync(resourceGroupName, notificationRequest, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)TestNotificationDetailsResponseInner.class), (Type)((Object)TestNotificationDetailsResponseInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<TestNotificationDetailsResponseInner>, TestNotificationDetailsResponseInner> beginCreateNotificationsAtResourceGroupLevel(String resourceGroupName, NotificationRequestBody notificationRequest) {
        return this.beginCreateNotificationsAtResourceGroupLevelAsync(resourceGroupName, notificationRequest).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<TestNotificationDetailsResponseInner>, TestNotificationDetailsResponseInner> beginCreateNotificationsAtResourceGroupLevel(String resourceGroupName, NotificationRequestBody notificationRequest, Context context) {
        return this.beginCreateNotificationsAtResourceGroupLevelAsync(resourceGroupName, notificationRequest, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TestNotificationDetailsResponseInner> createNotificationsAtResourceGroupLevelAsync(String resourceGroupName, NotificationRequestBody notificationRequest) {
        return this.beginCreateNotificationsAtResourceGroupLevelAsync(resourceGroupName, notificationRequest).last().flatMap(arg_0 -> ((MonitorClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<TestNotificationDetailsResponseInner> createNotificationsAtResourceGroupLevelAsync(String resourceGroupName, NotificationRequestBody notificationRequest, Context context) {
        return this.beginCreateNotificationsAtResourceGroupLevelAsync(resourceGroupName, notificationRequest, context).last().flatMap(arg_0 -> ((MonitorClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public TestNotificationDetailsResponseInner createNotificationsAtResourceGroupLevel(String resourceGroupName, NotificationRequestBody notificationRequest) {
        return (TestNotificationDetailsResponseInner)this.createNotificationsAtResourceGroupLevelAsync(resourceGroupName, notificationRequest).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public TestNotificationDetailsResponseInner createNotificationsAtResourceGroupLevel(String resourceGroupName, NotificationRequestBody notificationRequest, Context context) {
        return (TestNotificationDetailsResponseInner)this.createNotificationsAtResourceGroupLevelAsync(resourceGroupName, notificationRequest, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createNotificationsAtActionGroupResourceLevelWithResponseAsync(String resourceGroupName, String actionGroupName, NotificationRequestBody notificationRequest) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (actionGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter actionGroupName is required and cannot be null."));
        }
        if (notificationRequest == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter notificationRequest is required and cannot be null."));
        }
        notificationRequest.validate();
        String apiVersion = "2022-06-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createNotificationsAtActionGroupResourceLevel(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, actionGroupName, "2022-06-01", notificationRequest, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createNotificationsAtActionGroupResourceLevelWithResponseAsync(String resourceGroupName, String actionGroupName, NotificationRequestBody notificationRequest, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (actionGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter actionGroupName is required and cannot be null."));
        }
        if (notificationRequest == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter notificationRequest is required and cannot be null."));
        }
        notificationRequest.validate();
        String apiVersion = "2022-06-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createNotificationsAtActionGroupResourceLevel(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, actionGroupName, "2022-06-01", notificationRequest, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<TestNotificationDetailsResponseInner>, TestNotificationDetailsResponseInner> beginCreateNotificationsAtActionGroupResourceLevelAsync(String resourceGroupName, String actionGroupName, NotificationRequestBody notificationRequest) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createNotificationsAtActionGroupResourceLevelWithResponseAsync(resourceGroupName, actionGroupName, notificationRequest);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)TestNotificationDetailsResponseInner.class), (Type)((Object)TestNotificationDetailsResponseInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<TestNotificationDetailsResponseInner>, TestNotificationDetailsResponseInner> beginCreateNotificationsAtActionGroupResourceLevelAsync(String resourceGroupName, String actionGroupName, NotificationRequestBody notificationRequest, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createNotificationsAtActionGroupResourceLevelWithResponseAsync(resourceGroupName, actionGroupName, notificationRequest, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)TestNotificationDetailsResponseInner.class), (Type)((Object)TestNotificationDetailsResponseInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<TestNotificationDetailsResponseInner>, TestNotificationDetailsResponseInner> beginCreateNotificationsAtActionGroupResourceLevel(String resourceGroupName, String actionGroupName, NotificationRequestBody notificationRequest) {
        return this.beginCreateNotificationsAtActionGroupResourceLevelAsync(resourceGroupName, actionGroupName, notificationRequest).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<TestNotificationDetailsResponseInner>, TestNotificationDetailsResponseInner> beginCreateNotificationsAtActionGroupResourceLevel(String resourceGroupName, String actionGroupName, NotificationRequestBody notificationRequest, Context context) {
        return this.beginCreateNotificationsAtActionGroupResourceLevelAsync(resourceGroupName, actionGroupName, notificationRequest, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TestNotificationDetailsResponseInner> createNotificationsAtActionGroupResourceLevelAsync(String resourceGroupName, String actionGroupName, NotificationRequestBody notificationRequest) {
        return this.beginCreateNotificationsAtActionGroupResourceLevelAsync(resourceGroupName, actionGroupName, notificationRequest).last().flatMap(arg_0 -> ((MonitorClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<TestNotificationDetailsResponseInner> createNotificationsAtActionGroupResourceLevelAsync(String resourceGroupName, String actionGroupName, NotificationRequestBody notificationRequest, Context context) {
        return this.beginCreateNotificationsAtActionGroupResourceLevelAsync(resourceGroupName, actionGroupName, notificationRequest, context).last().flatMap(arg_0 -> ((MonitorClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public TestNotificationDetailsResponseInner createNotificationsAtActionGroupResourceLevel(String resourceGroupName, String actionGroupName, NotificationRequestBody notificationRequest) {
        return (TestNotificationDetailsResponseInner)this.createNotificationsAtActionGroupResourceLevelAsync(resourceGroupName, actionGroupName, notificationRequest).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public TestNotificationDetailsResponseInner createNotificationsAtActionGroupResourceLevel(String resourceGroupName, String actionGroupName, NotificationRequestBody notificationRequest, Context context) {
        return (TestNotificationDetailsResponseInner)this.createNotificationsAtActionGroupResourceLevelAsync(resourceGroupName, actionGroupName, notificationRequest, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<TestNotificationDetailsResponseInner>> getTestNotificationsWithResponseAsync(String notificationId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (notificationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter notificationId is required and cannot be null."));
        }
        String apiVersion = "2022-06-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getTestNotifications(this.client.getEndpoint(), this.client.getSubscriptionId(), notificationId, "2022-06-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<TestNotificationDetailsResponseInner>> getTestNotificationsWithResponseAsync(String notificationId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (notificationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter notificationId is required and cannot be null."));
        }
        String apiVersion = "2022-06-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getTestNotifications(this.client.getEndpoint(), this.client.getSubscriptionId(), notificationId, "2022-06-01", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TestNotificationDetailsResponseInner> getTestNotificationsAsync(String notificationId) {
        return this.getTestNotificationsWithResponseAsync(notificationId).flatMap(res -> Mono.justOrEmpty((Object)((TestNotificationDetailsResponseInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public TestNotificationDetailsResponseInner getTestNotifications(String notificationId) {
        return (TestNotificationDetailsResponseInner)this.getTestNotificationsAsync(notificationId).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<TestNotificationDetailsResponseInner> getTestNotificationsWithResponse(String notificationId, Context context) {
        return (Response)this.getTestNotificationsWithResponseAsync(notificationId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<TestNotificationDetailsResponseInner>> getTestNotificationsAtResourceGroupLevelWithResponseAsync(String resourceGroupName, String notificationId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (notificationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter notificationId is required and cannot be null."));
        }
        String apiVersion = "2022-06-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getTestNotificationsAtResourceGroupLevel(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, notificationId, "2022-06-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<TestNotificationDetailsResponseInner>> getTestNotificationsAtResourceGroupLevelWithResponseAsync(String resourceGroupName, String notificationId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (notificationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter notificationId is required and cannot be null."));
        }
        String apiVersion = "2022-06-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getTestNotificationsAtResourceGroupLevel(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, notificationId, "2022-06-01", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TestNotificationDetailsResponseInner> getTestNotificationsAtResourceGroupLevelAsync(String resourceGroupName, String notificationId) {
        return this.getTestNotificationsAtResourceGroupLevelWithResponseAsync(resourceGroupName, notificationId).flatMap(res -> Mono.justOrEmpty((Object)((TestNotificationDetailsResponseInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public TestNotificationDetailsResponseInner getTestNotificationsAtResourceGroupLevel(String resourceGroupName, String notificationId) {
        return (TestNotificationDetailsResponseInner)this.getTestNotificationsAtResourceGroupLevelAsync(resourceGroupName, notificationId).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<TestNotificationDetailsResponseInner> getTestNotificationsAtResourceGroupLevelWithResponse(String resourceGroupName, String notificationId, Context context) {
        return (Response)this.getTestNotificationsAtResourceGroupLevelWithResponseAsync(resourceGroupName, notificationId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<TestNotificationDetailsResponseInner>> getTestNotificationsAtActionGroupResourceLevelWithResponseAsync(String resourceGroupName, String actionGroupName, String notificationId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (actionGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter actionGroupName is required and cannot be null."));
        }
        if (notificationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter notificationId is required and cannot be null."));
        }
        String apiVersion = "2022-06-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getTestNotificationsAtActionGroupResourceLevel(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, actionGroupName, notificationId, "2022-06-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<TestNotificationDetailsResponseInner>> getTestNotificationsAtActionGroupResourceLevelWithResponseAsync(String resourceGroupName, String actionGroupName, String notificationId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (actionGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter actionGroupName is required and cannot be null."));
        }
        if (notificationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter notificationId is required and cannot be null."));
        }
        String apiVersion = "2022-06-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getTestNotificationsAtActionGroupResourceLevel(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, actionGroupName, notificationId, "2022-06-01", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TestNotificationDetailsResponseInner> getTestNotificationsAtActionGroupResourceLevelAsync(String resourceGroupName, String actionGroupName, String notificationId) {
        return this.getTestNotificationsAtActionGroupResourceLevelWithResponseAsync(resourceGroupName, actionGroupName, notificationId).flatMap(res -> Mono.justOrEmpty((Object)((TestNotificationDetailsResponseInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public TestNotificationDetailsResponseInner getTestNotificationsAtActionGroupResourceLevel(String resourceGroupName, String actionGroupName, String notificationId) {
        return (TestNotificationDetailsResponseInner)this.getTestNotificationsAtActionGroupResourceLevelAsync(resourceGroupName, actionGroupName, notificationId).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<TestNotificationDetailsResponseInner> getTestNotificationsAtActionGroupResourceLevelWithResponse(String resourceGroupName, String actionGroupName, String notificationId, Context context) {
        return (Response)this.getTestNotificationsAtActionGroupResourceLevelWithResponseAsync(resourceGroupName, actionGroupName, notificationId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ActionGroupResourceInner>> listSinglePageAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2022-06-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), "2022-06-01", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ActionGroupList)res.getValue()).value(), null, null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ActionGroupResourceInner>> listSinglePageAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2022-06-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), "2022-06-01", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ActionGroupList)res.getValue()).value(), null, null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ActionGroupResourceInner> listAsync() {
        return new PagedFlux(() -> this.listSinglePageAsync());
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ActionGroupResourceInner> listAsync(Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ActionGroupResourceInner> list() {
        return new PagedIterable(this.listAsync());
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ActionGroupResourceInner> list(Context context) {
        return new PagedIterable(this.listAsync(context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ActionGroupResourceInner>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2022-06-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroup(this.client.getEndpoint(), resourceGroupName, this.client.getSubscriptionId(), "2022-06-01", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ActionGroupList)res.getValue()).value(), null, null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ActionGroupResourceInner>> listByResourceGroupSinglePageAsync(String resourceGroupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2022-06-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByResourceGroup(this.client.getEndpoint(), resourceGroupName, this.client.getSubscriptionId(), "2022-06-01", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ActionGroupList)res.getValue()).value(), null, null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ActionGroupResourceInner> listByResourceGroupAsync(String resourceGroupName) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ActionGroupResourceInner> listByResourceGroupAsync(String resourceGroupName, Context context) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ActionGroupResourceInner> listByResourceGroup(String resourceGroupName) {
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ActionGroupResourceInner> listByResourceGroup(String resourceGroupName, Context context) {
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> enableReceiverWithResponseAsync(String resourceGroupName, String actionGroupName, EnableRequest enableRequest) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (actionGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter actionGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (enableRequest == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter enableRequest is required and cannot be null."));
        }
        enableRequest.validate();
        String apiVersion = "2022-06-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.enableReceiver(this.client.getEndpoint(), resourceGroupName, actionGroupName, this.client.getSubscriptionId(), "2022-06-01", enableRequest, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> enableReceiverWithResponseAsync(String resourceGroupName, String actionGroupName, EnableRequest enableRequest, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (actionGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter actionGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (enableRequest == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter enableRequest is required and cannot be null."));
        }
        enableRequest.validate();
        String apiVersion = "2022-06-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.enableReceiver(this.client.getEndpoint(), resourceGroupName, actionGroupName, this.client.getSubscriptionId(), "2022-06-01", enableRequest, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> enableReceiverAsync(String resourceGroupName, String actionGroupName, EnableRequest enableRequest) {
        return this.enableReceiverWithResponseAsync(resourceGroupName, actionGroupName, enableRequest).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void enableReceiver(String resourceGroupName, String actionGroupName, EnableRequest enableRequest) {
        this.enableReceiverAsync(resourceGroupName, actionGroupName, enableRequest).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> enableReceiverWithResponse(String resourceGroupName, String actionGroupName, EnableRequest enableRequest, Context context) {
        return (Response)this.enableReceiverWithResponseAsync(resourceGroupName, actionGroupName, enableRequest, context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="MonitorClientActionG")
    private static interface ActionGroupsService {
        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/actionGroups/{actionGroupName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ActionGroupResourceInner>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="actionGroupName") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") ActionGroupResourceInner var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/actionGroups/{actionGroupName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ActionGroupResourceInner>> getByResourceGroup(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="actionGroupName") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/actionGroups/{actionGroupName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="actionGroupName") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/actionGroups/{actionGroupName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ActionGroupResourceInner>> update(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="actionGroupName") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") ActionGroupPatchBody var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.Insights/createNotifications")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> postTestNotifications(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") NotificationRequestBody var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/createNotifications")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createNotificationsAtResourceGroupLevel(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") NotificationRequestBody var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/actionGroups/{actionGroupName}/createNotifications")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createNotificationsAtActionGroupResourceLevel(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="actionGroupName") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") NotificationRequestBody var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Insights/notificationStatus/{notificationId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<TestNotificationDetailsResponseInner>> getTestNotifications(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="notificationId") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/notificationStatus/{notificationId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<TestNotificationDetailsResponseInner>> getTestNotificationsAtResourceGroupLevel(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="notificationId") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/actionGroups/{actionGroupName}/notificationStatus/{notificationId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<TestNotificationDetailsResponseInner>> getTestNotificationsAtActionGroupResourceLevel(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="actionGroupName") String var4, @PathParam(value="notificationId") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Insights/actionGroups")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ActionGroupList>> list(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/actionGroups")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ActionGroupList>> listByResourceGroup(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="subscriptionId") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/actionGroups/{actionGroupName}/subscribe")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> enableReceiver(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="actionGroupName") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") EnableRequest var6, @HeaderParam(value="Accept") String var7, Context var8);
    }
}

