/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.internal;

import com.aliyun.oss.ClientConfiguration;
import com.aliyun.oss.ClientException;
import com.aliyun.oss.HttpMethod;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.ServiceException;
import com.aliyun.oss.common.auth.Credentials;
import com.aliyun.oss.common.auth.CredentialsProvider;
import com.aliyun.oss.common.auth.RequestSigner;
import com.aliyun.oss.common.comm.ExecutionContext;
import com.aliyun.oss.common.comm.NoRetryStrategy;
import com.aliyun.oss.common.comm.RequestChecksumHanlder;
import com.aliyun.oss.common.comm.RequestHandler;
import com.aliyun.oss.common.comm.RequestMessage;
import com.aliyun.oss.common.comm.RequestProgressHanlder;
import com.aliyun.oss.common.comm.ResponseChecksumHandler;
import com.aliyun.oss.common.comm.ResponseHandler;
import com.aliyun.oss.common.comm.ResponseMessage;
import com.aliyun.oss.common.comm.ResponseProgressHandler;
import com.aliyun.oss.common.comm.RetryStrategy;
import com.aliyun.oss.common.comm.ServiceClient;
import com.aliyun.oss.common.comm.SignVersion;
import com.aliyun.oss.common.parser.ResponseParseException;
import com.aliyun.oss.common.parser.ResponseParser;
import com.aliyun.oss.common.utils.CodingUtils;
import com.aliyun.oss.common.utils.ExceptionFactory;
import com.aliyun.oss.common.utils.LogUtils;
import com.aliyun.oss.internal.OSSErrorResponseHandler;
import com.aliyun.oss.internal.OSSUtils;
import com.aliyun.oss.internal.ResponseParsers;
import com.aliyun.oss.internal.signer.OSSSignerBase;
import com.aliyun.oss.internal.signer.OSSSignerParams;
import com.aliyun.oss.model.WebServiceRequest;
import java.net.URI;
import java.util.List;

public abstract class OSSOperation {
    protected String product;
    protected String region;
    protected volatile URI endpoint;
    protected CredentialsProvider credsProvider;
    protected ServiceClient client;
    protected String cloudBoxId;
    protected SignVersion signVersion;
    protected static OSSErrorResponseHandler errorResponseHandler = new OSSErrorResponseHandler();
    protected static ResponseParsers.EmptyResponseParser emptyResponseParser = new ResponseParsers.EmptyResponseParser();
    protected static ResponseParsers.RequestIdResponseParser requestIdResponseParser = new ResponseParsers.RequestIdResponseParser();
    protected static RetryStrategy noRetryStrategy = new NoRetryStrategy();

    protected OSSOperation(ServiceClient client, CredentialsProvider credsProvider) {
        this.client = client;
        this.credsProvider = credsProvider;
        this.product = "oss";
        this.signVersion = null;
    }

    public String getProduct() {
        return this.product;
    }

    public void setProduct(String product) {
        this.product = product;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public URI getEndpoint() {
        return this.endpoint;
    }

    public URI getEndpoint(WebServiceRequest request) {
        String reqEndpoint = request.getEndpoint();
        if (reqEndpoint == null) {
            return this.getEndpoint();
        }
        String defaultProto = this.client.getClientConfiguration().getProtocol().toString();
        URI ret = OSSUtils.toEndpointURI(reqEndpoint, defaultProto);
        OSSUtils.ensureEndpointValid(ret.getHost());
        return ret;
    }

    public void setEndpoint(URI endpoint) {
        this.endpoint = URI.create(endpoint.toString());
    }

    public String getCloudBoxId() {
        return this.cloudBoxId;
    }

    public void setCloudBoxId(String cloudBoxId) {
        this.cloudBoxId = cloudBoxId;
    }

    public SignVersion getSignVersion() {
        return this.signVersion;
    }

    public void setSignVersion(SignVersion signVersion) {
        this.signVersion = signVersion;
    }

    protected ServiceClient getInnerClient() {
        return this.client;
    }

    protected ResponseMessage send(RequestMessage request, ExecutionContext context) throws OSSException, ClientException {
        return this.send(request, context, false);
    }

    protected ResponseMessage send(RequestMessage request, ExecutionContext context, boolean keepResponseOpen) throws OSSException, ClientException {
        ResponseMessage response = null;
        try {
            ResponseMessage responseMessage = response = this.client.sendRequest(request, context);
            return responseMessage;
        }
        catch (ServiceException e) {
            assert (e instanceof OSSException);
            throw (OSSException)e;
        }
        finally {
            if (response != null && !keepResponseOpen) {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    protected <T> T doOperation(RequestMessage request, ResponseParser<T> parser, String bucketName, String key) throws OSSException, ClientException {
        return this.doOperation(request, parser, bucketName, key, false);
    }

    protected <T> T doOperation(RequestMessage request, ResponseParser<T> parser, String bucketName, String key, boolean keepResponseOpen) throws OSSException, ClientException {
        return this.doOperation(request, parser, bucketName, key, keepResponseOpen, null, null);
    }

    protected <T> T doOperation(RequestMessage request, ResponseParser<T> parser, String bucketName, String key, boolean keepResponseOpen, List<RequestHandler> requestHandlers, List<ResponseHandler> reponseHandlers) throws OSSException, ClientException {
        List<RequestSigner> signerHandlers;
        WebServiceRequest originalRequest = request.getOriginalRequest();
        request.getHeaders().putAll(this.client.getClientConfiguration().getDefaultHeaders());
        request.getHeaders().putAll(originalRequest.getHeaders());
        request.getParameters().putAll(originalRequest.getParameters());
        ExecutionContext context = this.createDefaultContext(request.getMethod(), bucketName, key, originalRequest);
        context.addRequestHandler(new RequestProgressHanlder());
        if (requestHandlers != null) {
            for (RequestHandler requestHandler : requestHandlers) {
                context.addRequestHandler(requestHandler);
            }
        }
        if (this.client.getClientConfiguration().isCrcCheckEnabled()) {
            context.addRequestHandler(new RequestChecksumHanlder());
        }
        context.addResponseHandler(new ResponseProgressHandler(originalRequest));
        if (reponseHandlers != null) {
            for (ResponseHandler responseHandler : reponseHandlers) {
                context.addResponseHandler(responseHandler);
            }
        }
        if (this.client.getClientConfiguration().isCrcCheckEnabled()) {
            context.addResponseHandler(new ResponseChecksumHandler());
        }
        if ((signerHandlers = this.client.getClientConfiguration().getSignerHandlers()) != null) {
            for (RequestSigner signer : signerHandlers) {
                context.addSignerHandler(signer);
            }
        }
        ResponseMessage responseMessage = this.send(request, context, keepResponseOpen);
        try {
            return parser.parse(responseMessage);
        }
        catch (ResponseParseException rpe) {
            OSSException oe = ExceptionFactory.createInvalidResponseException(responseMessage.getRequestId(), rpe.getMessage(), rpe);
            LogUtils.logException("Unable to parse response error: ", rpe);
            throw oe;
        }
    }

    private RequestSigner createSigner(String bucketName, String key, Credentials creds, ClientConfiguration config) {
        String resourcePath = "/" + (bucketName != null ? bucketName + "/" : "") + (key != null ? key : "");
        OSSSignerParams params = new OSSSignerParams(resourcePath, creds);
        params.setProduct(this.product);
        params.setRegion(this.region);
        params.setCloudBoxId(this.cloudBoxId);
        params.setTickOffset(config.getTickOffset());
        return OSSSignerBase.createRequestSigner(this.signVersion != null ? this.signVersion : config.getSignatureVersion(), params);
    }

    protected ExecutionContext createDefaultContext(HttpMethod method, String bucketName, String key, WebServiceRequest originalRequest) {
        ExecutionContext context = new ExecutionContext();
        Credentials credentials = this.credsProvider.getCredentials();
        CodingUtils.assertParameterNotNull(credentials, "credentials");
        context.setCharset("utf-8");
        context.setSigner(this.createSigner(bucketName, key, credentials, this.client.getClientConfiguration()));
        context.addResponseHandler(errorResponseHandler);
        if (method == HttpMethod.POST && !this.isRetryablePostRequest(originalRequest)) {
            context.setRetryStrategy(noRetryStrategy);
        }
        if (this.client.getClientConfiguration().getRetryStrategy() != null) {
            context.setRetryStrategy(this.client.getClientConfiguration().getRetryStrategy());
        }
        context.setCredentials(credentials);
        return context;
    }

    protected ExecutionContext createDefaultContext(HttpMethod method, String bucketName, String key) {
        return this.createDefaultContext(method, bucketName, key, null);
    }

    protected ExecutionContext createDefaultContext(HttpMethod method, String bucketName) {
        return this.createDefaultContext(method, bucketName, null, null);
    }

    protected ExecutionContext createDefaultContext(HttpMethod method) {
        return this.createDefaultContext(method, null, null, null);
    }

    protected boolean isRetryablePostRequest(WebServiceRequest request) {
        return false;
    }
}

