/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master;

import java.util.Date;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import lombok.Generated;
import org.apache.dolphinscheduler.common.CommonConfiguration;
import org.apache.dolphinscheduler.common.IStoppable;
import org.apache.dolphinscheduler.common.constants.Constants;
import org.apache.dolphinscheduler.common.lifecycle.ServerLifeCycleManager;
import org.apache.dolphinscheduler.common.thread.DefaultUncaughtExceptionHandler;
import org.apache.dolphinscheduler.common.thread.ThreadUtils;
import org.apache.dolphinscheduler.dao.DaoConfiguration;
import org.apache.dolphinscheduler.meter.metrics.MetricsProvider;
import org.apache.dolphinscheduler.meter.metrics.SystemMetrics;
import org.apache.dolphinscheduler.plugin.datasource.api.plugin.DataSourceProcessorProvider;
import org.apache.dolphinscheduler.plugin.storage.api.StorageConfiguration;
import org.apache.dolphinscheduler.plugin.task.api.TaskPluginManager;
import org.apache.dolphinscheduler.registry.api.RegistryConfiguration;
import org.apache.dolphinscheduler.scheduler.api.SchedulerApi;
import org.apache.dolphinscheduler.server.master.cluster.ClusterManager;
import org.apache.dolphinscheduler.server.master.cluster.ClusterStateMonitors;
import org.apache.dolphinscheduler.server.master.engine.MasterCoordinator;
import org.apache.dolphinscheduler.server.master.engine.WorkflowEngine;
import org.apache.dolphinscheduler.server.master.engine.system.SystemEventBus;
import org.apache.dolphinscheduler.server.master.engine.system.SystemEventBusFireWorker;
import org.apache.dolphinscheduler.server.master.engine.system.event.GlobalMasterFailoverEvent;
import org.apache.dolphinscheduler.server.master.engine.task.dispatcher.WorkerGroupDispatcherCoordinator;
import org.apache.dolphinscheduler.server.master.metrics.MasterServerMetrics;
import org.apache.dolphinscheduler.server.master.registry.MasterRegistryClient;
import org.apache.dolphinscheduler.server.master.rpc.MasterRpcServer;
import org.apache.dolphinscheduler.server.master.utils.MasterThreadFactory;
import org.apache.dolphinscheduler.service.ServiceConfiguration;
import org.apache.dolphinscheduler.service.bean.SpringApplicationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Import;

@Import(value={DaoConfiguration.class, ServiceConfiguration.class, CommonConfiguration.class, StorageConfiguration.class, RegistryConfiguration.class})
@SpringBootApplication
public class MasterServer
implements IStoppable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MasterServer.class);
    @Autowired
    private SpringApplicationContext springApplicationContext;
    @Autowired
    private MasterRegistryClient masterRegistryClient;
    @Autowired
    private WorkflowEngine workflowEngine;
    @Autowired
    private SchedulerApi schedulerApi;
    @Autowired
    private MasterRpcServer masterRPCServer;
    @Autowired
    private MetricsProvider metricsProvider;
    @Autowired
    private ClusterStateMonitors clusterStateMonitors;
    @Autowired
    private ClusterManager clusterManager;
    @Autowired
    private SystemEventBus systemEventBus;
    @Autowired
    private SystemEventBusFireWorker systemEventBusFireWorker;
    @Autowired
    private MasterCoordinator masterCoordinator;
    @Autowired
    private WorkerGroupDispatcherCoordinator workerGroupDispatcherCoordinator;

    public static void main(String[] args) {
        MasterServerMetrics.registerUncachedException(DefaultUncaughtExceptionHandler::getUncaughtExceptionCount);
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)DefaultUncaughtExceptionHandler.getInstance());
        Thread.currentThread().setName("Master-Server");
        SpringApplication.run(MasterServer.class, (String[])new String[0]);
    }

    @PostConstruct
    public void initialized() {
        ServerLifeCycleManager.toRunning();
        this.masterRPCServer.start();
        TaskPluginManager.loadTaskPlugin();
        DataSourceProcessorProvider.initialize();
        this.masterRegistryClient.start();
        this.masterRegistryClient.setRegistryStoppable(this);
        this.masterCoordinator.start();
        this.clusterManager.start();
        this.clusterStateMonitors.start();
        this.workflowEngine.start();
        this.schedulerApi.start();
        this.systemEventBus.publish(GlobalMasterFailoverEvent.of(new Date(ServerLifeCycleManager.getServerStartupTime())));
        this.systemEventBusFireWorker.start();
        MasterServerMetrics.registerMasterCpuUsageGauge(() -> {
            SystemMetrics systemMetrics = this.metricsProvider.getSystemMetrics();
            return systemMetrics.getSystemCpuUsagePercentage();
        });
        MasterServerMetrics.registerMasterMemoryAvailableGauge(() -> {
            SystemMetrics systemMetrics = this.metricsProvider.getSystemMetrics();
            return (systemMetrics.getSystemMemoryMax() - systemMetrics.getSystemMemoryUsed()) / 1024.0 / 1024.0 / 1024.0;
        });
        MasterServerMetrics.registerMasterMemoryUsageGauge(() -> {
            SystemMetrics systemMetrics = this.metricsProvider.getSystemMetrics();
            return systemMetrics.getJvmMemoryUsedPercentage();
        });
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (!ServerLifeCycleManager.isStopped()) {
                this.close("MasterServer shutdownHook");
            }
        }));
        log.info("MasterServer initialized successfully in {} ms", (Object)(System.currentTimeMillis() - ServerLifeCycleManager.getServerStartupTime()));
    }

    @PreDestroy
    public void shutdown() {
        this.close("MasterServer shutdown");
    }

    public void close(String cause) {
        if (!ServerLifeCycleManager.toStopped()) {
            log.warn("MasterServer is already stopped, current cause: {}", (Object)cause);
            return;
        }
        ThreadUtils.sleep((long)Constants.SERVER_CLOSE_WAIT_TIME.toMillis());
        MasterThreadFactory.getDefaultSchedulerThreadExecutor().shutdownNow();
        try (SystemEventBusFireWorker systemEventBusFireWorker1 = this.systemEventBusFireWorker;
             WorkflowEngine workflowEngine1 = this.workflowEngine;
             SchedulerApi closedSchedulerApi = this.schedulerApi;
             MasterRpcServer closedRpcServer = this.masterRPCServer;
             MasterCoordinator closeMasterCoordinator = this.masterCoordinator;
             MasterRegistryClient closedMasterRegistryClient = this.masterRegistryClient;
             SpringApplicationContext closedSpringContext = this.springApplicationContext;
             WorkerGroupDispatcherCoordinator closeWorkerGroupDispatcherCoordinator = this.workerGroupDispatcherCoordinator;){
            log.info("MasterServer is stopping, current cause : {}", (Object)cause);
        }
        catch (Exception e) {
            log.error("MasterServer stop failed, current cause: {}", (Object)cause, (Object)e);
            return;
        }
        log.info("MasterServer stopped, current cause: {}", (Object)cause);
    }

    public void stop(String cause) {
        this.close(cause);
        System.exit(1);
    }
}

