/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.cluster;

import java.util.List;
import org.apache.dolphinscheduler.server.master.cluster.IClusters;
import org.apache.dolphinscheduler.server.master.cluster.IMasterSlotChangeListener;
import org.apache.dolphinscheduler.server.master.cluster.MasterClusters;
import org.apache.dolphinscheduler.server.master.cluster.MasterServerMetadata;
import org.apache.dolphinscheduler.server.master.cluster.MasterSlotManager;

public class MasterSlotChangeListenerAdaptor
implements IMasterSlotChangeListener,
IClusters.IClustersChangeListener<MasterServerMetadata> {
    private final MasterSlotManager masterSlotManager;
    private final MasterClusters masterClusters;

    public MasterSlotChangeListenerAdaptor(MasterSlotManager masterSlotManager, MasterClusters masterClusters) {
        this.masterSlotManager = masterSlotManager;
        this.masterClusters = masterClusters;
    }

    @Override
    public void onMasterSlotChanged(List<MasterServerMetadata> normalMasterServers) {
        this.masterSlotManager.doReBalance(normalMasterServers);
    }

    @Override
    public void onServerAdded(MasterServerMetadata server) {
        this.onMasterSlotChanged(this.masterClusters.getNormalServers());
    }

    @Override
    public void onServerRemove(MasterServerMetadata server) {
        this.onMasterSlotChanged(this.masterClusters.getNormalServers());
    }

    @Override
    public void onServerUpdate(MasterServerMetadata server) {
        this.onMasterSlotChanged(this.masterClusters.getNormalServers());
    }
}

