/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.engine.command;

import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.dolphinscheduler.dao.entity.Command;
import org.apache.dolphinscheduler.dao.repository.CommandDao;
import org.apache.dolphinscheduler.server.master.cluster.MasterSlotManager;
import org.apache.dolphinscheduler.server.master.config.CommandFetchStrategy;
import org.apache.dolphinscheduler.server.master.engine.command.ICommandFetcher;
import org.apache.dolphinscheduler.server.master.metrics.WorkflowInstanceMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

public class IdSlotBasedCommandFetcher
implements ICommandFetcher {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IdSlotBasedCommandFetcher.class);
    private final CommandFetchStrategy.IdSlotBasedFetchConfig idSlotBasedFetchConfig;
    private final CommandDao commandDao;
    private final MasterSlotManager masterSlotManager;

    public IdSlotBasedCommandFetcher(CommandFetchStrategy.IdSlotBasedFetchConfig idSlotBasedFetchConfig, MasterSlotManager masterSlotManager, CommandDao commandDao) {
        this.idSlotBasedFetchConfig = idSlotBasedFetchConfig;
        this.masterSlotManager = masterSlotManager;
        this.commandDao = commandDao;
    }

    @Override
    @Transactional
    public List<Command> fetchCommands() {
        long scheduleStartTime = System.currentTimeMillis();
        if (!this.masterSlotManager.checkSlotValid()) {
            log.warn("MasterSlotManager check slot ({} -> {})is invalidated.", (Object)this.masterSlotManager.getCurrentMasterSlot(), (Object)this.masterSlotManager.getTotalMasterSlots());
            return Collections.emptyList();
        }
        int currentSlotIndex = this.masterSlotManager.getCurrentMasterSlot();
        int totalSlot = this.masterSlotManager.getTotalMasterSlots();
        List commands = this.commandDao.queryCommandByIdSlot(currentSlotIndex, totalSlot, this.idSlotBasedFetchConfig.getIdStep(), this.idSlotBasedFetchConfig.getFetchSize());
        long cost = System.currentTimeMillis() - scheduleStartTime;
        log.debug("[Slot-{}/{}] Fetch {} commands in {}ms.", new Object[]{currentSlotIndex, totalSlot, commands.size(), cost});
        WorkflowInstanceMetrics.recordCommandQueryTime(cost);
        return commands;
    }
}

