/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http;

import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.util.CoreUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class HttpHeaders
implements Iterable<HttpHeader> {
    private final Map<String, HttpHeader> headers;

    public HttpHeaders() {
        this.headers = new HashMap<String, HttpHeader>();
    }

    public HttpHeaders(Map<String, String> headers) {
        this.headers = new HashMap<String, HttpHeader>(headers.size());
        headers.forEach(this::set);
    }

    public HttpHeaders(Iterable<HttpHeader> headers) {
        this.headers = new HashMap<String, HttpHeader>();
        for (HttpHeader header : headers) {
            this.set(header.getName(), header.getValue());
        }
    }

    HttpHeaders(HttpHeaders headers) {
        this.headers = new HashMap<String, HttpHeader>((int)((float)headers.headers.size() / 0.75f));
        headers.headers.forEach((? super K key, ? super V value) -> this.headers.put((String)key, new HttpHeader(value.getName(), value.getValue())));
    }

    public HttpHeaders(int initialCapacity) {
        this.headers = new HashMap<String, HttpHeader>(initialCapacity);
    }

    public int getSize() {
        return this.headers.size();
    }

    public HttpHeaders add(String name, String value) {
        return this.addInternal(HttpHeaders.formatKey(name), name, value);
    }

    public HttpHeaders add(HttpHeaderName name, String value) {
        return this.addInternal(name.getCaseInsensitiveName(), name.getCaseSensitiveName(), value);
    }

    private HttpHeaders addInternal(String formattedName, String name, String value) {
        if (name == null || value == null) {
            return this;
        }
        this.headers.compute(formattedName, (key, header) -> {
            if (header == null) {
                return new HttpHeader(name, value);
            }
            header.addValue(value);
            return header;
        });
        return this;
    }

    @Deprecated
    public HttpHeaders put(String name, String value) {
        return this.set(name, value);
    }

    public HttpHeaders set(String name, String value) {
        return this.setInternal(HttpHeaders.formatKey(name), name, value);
    }

    public HttpHeaders set(HttpHeaderName name, String value) {
        return this.setInternal(name.getCaseInsensitiveName(), name.getCaseSensitiveName(), value);
    }

    private HttpHeaders setInternal(String formattedName, String name, String value) {
        if (name == null) {
            return this;
        }
        if (value == null) {
            this.removeInternal(name);
        } else {
            this.headers.put(formattedName, new HttpHeader(name, value));
        }
        return this;
    }

    public HttpHeaders set(String name, List<String> values) {
        return this.setInternal(HttpHeaders.formatKey(name), name, values);
    }

    public HttpHeaders set(HttpHeaderName name, List<String> values) {
        return this.setInternal(name.getCaseInsensitiveName(), name.getCaseSensitiveName(), values);
    }

    private HttpHeaders setInternal(String formattedName, String name, List<String> values) {
        if (formattedName == null) {
            return this;
        }
        if (CoreUtils.isNullOrEmpty(values)) {
            this.removeInternal(formattedName);
        } else {
            this.headers.put(formattedName, new HttpHeader(name, values));
        }
        return this;
    }

    public HttpHeaders setAll(Map<String, List<String>> headers) {
        headers.forEach(this::set);
        return this;
    }

    public HttpHeader get(String name) {
        return this.getInternal(HttpHeaders.formatKey(name));
    }

    public HttpHeader get(HttpHeaderName name) {
        return this.getInternal(name.getCaseInsensitiveName());
    }

    private HttpHeader getInternal(String formattedName) {
        return this.headers.get(formattedName);
    }

    public HttpHeader remove(String name) {
        return this.removeInternal(HttpHeaders.formatKey(name));
    }

    public HttpHeader remove(HttpHeaderName name) {
        return this.removeInternal(name.getCaseInsensitiveName());
    }

    private HttpHeader removeInternal(String formattedName) {
        return this.headers.remove(formattedName);
    }

    public String getValue(String name) {
        return this.getValueInternal(HttpHeaders.formatKey(name));
    }

    public String getValue(HttpHeaderName name) {
        return this.getValueInternal(name.getCaseInsensitiveName());
    }

    private String getValueInternal(String formattedName) {
        HttpHeader header = this.getInternal(formattedName);
        return header == null ? null : header.getValue();
    }

    public String[] getValues(String name) {
        return this.getValuesInternal(HttpHeaders.formatKey(name));
    }

    public String[] getValues(HttpHeaderName name) {
        return this.getValuesInternal(name.getCaseInsensitiveName());
    }

    private String[] getValuesInternal(String formattedName) {
        HttpHeader header = this.getInternal(formattedName);
        return header == null ? null : header.getValues();
    }

    public Map<String, String> toMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (HttpHeader header : this.headers.values()) {
            result.put(header.getName(), header.getValue());
        }
        return Collections.unmodifiableMap(result);
    }

    Map<String, String[]> toMultiMap() {
        HashMap<String, String[]> result = new HashMap<String, String[]>();
        for (HttpHeader header : this.headers.values()) {
            result.put(header.getName(), header.getValues());
        }
        return Collections.unmodifiableMap(result);
    }

    @Override
    public Iterator<HttpHeader> iterator() {
        return this.headers.values().iterator();
    }

    public Stream<HttpHeader> stream() {
        return this.headers.values().stream();
    }

    public String toString() {
        return this.stream().map(header -> header.getName() + "=" + header.getValue()).collect(Collectors.joining(", "));
    }

    private static String formatKey(String name) {
        return name == null ? null : name.toLowerCase(Locale.ROOT);
    }
}

