/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datasync.model.DataSyncResponse;
import software.amazon.awssdk.services.datasync.model.FilterListCopier;
import software.amazon.awssdk.services.datasync.model.FilterRule;
import software.amazon.awssdk.services.datasync.model.Options;
import software.amazon.awssdk.services.datasync.model.TaskExecutionResultDetail;
import software.amazon.awssdk.services.datasync.model.TaskExecutionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeTaskExecutionResponse
extends DataSyncResponse
implements ToCopyableBuilder<Builder, DescribeTaskExecutionResponse> {
    private static final SdkField<String> TASK_EXECUTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TaskExecutionArn").getter(DescribeTaskExecutionResponse.getter(DescribeTaskExecutionResponse::taskExecutionArn)).setter(DescribeTaskExecutionResponse.setter(Builder::taskExecutionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskExecutionArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DescribeTaskExecutionResponse.getter(DescribeTaskExecutionResponse::statusAsString)).setter(DescribeTaskExecutionResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Options> OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Options").getter(DescribeTaskExecutionResponse.getter(DescribeTaskExecutionResponse::options)).setter(DescribeTaskExecutionResponse.setter(Builder::options)).constructor(Options::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Options").build()}).build();
    private static final SdkField<List<FilterRule>> EXCLUDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Excludes").getter(DescribeTaskExecutionResponse.getter(DescribeTaskExecutionResponse::excludes)).setter(DescribeTaskExecutionResponse.setter(Builder::excludes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Excludes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FilterRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<FilterRule>> INCLUDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Includes").getter(DescribeTaskExecutionResponse.getter(DescribeTaskExecutionResponse::includes)).setter(DescribeTaskExecutionResponse.setter(Builder::includes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Includes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FilterRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(DescribeTaskExecutionResponse.getter(DescribeTaskExecutionResponse::startTime)).setter(DescribeTaskExecutionResponse.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Long> ESTIMATED_FILES_TO_TRANSFER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("EstimatedFilesToTransfer").getter(DescribeTaskExecutionResponse.getter(DescribeTaskExecutionResponse::estimatedFilesToTransfer)).setter(DescribeTaskExecutionResponse.setter(Builder::estimatedFilesToTransfer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedFilesToTransfer").build()}).build();
    private static final SdkField<Long> ESTIMATED_BYTES_TO_TRANSFER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("EstimatedBytesToTransfer").getter(DescribeTaskExecutionResponse.getter(DescribeTaskExecutionResponse::estimatedBytesToTransfer)).setter(DescribeTaskExecutionResponse.setter(Builder::estimatedBytesToTransfer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedBytesToTransfer").build()}).build();
    private static final SdkField<Long> FILES_TRANSFERRED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("FilesTransferred").getter(DescribeTaskExecutionResponse.getter(DescribeTaskExecutionResponse::filesTransferred)).setter(DescribeTaskExecutionResponse.setter(Builder::filesTransferred)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilesTransferred").build()}).build();
    private static final SdkField<Long> BYTES_WRITTEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("BytesWritten").getter(DescribeTaskExecutionResponse.getter(DescribeTaskExecutionResponse::bytesWritten)).setter(DescribeTaskExecutionResponse.setter(Builder::bytesWritten)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BytesWritten").build()}).build();
    private static final SdkField<Long> BYTES_TRANSFERRED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("BytesTransferred").getter(DescribeTaskExecutionResponse.getter(DescribeTaskExecutionResponse::bytesTransferred)).setter(DescribeTaskExecutionResponse.setter(Builder::bytesTransferred)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BytesTransferred").build()}).build();
    private static final SdkField<TaskExecutionResultDetail> RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Result").getter(DescribeTaskExecutionResponse.getter(DescribeTaskExecutionResponse::result)).setter(DescribeTaskExecutionResponse.setter(Builder::result)).constructor(TaskExecutionResultDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Result").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_EXECUTION_ARN_FIELD, STATUS_FIELD, OPTIONS_FIELD, EXCLUDES_FIELD, INCLUDES_FIELD, START_TIME_FIELD, ESTIMATED_FILES_TO_TRANSFER_FIELD, ESTIMATED_BYTES_TO_TRANSFER_FIELD, FILES_TRANSFERRED_FIELD, BYTES_WRITTEN_FIELD, BYTES_TRANSFERRED_FIELD, RESULT_FIELD));
    private final String taskExecutionArn;
    private final String status;
    private final Options options;
    private final List<FilterRule> excludes;
    private final List<FilterRule> includes;
    private final Instant startTime;
    private final Long estimatedFilesToTransfer;
    private final Long estimatedBytesToTransfer;
    private final Long filesTransferred;
    private final Long bytesWritten;
    private final Long bytesTransferred;
    private final TaskExecutionResultDetail result;

    private DescribeTaskExecutionResponse(BuilderImpl builder) {
        super(builder);
        this.taskExecutionArn = builder.taskExecutionArn;
        this.status = builder.status;
        this.options = builder.options;
        this.excludes = builder.excludes;
        this.includes = builder.includes;
        this.startTime = builder.startTime;
        this.estimatedFilesToTransfer = builder.estimatedFilesToTransfer;
        this.estimatedBytesToTransfer = builder.estimatedBytesToTransfer;
        this.filesTransferred = builder.filesTransferred;
        this.bytesWritten = builder.bytesWritten;
        this.bytesTransferred = builder.bytesTransferred;
        this.result = builder.result;
    }

    public final String taskExecutionArn() {
        return this.taskExecutionArn;
    }

    public final TaskExecutionStatus status() {
        return TaskExecutionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Options options() {
        return this.options;
    }

    public final boolean hasExcludes() {
        return this.excludes != null && !(this.excludes instanceof SdkAutoConstructList);
    }

    public final List<FilterRule> excludes() {
        return this.excludes;
    }

    public final boolean hasIncludes() {
        return this.includes != null && !(this.includes instanceof SdkAutoConstructList);
    }

    public final List<FilterRule> includes() {
        return this.includes;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Long estimatedFilesToTransfer() {
        return this.estimatedFilesToTransfer;
    }

    public final Long estimatedBytesToTransfer() {
        return this.estimatedBytesToTransfer;
    }

    public final Long filesTransferred() {
        return this.filesTransferred;
    }

    public final Long bytesWritten() {
        return this.bytesWritten;
    }

    public final Long bytesTransferred() {
        return this.bytesTransferred;
    }

    public final TaskExecutionResultDetail result() {
        return this.result;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.taskExecutionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.options());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExcludes() ? this.excludes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIncludes() ? this.includes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedFilesToTransfer());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedBytesToTransfer());
        hashCode = 31 * hashCode + Objects.hashCode(this.filesTransferred());
        hashCode = 31 * hashCode + Objects.hashCode(this.bytesWritten());
        hashCode = 31 * hashCode + Objects.hashCode(this.bytesTransferred());
        hashCode = 31 * hashCode + Objects.hashCode(this.result());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTaskExecutionResponse)) {
            return false;
        }
        DescribeTaskExecutionResponse other = (DescribeTaskExecutionResponse)((Object)obj);
        return Objects.equals(this.taskExecutionArn(), other.taskExecutionArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.options(), other.options()) && this.hasExcludes() == other.hasExcludes() && Objects.equals(this.excludes(), other.excludes()) && this.hasIncludes() == other.hasIncludes() && Objects.equals(this.includes(), other.includes()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.estimatedFilesToTransfer(), other.estimatedFilesToTransfer()) && Objects.equals(this.estimatedBytesToTransfer(), other.estimatedBytesToTransfer()) && Objects.equals(this.filesTransferred(), other.filesTransferred()) && Objects.equals(this.bytesWritten(), other.bytesWritten()) && Objects.equals(this.bytesTransferred(), other.bytesTransferred()) && Objects.equals(this.result(), other.result());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeTaskExecutionResponse").add("TaskExecutionArn", (Object)this.taskExecutionArn()).add("Status", (Object)this.statusAsString()).add("Options", (Object)this.options()).add("Excludes", this.hasExcludes() ? this.excludes() : null).add("Includes", this.hasIncludes() ? this.includes() : null).add("StartTime", (Object)this.startTime()).add("EstimatedFilesToTransfer", (Object)this.estimatedFilesToTransfer()).add("EstimatedBytesToTransfer", (Object)this.estimatedBytesToTransfer()).add("FilesTransferred", (Object)this.filesTransferred()).add("BytesWritten", (Object)this.bytesWritten()).add("BytesTransferred", (Object)this.bytesTransferred()).add("Result", (Object)this.result()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TaskExecutionArn": {
                return Optional.ofNullable(clazz.cast(this.taskExecutionArn()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Options": {
                return Optional.ofNullable(clazz.cast(this.options()));
            }
            case "Excludes": {
                return Optional.ofNullable(clazz.cast(this.excludes()));
            }
            case "Includes": {
                return Optional.ofNullable(clazz.cast(this.includes()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EstimatedFilesToTransfer": {
                return Optional.ofNullable(clazz.cast(this.estimatedFilesToTransfer()));
            }
            case "EstimatedBytesToTransfer": {
                return Optional.ofNullable(clazz.cast(this.estimatedBytesToTransfer()));
            }
            case "FilesTransferred": {
                return Optional.ofNullable(clazz.cast(this.filesTransferred()));
            }
            case "BytesWritten": {
                return Optional.ofNullable(clazz.cast(this.bytesWritten()));
            }
            case "BytesTransferred": {
                return Optional.ofNullable(clazz.cast(this.bytesTransferred()));
            }
            case "Result": {
                return Optional.ofNullable(clazz.cast(this.result()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTaskExecutionResponse, T> g) {
        return obj -> g.apply((DescribeTaskExecutionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataSyncResponse.BuilderImpl
    implements Builder {
        private String taskExecutionArn;
        private String status;
        private Options options;
        private List<FilterRule> excludes = DefaultSdkAutoConstructList.getInstance();
        private List<FilterRule> includes = DefaultSdkAutoConstructList.getInstance();
        private Instant startTime;
        private Long estimatedFilesToTransfer;
        private Long estimatedBytesToTransfer;
        private Long filesTransferred;
        private Long bytesWritten;
        private Long bytesTransferred;
        private TaskExecutionResultDetail result;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTaskExecutionResponse model) {
            super(model);
            this.taskExecutionArn(model.taskExecutionArn);
            this.status(model.status);
            this.options(model.options);
            this.excludes(model.excludes);
            this.includes(model.includes);
            this.startTime(model.startTime);
            this.estimatedFilesToTransfer(model.estimatedFilesToTransfer);
            this.estimatedBytesToTransfer(model.estimatedBytesToTransfer);
            this.filesTransferred(model.filesTransferred);
            this.bytesWritten(model.bytesWritten);
            this.bytesTransferred(model.bytesTransferred);
            this.result(model.result);
        }

        public final String getTaskExecutionArn() {
            return this.taskExecutionArn;
        }

        public final void setTaskExecutionArn(String taskExecutionArn) {
            this.taskExecutionArn = taskExecutionArn;
        }

        @Override
        public final Builder taskExecutionArn(String taskExecutionArn) {
            this.taskExecutionArn = taskExecutionArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TaskExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Options.Builder getOptions() {
            return this.options != null ? this.options.toBuilder() : null;
        }

        public final void setOptions(Options.BuilderImpl options) {
            this.options = options != null ? options.build() : null;
        }

        @Override
        public final Builder options(Options options) {
            this.options = options;
            return this;
        }

        public final List<FilterRule.Builder> getExcludes() {
            List<FilterRule.Builder> result = FilterListCopier.copyToBuilder(this.excludes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExcludes(Collection<FilterRule.BuilderImpl> excludes) {
            this.excludes = FilterListCopier.copyFromBuilder(excludes);
        }

        @Override
        public final Builder excludes(Collection<FilterRule> excludes) {
            this.excludes = FilterListCopier.copy(excludes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludes(FilterRule ... excludes) {
            this.excludes(Arrays.asList(excludes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludes(Consumer<FilterRule.Builder> ... excludes) {
            this.excludes(Stream.of(excludes).map(c -> (FilterRule)((FilterRule.Builder)FilterRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<FilterRule.Builder> getIncludes() {
            List<FilterRule.Builder> result = FilterListCopier.copyToBuilder(this.includes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIncludes(Collection<FilterRule.BuilderImpl> includes) {
            this.includes = FilterListCopier.copyFromBuilder(includes);
        }

        @Override
        public final Builder includes(Collection<FilterRule> includes) {
            this.includes = FilterListCopier.copy(includes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includes(FilterRule ... includes) {
            this.includes(Arrays.asList(includes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includes(Consumer<FilterRule.Builder> ... includes) {
            this.includes(Stream.of(includes).map(c -> (FilterRule)((FilterRule.Builder)FilterRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Long getEstimatedFilesToTransfer() {
            return this.estimatedFilesToTransfer;
        }

        public final void setEstimatedFilesToTransfer(Long estimatedFilesToTransfer) {
            this.estimatedFilesToTransfer = estimatedFilesToTransfer;
        }

        @Override
        public final Builder estimatedFilesToTransfer(Long estimatedFilesToTransfer) {
            this.estimatedFilesToTransfer = estimatedFilesToTransfer;
            return this;
        }

        public final Long getEstimatedBytesToTransfer() {
            return this.estimatedBytesToTransfer;
        }

        public final void setEstimatedBytesToTransfer(Long estimatedBytesToTransfer) {
            this.estimatedBytesToTransfer = estimatedBytesToTransfer;
        }

        @Override
        public final Builder estimatedBytesToTransfer(Long estimatedBytesToTransfer) {
            this.estimatedBytesToTransfer = estimatedBytesToTransfer;
            return this;
        }

        public final Long getFilesTransferred() {
            return this.filesTransferred;
        }

        public final void setFilesTransferred(Long filesTransferred) {
            this.filesTransferred = filesTransferred;
        }

        @Override
        public final Builder filesTransferred(Long filesTransferred) {
            this.filesTransferred = filesTransferred;
            return this;
        }

        public final Long getBytesWritten() {
            return this.bytesWritten;
        }

        public final void setBytesWritten(Long bytesWritten) {
            this.bytesWritten = bytesWritten;
        }

        @Override
        public final Builder bytesWritten(Long bytesWritten) {
            this.bytesWritten = bytesWritten;
            return this;
        }

        public final Long getBytesTransferred() {
            return this.bytesTransferred;
        }

        public final void setBytesTransferred(Long bytesTransferred) {
            this.bytesTransferred = bytesTransferred;
        }

        @Override
        public final Builder bytesTransferred(Long bytesTransferred) {
            this.bytesTransferred = bytesTransferred;
            return this;
        }

        public final TaskExecutionResultDetail.Builder getResult() {
            return this.result != null ? this.result.toBuilder() : null;
        }

        public final void setResult(TaskExecutionResultDetail.BuilderImpl result) {
            this.result = result != null ? result.build() : null;
        }

        @Override
        public final Builder result(TaskExecutionResultDetail result) {
            this.result = result;
            return this;
        }

        @Override
        public DescribeTaskExecutionResponse build() {
            return new DescribeTaskExecutionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DataSyncResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeTaskExecutionResponse> {
        public Builder taskExecutionArn(String var1);

        public Builder status(String var1);

        public Builder status(TaskExecutionStatus var1);

        public Builder options(Options var1);

        default public Builder options(Consumer<Options.Builder> options) {
            return this.options((Options)((Options.Builder)Options.builder().applyMutation(options)).build());
        }

        public Builder excludes(Collection<FilterRule> var1);

        public Builder excludes(FilterRule ... var1);

        public Builder excludes(Consumer<FilterRule.Builder> ... var1);

        public Builder includes(Collection<FilterRule> var1);

        public Builder includes(FilterRule ... var1);

        public Builder includes(Consumer<FilterRule.Builder> ... var1);

        public Builder startTime(Instant var1);

        public Builder estimatedFilesToTransfer(Long var1);

        public Builder estimatedBytesToTransfer(Long var1);

        public Builder filesTransferred(Long var1);

        public Builder bytesWritten(Long var1);

        public Builder bytesTransferred(Long var1);

        public Builder result(TaskExecutionResultDetail var1);

        default public Builder result(Consumer<TaskExecutionResultDetail.Builder> result) {
            return this.result((TaskExecutionResultDetail)((TaskExecutionResultDetail.Builder)TaskExecutionResultDetail.builder().applyMutation(result)).build());
        }
    }
}

