/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.http.HttpProtocol;
import com.qcloud.cos.model.DecompressionRequest;
import com.qcloud.cos.model.DecompressionResult;
import com.qcloud.cos.model.ListJobsResult;
import com.qcloud.cos.region.Region;

public class DecompressDemo {
    private static final String secretId = "AKIDXXXXXXXX";
    private static final String secretKey = "1A2Z3YYYYYYYYYY";
    private static final String bucketName = "examplebucket-12500000000";
    private static final String region = "ap-guangzhou";

    public static void main(String[] args) {
        System.out.println(DecompressDemo.postObjectDecompression());
        System.out.println(DecompressDemo.getObjectDecompressionStatus("a.tar.gz"));
        DecompressDemo.listObjectDecompressionJobs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DecompressionResult postObjectDecompression() {
        BasicCOSCredentials cosCredentials = new BasicCOSCredentials(secretId, secretKey);
        ClientConfig clientConfig = new ClientConfig(new Region(region));
        COSClient cosClient = new COSClient(cosCredentials, clientConfig);
        try {
            DecompressionRequest decompressionRequest = new DecompressionRequest().setObjectKey("a.tar.gz").setSourceBucketName(bucketName).setTargetBucketName(bucketName).setPrefixReplaced(true).setResourcesPrefix("").setTargetKeyPrefix("test_out/");
            DecompressionResult decompressionResult = cosClient.postObjectDecompression(decompressionRequest);
            return decompressionResult;
        }
        finally {
            cosClient.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DecompressionResult getObjectDecompressionStatus(String objectKey) {
        BasicCOSCredentials cosCredentials = new BasicCOSCredentials(secretId, secretKey);
        ClientConfig clientConfig = new ClientConfig(new Region(region));
        clientConfig.setHttpProtocol(HttpProtocol.http);
        COSClient cosClient = new COSClient(cosCredentials, clientConfig);
        try {
            DecompressionResult decompressionResult = cosClient.getObjectDecompressionStatus(bucketName, objectKey, null);
            return decompressionResult;
        }
        finally {
            cosClient.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void listObjectDecompressionJobs() {
        BasicCOSCredentials cosCredentials = new BasicCOSCredentials(secretId, secretKey);
        ClientConfig clientConfig = new ClientConfig(new Region(region));
        clientConfig.setHttpProtocol(HttpProtocol.http);
        COSClient cosClient = new COSClient(cosCredentials, clientConfig);
        try {
            ListJobsResult result = cosClient.listObjectDecompressionJobs(bucketName, "Success", "asc", "1000", null);
            System.out.println(result);
        }
        finally {
            cosClient.shutdown();
        }
    }

    private static String getPrefix(String objectKey) {
        int index = objectKey.lastIndexOf(47);
        String parent = "";
        if (index != -1) {
            parent = objectKey.substring(0, index + 1);
        }
        return parent;
    }
}

