/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo.ci;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.demo.ci.ClientUtils;
import com.qcloud.cos.model.GetObjectRequest;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.model.PutObjectResult;
import com.qcloud.cos.model.ciModel.common.ImageProcessRequest;
import com.qcloud.cos.model.ciModel.persistence.CIUploadResult;
import com.qcloud.cos.model.ciModel.persistence.PicOperations;
import com.qcloud.cos.utils.Jackson;
import java.io.File;
import java.util.LinkedList;

public class GoodsMattingDemo {
    public static void main(String[] args) {
        COSClient client = ClientUtils.getTestClient();
        GoodsMattingDemo.putGoodsMatting(client);
    }

    public static void getGoodsMatting(COSClient client) {
        String bucketName = "demo-1234567890";
        String key = "car.jpg";
        GetObjectRequest getObj = new GetObjectRequest(bucketName, key);
        getObj.putCustomQueryParameter("ci-process", "GoodsMatting");
        getObj.putCustomQueryParameter("center-layout", "1");
        ObjectMetadata object = client.getObject(getObj, new File("demo.png"));
    }

    public static void postGoodsMatting(COSClient client) {
        String bucketName = "demo-1234567890";
        String key = "car.jpg";
        ImageProcessRequest imageReq = new ImageProcessRequest(bucketName, key);
        PicOperations picOperations = new PicOperations();
        picOperations.setIsPicInfo(1);
        LinkedList<PicOperations.Rule> ruleList = new LinkedList<PicOperations.Rule>();
        PicOperations.Rule rule1 = new PicOperations.Rule();
        rule1.setBucket(bucketName);
        rule1.setFileId("cat2.jpg");
        rule1.setRule("ci-process=GoodsMatting&center-layout=1&padding-layout=20x10");
        ruleList.add(rule1);
        picOperations.setRules(ruleList);
        imageReq.setPicOperations(picOperations);
        CIUploadResult ciUploadResult = client.processImage(imageReq);
        System.out.println(Jackson.toJsonString(ciUploadResult));
    }

    public static void putGoodsMatting(COSClient cosClient) {
        String bucketName = "demo-1234567890";
        String key = "car3.jpg";
        File localFile = new File("car.jpg");
        PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, key, localFile);
        PicOperations picOperations = new PicOperations();
        picOperations.setIsPicInfo(1);
        LinkedList<PicOperations.Rule> ruleList = new LinkedList<PicOperations.Rule>();
        PicOperations.Rule rule1 = new PicOperations.Rule();
        rule1.setBucket(bucketName);
        rule1.setFileId(key);
        rule1.setRule("ci-process=GoodsMatting&center-layout=1&padding-layout=20x10");
        ruleList.add(rule1);
        picOperations.setRules(ruleList);
        putObjectRequest.setPicOperations(picOperations);
        PutObjectResult putObjectResult = cosClient.putObject(putObjectRequest);
        CIUploadResult ciUploadResult = putObjectResult.getCiUploadResult();
        System.out.println(putObjectResult.getRequestId());
        System.out.println(Jackson.toJsonString(putObjectResult));
    }
}

