/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SubResource;
import com.azure.resourcemanager.network.fluent.models.NatGatewayPropertiesFormat;
import com.azure.resourcemanager.network.models.NatGatewaySku;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

public final class NatGatewayInner
extends Resource {
    @JsonProperty(value="sku")
    private NatGatewaySku sku;
    @JsonProperty(value="properties")
    private NatGatewayPropertiesFormat innerProperties;
    @JsonProperty(value="zones")
    private List<String> zones;
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="id")
    private String id;

    public NatGatewaySku sku() {
        return this.sku;
    }

    public NatGatewayInner withSku(NatGatewaySku sku) {
        this.sku = sku;
        return this;
    }

    private NatGatewayPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    public List<String> zones() {
        return this.zones;
    }

    public NatGatewayInner withZones(List<String> zones) {
        this.zones = zones;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public String id() {
        return this.id;
    }

    public NatGatewayInner withId(String id) {
        this.id = id;
        return this;
    }

    public NatGatewayInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public NatGatewayInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public Integer idleTimeoutInMinutes() {
        return this.innerProperties() == null ? null : this.innerProperties().idleTimeoutInMinutes();
    }

    public NatGatewayInner withIdleTimeoutInMinutes(Integer idleTimeoutInMinutes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NatGatewayPropertiesFormat();
        }
        this.innerProperties().withIdleTimeoutInMinutes(idleTimeoutInMinutes);
        return this;
    }

    public List<SubResource> publicIpAddresses() {
        return this.innerProperties() == null ? null : this.innerProperties().publicIpAddresses();
    }

    public NatGatewayInner withPublicIpAddresses(List<SubResource> publicIpAddresses) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NatGatewayPropertiesFormat();
        }
        this.innerProperties().withPublicIpAddresses(publicIpAddresses);
        return this;
    }

    public List<SubResource> publicIpPrefixes() {
        return this.innerProperties() == null ? null : this.innerProperties().publicIpPrefixes();
    }

    public NatGatewayInner withPublicIpPrefixes(List<SubResource> publicIpPrefixes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NatGatewayPropertiesFormat();
        }
        this.innerProperties().withPublicIpPrefixes(publicIpPrefixes);
        return this;
    }

    public List<SubResource> subnets() {
        return this.innerProperties() == null ? null : this.innerProperties().subnets();
    }

    public String resourceGuid() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceGuid();
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

