/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.client.config;

import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.kubernetes.client.config.KubernetesClientConfigUtils;
import org.springframework.cloud.kubernetes.commons.config.ConfigMapPropertySource;
import org.springframework.core.env.Environment;
import org.springframework.util.CollectionUtils;

public class KubernetesClientConfigMapPropertySource
extends ConfigMapPropertySource {
    private static final Log LOG = LogFactory.getLog(KubernetesClientConfigMapPropertySource.class);

    @Deprecated
    public KubernetesClientConfigMapPropertySource(CoreV1Api coreV1Api, String name, String namespace, Environment environment) {
        super(KubernetesClientConfigMapPropertySource.getName((String)name, (String)KubernetesClientConfigUtils.getApplicationNamespace(namespace, "Config Map", null)), KubernetesClientConfigMapPropertySource.getData(coreV1Api, name, KubernetesClientConfigUtils.getApplicationNamespace(namespace, "Config Map", null), environment, "", true, false));
    }

    public KubernetesClientConfigMapPropertySource(CoreV1Api coreV1Api, String name, String namespace, Environment environment, String prefix, boolean includeProfileSpecificSources, boolean failFast) {
        super(KubernetesClientConfigMapPropertySource.getName((String)name, (String)KubernetesClientConfigUtils.getApplicationNamespace(namespace, "Config Map", null)), KubernetesClientConfigMapPropertySource.getData(coreV1Api, name, KubernetesClientConfigUtils.getApplicationNamespace(namespace, "Config Map", null), environment, prefix, includeProfileSpecificSources, failFast));
    }

    private static Map<String, Object> getData(CoreV1Api coreV1Api, String name, String namespace, Environment environment, String prefix, boolean includeProfileSpecificSources, boolean failFast) {
        LOG.debug((Object)("Loading ConfigMap with name '" + name + "' in namespace '" + namespace + "'"));
        try {
            HashSet<String> names = new HashSet<String>();
            names.add(name);
            if (environment != null && includeProfileSpecificSources) {
                for (String activeProfile : environment.getActiveProfiles()) {
                    names.add(name + "-" + activeProfile);
                }
            }
            HashMap<String, Object> result = new HashMap<String, Object>();
            coreV1Api.listNamespacedConfigMap(namespace, null, null, null, null, null, null, null, null, null, null).getItems().stream().filter(cm -> names.contains(cm.getMetadata().getName())).map(map -> KubernetesClientConfigMapPropertySource.processAllEntries((Map)map.getData(), (Environment)environment)).collect(Collectors.toList()).forEach(result::putAll);
            if (!"".equals(prefix)) {
                HashMap withPrefix = CollectionUtils.newHashMap((int)result.size());
                result.forEach((key, value) -> withPrefix.put(prefix + "." + key, value));
                return withPrefix;
            }
            return result;
        }
        catch (ApiException e) {
            if (failFast) {
                throw new IllegalStateException("Unable to read ConfigMap with name '" + name + "' in namespace '" + namespace + "'", e);
            }
            LOG.warn((Object)("Unable to get ConfigMap " + name + " in namespace " + namespace), (Throwable)e);
            return Collections.emptyMap();
        }
    }
}

