/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.monitor.models.RuleAction;
import com.azure.resourcemanager.monitor.models.RuleCondition;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

public final class AlertRule {
    @JsonProperty(value="name", required=true)
    private String name;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="provisioningState")
    private String provisioningState;
    @JsonProperty(value="isEnabled", required=true)
    private boolean isEnabled;
    @JsonProperty(value="condition", required=true)
    private RuleCondition condition;
    @JsonProperty(value="action")
    private RuleAction action;
    @JsonProperty(value="actions")
    private List<RuleAction> actions;
    @JsonProperty(value="lastUpdatedTime", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime lastUpdatedTime;
    private static final ClientLogger LOGGER = new ClientLogger(AlertRule.class);

    public String name() {
        return this.name;
    }

    public AlertRule withName(String name) {
        this.name = name;
        return this;
    }

    public String description() {
        return this.description;
    }

    public AlertRule withDescription(String description) {
        this.description = description;
        return this;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public AlertRule withProvisioningState(String provisioningState) {
        this.provisioningState = provisioningState;
        return this;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public AlertRule withIsEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    public RuleCondition condition() {
        return this.condition;
    }

    public AlertRule withCondition(RuleCondition condition) {
        this.condition = condition;
        return this;
    }

    public RuleAction action() {
        return this.action;
    }

    public AlertRule withAction(RuleAction action) {
        this.action = action;
        return this;
    }

    public List<RuleAction> actions() {
        return this.actions;
    }

    public AlertRule withActions(List<RuleAction> actions) {
        this.actions = actions;
        return this;
    }

    public OffsetDateTime lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property name in model AlertRule"));
        }
        if (this.condition() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property condition in model AlertRule"));
        }
        this.condition().validate();
        if (this.action() != null) {
            this.action().validate();
        }
        if (this.actions() != null) {
            this.actions().forEach(e -> e.validate());
        }
    }
}

