/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.druid.msq.util;

import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.segment.BaseObjectColumnValueSelector;

import javax.annotation.Nullable;

public class PassthroughAggregator implements Aggregator
{
  private final BaseObjectColumnValueSelector<?> selector;
  private boolean didSet = false;
  private Object val;

  public PassthroughAggregator(final BaseObjectColumnValueSelector<?> selector)
  {
    this.selector = selector;
  }

  @Override
  public void aggregate()
  {
    if (didSet) {
      throw new ISE("Cannot set twice");
    }

    val = selector.getObject();
    didSet = true;
  }

  @Nullable
  @Override
  public Object get()
  {
    if (!didSet) {
      throw new ISE("Cannot call get() before aggregate()");
    }

    return val;
  }

  @Override
  public float getFloat()
  {
    throw new UnsupportedOperationException();
  }

  @Override
  public long getLong()
  {
    throw new UnsupportedOperationException();
  }

  @Override
  public void close()
  {
    // Nothing to do.
  }
}
