/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.app;

import java.util.Iterator;
import javax.el.ELResolver;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.NavigationHandler;
import javax.faces.application.ProjectStage;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.Renderer;
import javax.servlet.ServletContext;
import org.apache.empire.commons.ClassUtils;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.InvalidOperationException;
import org.apache.empire.exceptions.ItemExistsException;
import org.apache.empire.exceptions.ItemNotFoundException;
import org.apache.empire.exceptions.ObjectNotValidException;
import org.apache.empire.jsf2.app.DBELResolver;
import org.apache.empire.jsf2.app.FacesRequestPhaseListener;
import org.apache.empire.jsf2.components.ControlTag;
import org.apache.empire.jsf2.components.FormGridTag;
import org.apache.empire.jsf2.components.InputTag;
import org.apache.empire.jsf2.components.LabelTag;
import org.apache.empire.jsf2.components.LinkTag;
import org.apache.empire.jsf2.components.MenuItemTag;
import org.apache.empire.jsf2.components.MenuListTag;
import org.apache.empire.jsf2.components.RecordTag;
import org.apache.empire.jsf2.components.SelectTag;
import org.apache.empire.jsf2.components.TabPageTag;
import org.apache.empire.jsf2.components.TabViewTag;
import org.apache.empire.jsf2.components.TitleTag;
import org.apache.empire.jsf2.components.UnitTag;
import org.apache.empire.jsf2.components.ValueTag;
import org.apache.empire.jsf2.impl.FacesImplementation;
import org.apache.empire.jsf2.pages.PageNavigationHandler;
import org.apache.empire.jsf2.pages.PagePhaseListener;
import org.apache.empire.jsf2.pages.PagesELResolver;
import org.apache.empire.jsf2.utils.BeanScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FacesConfiguration {
    protected static final Logger log = LoggerFactory.getLogger(FacesConfiguration.class);
    public static final String EMPIRE_COMPONENT_FAMILY = "org.apache.empire.component";
    private static boolean initialized = false;
    private static ProjectStage projectStage;
    protected final FacesImplementation facesImpl;
    protected ExternalContext externalContext;
    protected Application application;
    private FacesImplementation.BeanStorageProvider beanStorage;

    public static boolean isInitialized() {
        return initialized;
    }

    public static ProjectStage getProjectStage() {
        if (projectStage == null) {
            throw new ObjectNotValidException(FacesConfiguration.class, "Not Initialized");
        }
        return projectStage;
    }

    public static <T extends FacesConfiguration> void initialize(Class<T> configClass, FacesContext startupContext, FacesImplementation facesImpl) {
        FacesConfiguration fConfig = (FacesConfiguration)ClassUtils.newInstance(configClass, FacesImplementation.class, (Object)facesImpl);
        fConfig.initialize(startupContext);
    }

    public FacesConfiguration(FacesImplementation facesImpl) {
        this.facesImpl = facesImpl;
    }

    public final void initialize(FacesContext startupContext) {
        if (initialized) {
            throw new InvalidOperationException("FacesConfiguration already initialized!");
        }
        try {
            this.externalContext = startupContext.getExternalContext();
            this.application = startupContext.getApplication();
            this.beanStorage = null;
            projectStage = this.application.getProjectStage();
            log.info("Initializing Faces Configuration for ProjectStage {}", (Object)projectStage.name());
            this.initAll(startupContext);
            log.info("Faces Configuration complete.");
        }
        finally {
            this.beanStorage = null;
            this.application = null;
            this.externalContext = null;
            this.facesImpl.configComplete();
            initialized = true;
        }
    }

    protected void initAll(FacesContext context) {
        log.debug("Init FacesParams...");
        this.initFacesParams();
        log.debug("Init Factories...");
        this.initFactories();
        log.debug("Init NavigationHandler...");
        this.initNavigationHandler();
        log.debug("Init ResourceHandler...");
        this.initResourceHandler();
        log.debug("Registrating Converters...");
        this.initConverters();
        log.debug("Registrating EL-Resolvers...");
        this.initElResolvers();
        log.debug("Registrating Lifecycle...");
        this.initLifecycle(new LifecycleUpdater());
        log.debug("Registrating Search Expression Resolvers...");
        this.initSearchExpressionResolvers();
        log.debug("Registrating Components...");
        this.initComponents();
        log.debug("Registrating Renderers...");
        this.initRenderers(new RenderKitUpdater(this.getApplicationRenderKit(context)));
        log.debug("Registrating Managed Beans...");
        this.initManagedBeans();
        log.debug("Registrating Controls...");
        this.initControls();
    }

    protected void initFacesParams() {
        this.setFacesInitParam("javax.faces.FACELETS_SKIP_COMMENTS", (Object)true);
    }

    protected void initFactories() {
    }

    protected void initNavigationHandler() {
        NavigationHandler wrapped = this.application.getNavigationHandler();
        if (wrapped instanceof PageNavigationHandler) {
            return;
        }
        log.info("Setting NavigationHandler to {}", (Object)PageNavigationHandler.class.getName());
        this.application.setNavigationHandler((NavigationHandler)new PageNavigationHandler(wrapped));
    }

    protected void initResourceHandler() {
    }

    protected void initConverters() {
    }

    protected void initElResolvers() {
        this.addELResolver(DBELResolver.class);
        this.addELResolver(PagesELResolver.class);
    }

    protected void initLifecycle(LifecycleUpdater lcu) {
        lcu.addPhaseListener(FacesRequestPhaseListener.class);
        lcu.addPhaseListener(PagePhaseListener.class);
    }

    protected void initSearchExpressionResolvers() {
    }

    protected void initComponents() {
        this.addComponent(EMPIRE_COMPONENT_FAMILY, ControlTag.class);
        this.addComponent(EMPIRE_COMPONENT_FAMILY, InputTag.class);
        this.addComponent(EMPIRE_COMPONENT_FAMILY, FormGridTag.class);
        this.addComponent(EMPIRE_COMPONENT_FAMILY, LabelTag.class);
        this.addComponent(EMPIRE_COMPONENT_FAMILY, LinkTag.class);
        this.addComponent(EMPIRE_COMPONENT_FAMILY, MenuItemTag.class);
        this.addComponent(EMPIRE_COMPONENT_FAMILY, MenuListTag.class);
        this.addComponent(EMPIRE_COMPONENT_FAMILY, RecordTag.class);
        this.addComponent(EMPIRE_COMPONENT_FAMILY, SelectTag.class);
        this.addComponent(EMPIRE_COMPONENT_FAMILY, TabPageTag.class);
        this.addComponent(EMPIRE_COMPONENT_FAMILY, TabViewTag.class);
        this.addComponent(EMPIRE_COMPONENT_FAMILY, TitleTag.class);
        this.addComponent(EMPIRE_COMPONENT_FAMILY, UnitTag.class);
        this.addComponent(EMPIRE_COMPONENT_FAMILY, ValueTag.class);
    }

    protected void initRenderers(RenderKitUpdater rku) {
    }

    protected void initManagedBeans() {
    }

    protected void initControls() {
    }

    protected FacesImplementation.BeanStorageProvider getBeanStorageProvider() {
        if (this.beanStorage == null) {
            this.beanStorage = this.facesImpl.getBeanStorageProvider(this.externalContext);
        }
        return this.beanStorage;
    }

    protected RenderKit getApplicationRenderKit(FacesContext context) {
        String renderKitId = StringUtils.coalesce((String)this.application.getDefaultRenderKitId(), (String)"HTML_BASIC");
        return ((RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory")).getRenderKit(context, renderKitId);
    }

    protected void setFacesInitParam(String paramName, Object paramValue, boolean overwriteExisting) {
        String orgValue;
        if (StringUtils.isEmpty((String)paramName)) {
            throw new InvalidArgumentException("paramName", (Object)paramName);
        }
        if ("javax.faces.PROJECT_STAGE".equals(paramName)) {
            throw new InvalidOperationException("javax.faces.PROJECT_STAGE cannot be changed!");
        }
        ServletContext sc = (ServletContext)this.externalContext.getContext();
        String paramVal = StringUtils.toString((Object)paramValue);
        if (ObjectUtils.compareEqual((Object)paramVal, (Object)(orgValue = sc.getInitParameter(paramName)))) {
            return;
        }
        if (ObjectUtils.isNotEmpty((Object)orgValue) && !overwriteExisting) {
            log.info("Ignoring FacesParam \"{}\" (\"{}\"). Keeping current value of \"{}\"", new Object[]{paramName, paramVal, orgValue});
            return;
        }
        if (orgValue != null) {
            log.info("Setting FacesParam \"{}\" to \"{}\". Original value was \"{}\"", new Object[]{paramName, paramVal, orgValue});
        } else {
            log.info("Setting FacesParam \"{}\" to \"{}\".", (Object)paramName, (Object)paramVal);
        }
        sc.setInitParameter(paramName, paramVal);
    }

    protected void setFacesInitParam(String paramName, Object paramValue) {
        this.setFacesInitParam(paramName, paramValue, false);
    }

    protected void setFacesInitParam(Enum<?> paramName, Object paramValue) {
        this.setFacesInitParam(paramName.toString(), paramValue, false);
    }

    protected void addConverter(Class<?> targetClass, Class<? extends Converter> converterClass) {
        log.info("Adding Type-Converter for type \"{}\" using {}", (Object)targetClass.getName(), (Object)converterClass.getName());
        this.application.addConverter(targetClass, converterClass.getName());
    }

    protected void addComponent(String componentFamily, Class<? extends UIComponent> clazz) {
        String type = StringUtils.concat((String[])new String[]{componentFamily, ".", clazz.getSimpleName()});
        log.info("Adding component type \"{}\" using {}", (Object)type, (Object)clazz.getName());
        this.application.addComponent(type, clazz.getName());
    }

    protected void addManagedBean(String beanName, Class<?> beanClass, BeanScope beanScope) {
        String scope = beanScope.name().toLowerCase();
        this.facesImpl.registerManagedBean(beanName, beanClass.getName(), scope);
    }

    protected void addManagedBean(Class<?> beanClass, BeanScope scope) {
        if (beanClass == null || scope == null) {
            throw new InvalidArgumentException("beanClass|scope", null);
        }
        String className = beanClass.getName();
        int nameIndex = className.lastIndexOf(46) + 1;
        String beanName = className.substring(nameIndex, nameIndex + 1).toLowerCase() + className.substring(nameIndex + 1);
        this.addManagedBean(beanName, beanClass, scope);
    }

    protected void replaceComponent(String componentType, Class<? extends UIComponent> overrideComponent) {
        if (StringUtils.isEmpty((String)componentType)) {
            throw new InvalidArgumentException("componentType", (Object)componentType);
        }
        this.checkComponentTypeExists(componentType);
        log.info("Replacing component type \"{}\" with {}", (Object)componentType, (Object)overrideComponent.getName());
        this.application.addComponent(componentType, overrideComponent.getName());
    }

    protected void replaceComponent(Class<? extends UIComponent> componentClassWithType, Class<? extends UIComponent> overrideComponent) {
        String componentType = (String)ClassUtils.getFieldValue(componentClassWithType, null, (String)"COMPONENT_TYPE", (boolean)true);
        this.replaceComponent(componentType, overrideComponent);
    }

    protected void replaceComponent(String componentFamily, Class<? extends UIComponent> componentClassToReplace, Class<? extends UIComponent> overrideComponent) {
        String componentType = StringUtils.concat((String[])new String[]{componentFamily, ".", componentClassToReplace.getSimpleName()});
        this.replaceComponent(componentType, overrideComponent);
    }

    protected void checkComponentTypeExists(String componentType) {
        Iterator types = this.application.getComponentTypes();
        while (types.hasNext()) {
            String type = (String)types.next();
            if (!componentType.equals(type)) continue;
            return;
        }
        throw new ItemNotFoundException((Object)("Component-Type: " + componentType));
    }

    protected void addELResolver(Class<? extends ELResolver> resolverClass) {
        boolean added = this.facesImpl.registerElResolver(resolverClass);
        if (added) {
            log.info("Adding FacesConfigElResolver {}", (Object)resolverClass.getName());
        }
    }

    protected void listCompoennts() {
        ConfigTypeList list = new ConfigTypeList("Component-Types");
        Iterator types = this.application.getComponentTypes();
        while (types.hasNext()) {
            String componentType = (String)types.next();
            list.addItem(componentType, new Object[0]);
        }
        log.info(list.toString());
    }

    protected static class ConfigTypeList {
        private static final String CRLF = "\r\n";
        private static final String TAB = "\t";
        private final StringBuilder b = new StringBuilder(200);

        public ConfigTypeList(String listName) {
            this.b.append(listName);
            this.b.append(":");
            this.b.append(CRLF);
        }

        public void addItem(Object item, Object ... more) {
            this.b.append(TAB);
            this.b.append(this.toString(item));
            for (int i = 0; i < more.length; ++i) {
                this.b.append(TAB);
                this.b.append(this.toString(more[i]));
            }
            this.b.append(CRLF);
        }

        protected String toString(Object o) {
            if (o instanceof Class) {
                return ((Class)o).getName();
            }
            if (o instanceof Enum) {
                return ((Enum)o).name();
            }
            return String.valueOf(o);
        }

        public String toString() {
            return this.b.toString();
        }
    }

    protected class LifecycleUpdater {
        private final Lifecycle lifecycle;
        private PhaseListener[] phaseListeners;

        public LifecycleUpdater() {
            LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
            this.lifecycle = lifecycleFactory.getLifecycle("DEFAULT");
            this.phaseListeners = this.lifecycle.getPhaseListeners();
        }

        public void listAll() {
            ConfigTypeList list = new ConfigTypeList("Phase-Listeners");
            for (PhaseListener pl : this.phaseListeners = this.lifecycle.getPhaseListeners()) {
                list.addItem(pl.getClass(), pl.getPhaseId());
            }
            log.info(list.toString());
        }

        public void addPhaseListener(Class<? extends PhaseListener> phaseListenerClass) {
            for (PhaseListener pl : this.phaseListeners) {
                if (!pl.getClass().equals(phaseListenerClass)) continue;
                return;
            }
            log.info("Adding Lifecycle PhaseListener {}", (Object)phaseListenerClass.getName());
            PhaseListener listener = (PhaseListener)ClassUtils.newInstance(phaseListenerClass);
            FacesConfiguration.this.getBeanStorageProvider().injectBean(listener);
            this.lifecycle.addPhaseListener(listener);
        }
    }

    protected class RenderKitUpdater {
        private final RenderKit renderKit;

        public RenderKitUpdater(RenderKit renderKit) {
            this.renderKit = renderKit;
        }

        public RenderKit getRenderKit() {
            return this.renderKit;
        }

        public void listAll() {
            ConfigTypeList list = new ConfigTypeList("Renderer-Types");
            Iterator families = this.renderKit.getComponentFamilies();
            while (families.hasNext()) {
                String componentFamily = (String)families.next();
                Iterator types = this.renderKit.getRendererTypes(componentFamily);
                while (types.hasNext()) {
                    String rendererType = (String)types.next();
                    list.addItem(componentFamily, rendererType);
                }
            }
            log.info(list.toString());
        }

        public void add(String componentFamily, String rendererType, Class<? extends Renderer> rendererClass) {
            Renderer check = this.findRenderer(componentFamily, rendererType);
            if (check != null) {
                if (check.getClass().equals(rendererClass)) {
                    return;
                }
                throw new ItemExistsException((Object)StringUtils.concat((String[])new String[]{componentFamily, " / ", rendererType}));
            }
            log.info("Adding Renderer type \"{}\" using {}", (Object)rendererType, (Object)rendererClass.getName());
            this.renderKit.addRenderer(componentFamily, rendererType, (Renderer)ClassUtils.newInstance(rendererClass));
        }

        public void replace(String componentFamily, String rendererType, Class<? extends Renderer> replaceClass) {
            Renderer check = this.findRenderer(componentFamily, rendererType);
            if (check == null) {
                throw new ItemNotFoundException((Object)StringUtils.concat((String[])new String[]{componentFamily, " / ", rendererType}));
            }
            if (check.getClass().equals(replaceClass)) {
                return;
            }
            log.info("Replacing Renderer type \"{}\" with class {}", (Object)rendererType, (Object)replaceClass.getName());
            this.renderKit.addRenderer(componentFamily, rendererType, (Renderer)ClassUtils.newInstance(replaceClass));
        }

        private Renderer findRenderer(String componentFamily, String rendererType) {
            Iterator families = this.renderKit.getComponentFamilies();
            while (families.hasNext()) {
                String family = (String)families.next();
                if (!componentFamily.equals(family)) continue;
                Iterator types = this.renderKit.getRendererTypes(family);
                while (types.hasNext()) {
                    String type = (String)types.next();
                    if (!rendererType.equals(type)) continue;
                    return this.renderKit.getRenderer(componentFamily, rendererType);
                }
            }
            return null;
        }
    }
}

