/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.expr.column;

import java.util.Set;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBCommand;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBExpr;
import org.apache.empire.db.DBRowSet;
import org.apache.empire.db.DBSQLBuilder;
import org.apache.empire.db.expr.column.DBPreparable;
import org.apache.empire.xml.XMLUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class DBScalarExpr
extends DBColumnExpr
implements DBPreparable {
    protected static final Logger log = LoggerFactory.getLogger(DBScalarExpr.class);
    public final DBDatabase db;
    public final DataType dataType;
    public final String template;
    protected Object[] params;

    public DBScalarExpr(DBDatabase db, String template, Object[] params, DataType dataType) {
        this.db = db;
        this.dataType = dataType;
        this.template = template;
        this.params = params;
    }

    public DBScalarExpr(DBDatabase db, String template, Object param, DataType dataType) {
        this.db = db;
        this.dataType = dataType;
        this.template = template;
        this.params = new Object[]{param};
    }

    public Object[] getParams() {
        return this.params;
    }

    public void setParams(Object[] params) {
        this.params = params;
    }

    public final DBDatabase getDatabase() {
        return this.db;
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    public Class<Enum<?>> getEnumType() {
        return null;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public DBRowSet getRowSet() {
        return null;
    }

    @Override
    public DBColumn getUpdateColumn() {
        return null;
    }

    @Override
    public boolean isAggregate() {
        return false;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof DBScalarExpr) {
            DBScalarExpr otherFunc = (DBScalarExpr)other;
            if (!this.dataType.equals((Object)otherFunc.dataType)) {
                return false;
            }
            return StringUtils.compareEqual(this.template, otherFunc.template);
        }
        return false;
    }

    @Override
    public void prepareParams(DBCommand cmd, DBExpr parent) {
        if (this.params.length == 0) {
            return;
        }
        Object value = this.params[0];
        if (value instanceof DBPreparable) {
            ((DBPreparable)value).prepareParams(cmd, this);
            return;
        }
    }

    @Override
    public void addReferencedColumns(Set<DBColumn> list) {
    }

    @Override
    public void addSQL(DBSQLBuilder sql, long context) {
        sql.appendTemplate(this.template, this.params, new DataType[]{this.dataType}, 7L, ",");
    }

    @Override
    public Element addXml(Element parent, long flags) {
        Element elem = XMLUtil.addElement(parent, "column");
        String name = this.getName();
        if (name != null) {
            elem.setAttribute("name", this.getName());
        }
        if (this.attributes != null) {
            this.attributes.addXml(elem, flags);
        }
        elem.setAttribute("function", this.template);
        return elem;
    }
}

