/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.dbms.postgresql;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBRowSet;
import org.apache.empire.db.DBSQLBuilder;
import org.w3c.dom.Element;

public class PostgresIntervalExpr
extends DBColumnExpr {
    private final DBDatabase db;
    private final Map<PostgresIntervalUnitField, Integer> fields = new HashMap<PostgresIntervalUnitField, Integer>();

    public PostgresIntervalExpr(DBDatabase db, int quantity, PostgresIntervalUnitField unit) {
        this.db = db;
        this.fields.put(unit, quantity);
    }

    public final DBDatabase getDatabase() {
        return this.db;
    }

    @Override
    public DataType getDataType() {
        return DataType.UNKNOWN;
    }

    @Override
    public Class<Enum<?>> getEnumType() {
        return null;
    }

    @Override
    public String getName() {
        return "interval";
    }

    @Override
    public DBRowSet getRowSet() {
        return null;
    }

    @Override
    public DBColumn getUpdateColumn() {
        return null;
    }

    @Override
    public boolean isAggregate() {
        return false;
    }

    @Override
    public Element addXml(Element parent, long flags) {
        return null;
    }

    @Override
    public void addSQL(DBSQLBuilder sql, long context) {
        sql.append("interval");
        sql.append(" '");
        this.appendIfAdded(PostgresIntervalUnitField.YEARS, sql, context);
        this.appendIfAdded(PostgresIntervalUnitField.MONTHS, sql, context);
        this.appendIfAdded(PostgresIntervalUnitField.WEEKS, sql, context);
        this.appendIfAdded(PostgresIntervalUnitField.DAYS, sql, context);
        this.appendIfAdded(PostgresIntervalUnitField.HOURS, sql, context);
        this.appendIfAdded(PostgresIntervalUnitField.MINUTES, sql, context);
        this.appendIfAdded(PostgresIntervalUnitField.SECONDS, sql, context);
        sql.reset(sql.length() - 1);
        sql.append("' ");
    }

    private void appendIfAdded(PostgresIntervalUnitField unit, DBSQLBuilder sql, long context) {
        if (this.fields.containsKey((Object)unit) && this.fields.get((Object)unit) != null) {
            sql.append(this.fields.get((Object)unit).intValue());
            sql.append(" ");
            sql.append(unit.name());
            sql.append(" ");
        }
    }

    public PostgresIntervalExpr add(int quantity, PostgresIntervalUnitField unit) {
        this.fields.put(unit, quantity);
        return this;
    }

    @Override
    public void addReferencedColumns(Set<DBColumn> list) {
    }

    public static enum PostgresIntervalUnitField {
        YEARS,
        MONTHS,
        WEEKS,
        DAYS,
        HOURS,
        MINUTES,
        SECONDS;

    }
}

