/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.expr.column;

import java.util.Set;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBColumnExpr;
import org.apache.empire.db.DBCommandExpr;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBRowSet;
import org.apache.empire.db.DBSQLBuilder;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.xml.XMLUtil;
import org.w3c.dom.Element;

public class DBCmdResultExpr
extends DBColumnExpr {
    private final DBCommandExpr cmdExpr;
    private final DBColumnExpr result;

    public DBCmdResultExpr(DBCommandExpr cmdExpr) {
        this.cmdExpr = cmdExpr;
        DBColumnExpr[] sel = cmdExpr.getSelectExprList();
        if (sel.length != 1) {
            throw new InvalidArgumentException("cmdExpr", cmdExpr);
        }
        this.result = sel[0];
    }

    @Override
    public <T extends DBDatabase> T getDatabase() {
        return this.cmdExpr.getDatabase();
    }

    @Override
    public Class<Enum<?>> getEnumType() {
        return this.result.getEnumType();
    }

    @Override
    public DataType getDataType() {
        return this.result.getDataType();
    }

    @Override
    public String getName() {
        return "SEL_" + this.result.getName();
    }

    @Override
    public boolean isAggregate() {
        return false;
    }

    @Override
    public DBRowSet getRowSet() {
        return this.result.getRowSet();
    }

    @Override
    public DBColumn getUpdateColumn() {
        return null;
    }

    @Override
    public void addReferencedColumns(Set<DBColumn> list) {
    }

    @Override
    public void addSQL(DBSQLBuilder sql, long context) {
        this.cmdExpr.addSQL(sql, context);
    }

    @Override
    public Element addXml(Element parent, long flags) {
        Element elem = XMLUtil.addElement(parent, "column");
        elem.setAttribute("name", this.getName());
        elem.setAttribute("function", "cmd");
        elem.setAttribute("dataType", this.getDataType().name());
        elem.setAttribute("aggregate", "true");
        return elem;
    }
}

