/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.flink.api.java.typeutils;

import org.apache.flink.api.common.functions.InvalidTypesException;
import org.apache.flink.api.common.typeutils.TypeInformationTestBase;

class MissingTypeInfoTest extends TypeInformationTestBase<MissingTypeInfo> {
    private static final String functionName = "foobar";
    private static final InvalidTypesException testException =
            new InvalidTypesException("Test exception.");

    @Override
    protected MissingTypeInfo[] getTestData() {
        return new MissingTypeInfo[] {
            new MissingTypeInfo(functionName, testException),
            new MissingTypeInfo("alt" + functionName, testException)
        };
    }

    @Override
    protected void testSerialization() {
        // this class is not intended to be serialized
    }

    @Override
    protected void testGetTotalFields() {
        // getTotalFields is not meant to be called
    }
}
