/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.table.batch.compact;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.connector.file.table.FileSystemCommitter;
import org.apache.flink.connector.file.table.FileSystemFactory;
import org.apache.flink.connector.file.table.PartitionCommitPolicy;
import org.apache.flink.connector.file.table.PartitionCommitPolicyFactory;
import org.apache.flink.connector.file.table.TableMetaStoreFactory;
import org.apache.flink.connector.file.table.stream.compact.CompactMessages;
import org.apache.flink.core.fs.Path;
import org.apache.flink.streaming.api.functions.sink.RichSinkFunction;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.ObjectIdentifier;

public class BatchPartitionCommitterSink
extends RichSinkFunction<CompactMessages.CompactOutput> {
    private static final long serialVersionUID = 1L;
    private final FileSystemFactory fsFactory;
    private final TableMetaStoreFactory msFactory;
    private final PartitionCommitPolicyFactory partitionCommitPolicyFactory;
    private final Path tmpPath;
    private final boolean overwrite;
    private final boolean isToLocal;
    private final String[] partitionColumns;
    private final LinkedHashMap<String, String> staticPartitions;
    private final ObjectIdentifier identifier;
    private transient Map<String, List<Path>> partitionsFiles;

    public BatchPartitionCommitterSink(FileSystemFactory fsFactory, TableMetaStoreFactory msFactory, boolean overwrite, boolean isToLocal, Path tmpPath, String[] partitionColumns, LinkedHashMap<String, String> staticPartitions, ObjectIdentifier identifier, PartitionCommitPolicyFactory partitionCommitPolicyFactory) {
        this.fsFactory = fsFactory;
        this.msFactory = msFactory;
        this.partitionCommitPolicyFactory = partitionCommitPolicyFactory;
        this.tmpPath = tmpPath;
        this.identifier = identifier;
        this.overwrite = overwrite;
        this.isToLocal = isToLocal;
        this.partitionColumns = partitionColumns;
        this.staticPartitions = staticPartitions;
    }

    public void open(OpenContext openContext) throws Exception {
        this.partitionsFiles = new HashMap<String, List<Path>>();
    }

    public void invoke(CompactMessages.CompactOutput compactOutput, SinkFunction.Context context) throws Exception {
        for (Map.Entry<String, List<Path>> compactFiles : compactOutput.getCompactedFiles().entrySet()) {
            this.partitionsFiles.computeIfAbsent(compactFiles.getKey(), k -> new ArrayList()).addAll((Collection)compactFiles.getValue());
        }
    }

    public void finish() throws Exception {
        try {
            List<PartitionCommitPolicy> policies = Collections.emptyList();
            if (this.partitionCommitPolicyFactory != null) {
                policies = this.partitionCommitPolicyFactory.createPolicyChain(this.getRuntimeContext().getUserCodeClassLoader(), () -> {
                    try {
                        return this.fsFactory.create(this.tmpPath.toUri());
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            FileSystemCommitter committer = new FileSystemCommitter(this.fsFactory, this.msFactory, this.overwrite, this.tmpPath, this.partitionColumns.length, this.isToLocal, this.identifier, this.staticPartitions, policies);
            committer.commitPartitionsWithFiles(this.partitionsFiles);
        }
        catch (Exception e) {
            throw new TableException("Exception in finish", (Throwable)e);
        }
        finally {
            try {
                this.fsFactory.create(this.tmpPath.toUri()).delete(this.tmpPath, true);
            }
            catch (IOException iOException) {}
        }
    }

    public void close() throws Exception {
        this.staticPartitions.clear();
        this.partitionsFiles.clear();
    }
}

