/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.messaging.handling;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.helix.AccessOption;
import org.apache.helix.ConfigAccessor;
import org.apache.helix.Criteria;
import org.apache.helix.HelixConstants;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixException;
import org.apache.helix.HelixManager;
import org.apache.helix.InstanceType;
import org.apache.helix.NotificationContext;
import org.apache.helix.PropertyKey;
import org.apache.helix.api.listeners.MessageListener;
import org.apache.helix.api.listeners.PreFetch;
import org.apache.helix.controller.GenericHelixController;
import org.apache.helix.manager.zk.ParticipantManager;
import org.apache.helix.messaging.handling.HelixStateTransitionHandler;
import org.apache.helix.messaging.handling.HelixTask;
import org.apache.helix.messaging.handling.HelixTaskResult;
import org.apache.helix.messaging.handling.MessageHandler;
import org.apache.helix.messaging.handling.MessageHandlerFactory;
import org.apache.helix.messaging.handling.MessageTask;
import org.apache.helix.messaging.handling.MessageTaskInfo;
import org.apache.helix.messaging.handling.MessageTimeoutTask;
import org.apache.helix.messaging.handling.MultiTypeMessageHandlerFactory;
import org.apache.helix.messaging.handling.TaskExecutor;
import org.apache.helix.model.CurrentState;
import org.apache.helix.model.HelixConfigScope;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.model.Message;
import org.apache.helix.model.builder.HelixConfigScopeBuilder;
import org.apache.helix.monitoring.mbeans.MessageQueueMonitor;
import org.apache.helix.monitoring.mbeans.ParticipantMessageMonitor;
import org.apache.helix.monitoring.mbeans.ParticipantStatusMonitor;
import org.apache.helix.participant.HelixStateMachineEngine;
import org.apache.helix.participant.statemachine.StateModel;
import org.apache.helix.participant.statemachine.StateModelFactory;
import org.apache.helix.util.HelixUtil;
import org.apache.helix.util.StatusUpdateUtil;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.helix.zookeeper.zkclient.DataUpdater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelixTaskExecutor
implements MessageListener,
TaskExecutor {
    private static Logger LOG = LoggerFactory.getLogger(HelixTaskExecutor.class);
    private static AtomicLong thread_uid = new AtomicLong(0L);
    public static final int DEFAULT_PARALLEL_TASKS = 40;
    protected final Map<String, MessageTaskInfo> _taskMap;
    private final Object _lock;
    private final StatusUpdateUtil _statusUpdateUtil;
    private final ParticipantStatusMonitor _monitor;
    public static final String MAX_THREADS = "maxThreads";
    private volatile boolean _isCleanState = true;
    private MessageQueueMonitor _messageQueueMonitor;
    private GenericHelixController _controller;
    private Long _lastSessionSyncTime;
    private String _freezeSessionId;
    private LiveInstance.LiveInstanceStatus _liveInstanceStatus;
    private static final int SESSION_SYNC_INTERVAL = 2000;
    private static final String SESSION_SYNC = "SESSION-SYNC";
    final ConcurrentHashMap<String, MsgHandlerFactoryRegistryItem> _hdlrFtyRegistry;
    final ConcurrentHashMap<String, ExecutorService> _executorMap;
    final ExecutorService _batchMessageExecutorService;
    final ConcurrentHashMap<String, String> _messageTaskMap;
    final Set<String> _knownMessageIds;
    final Set<String> _resourcesThreadpoolChecked;
    final Set<String> _transitionTypeThreadpoolChecked;
    final Set<String> _msgInfoBasedThreadpoolChecked;
    final Timer _timer;
    private boolean _isShuttingDown;

    public HelixTaskExecutor() {
        this(new ParticipantStatusMonitor(false, null), null);
    }

    public HelixTaskExecutor(ParticipantStatusMonitor participantStatusMonitor) {
        this(participantStatusMonitor, null);
    }

    public HelixTaskExecutor(ParticipantStatusMonitor participantStatusMonitor, MessageQueueMonitor messageQueueMonitor) {
        this._monitor = participantStatusMonitor;
        this._messageQueueMonitor = messageQueueMonitor;
        this._taskMap = new ConcurrentHashMap<String, MessageTaskInfo>();
        this._hdlrFtyRegistry = new ConcurrentHashMap();
        this._executorMap = new ConcurrentHashMap();
        this._messageTaskMap = new ConcurrentHashMap();
        this._knownMessageIds = Collections.newSetFromMap(new ConcurrentHashMap());
        this._batchMessageExecutorService = Executors.newCachedThreadPool();
        this._monitor.createExecutorMonitor("BatchMessageExecutor", this._batchMessageExecutorService);
        this._resourcesThreadpoolChecked = Collections.newSetFromMap(new ConcurrentHashMap());
        this._transitionTypeThreadpoolChecked = Collections.newSetFromMap(new ConcurrentHashMap());
        this._msgInfoBasedThreadpoolChecked = Collections.newSetFromMap(new ConcurrentHashMap());
        this._lock = new Object();
        this._statusUpdateUtil = new StatusUpdateUtil();
        this._timer = new Timer("HelixTaskExecutor_Timer", true);
        this._isShuttingDown = false;
        this._liveInstanceStatus = LiveInstance.LiveInstanceStatus.NORMAL;
        this.startMonitorThread();
    }

    @Override
    public void registerMessageHandlerFactory(MultiTypeMessageHandlerFactory factory, int threadPoolSize, int resetTimeoutMs) {
        for (String type : factory.getMessageTypes()) {
            this.registerMessageHandlerFactory(type, factory, threadPoolSize, resetTimeoutMs);
        }
    }

    @Override
    public void registerMessageHandlerFactory(String type, MessageHandlerFactory factory) {
        this.registerMessageHandlerFactory(type, factory, 40);
    }

    @Override
    public void registerMessageHandlerFactory(String type, MessageHandlerFactory factory, int threadpoolSize) {
        this.registerMessageHandlerFactory(type, factory, threadpoolSize, 200);
    }

    private void registerMessageHandlerFactory(String type, MessageHandlerFactory factory, int threadpoolSize, int resetTimeoutMs) {
        if (factory instanceof MultiTypeMessageHandlerFactory) {
            if (!((MultiTypeMessageHandlerFactory)factory).getMessageTypes().contains(type)) {
                throw new HelixException("Message factory type mismatch. Type: " + type + ", factory: " + ((MultiTypeMessageHandlerFactory)factory).getMessageTypes());
            }
        } else if (!factory.getMessageType().equals(type)) {
            throw new HelixException("Message factory type mismatch. Type: " + type + ", factory: " + factory.getMessageType());
        }
        this._isShuttingDown = false;
        MsgHandlerFactoryRegistryItem newItem = new MsgHandlerFactoryRegistryItem(factory, threadpoolSize, resetTimeoutMs);
        MsgHandlerFactoryRegistryItem prevItem = this._hdlrFtyRegistry.putIfAbsent(type, newItem);
        if (prevItem == null) {
            this._executorMap.computeIfAbsent(type, msgType -> {
                ExecutorService newPool = Executors.newFixedThreadPool(threadpoolSize, r -> new Thread(r, "HelixTaskExecutor-message_handle_thread_" + thread_uid.getAndIncrement()));
                this._monitor.createExecutorMonitor(type, newPool);
                return newPool;
            });
            LOG.info("Registered message handler factory for type: {}, poolSize: {}, factory: {}, pool: {}", new Object[]{type, threadpoolSize, factory, this._executorMap.get(type)});
        } else {
            LOG.info("Skip register message handler factory for type: {}, poolSize: {}, factory: {}, already existing factory: {}", new Object[]{type, threadpoolSize, factory, prevItem.factory()});
        }
    }

    public void setController(GenericHelixController controller) {
        this._controller = controller;
    }

    public ParticipantStatusMonitor getParticipantMonitor() {
        return this._monitor;
    }

    private void startMonitorThread() {
    }

    private void updateStateTransitionMessageThreadPool(Message message, HelixManager manager) {
        String msgInfoBasedKey;
        StateModelFactory.CustomizedExecutorService customizedExecutorService;
        if (!message.getMsgType().equals(Message.MessageType.STATE_TRANSITION.name())) {
            return;
        }
        String resourceName = message.getResourceName();
        String factoryName = message.getStateModelFactoryName();
        String stateModelName = message.getStateModelDef();
        if (factoryName == null) {
            factoryName = "DEFAULT";
        }
        StateModelFactory<? extends StateModel> stateModelFactory = manager.getStateMachineEngine().getStateModelFactory(stateModelName, factoryName);
        Message.MessageInfo msgInfo = new Message.MessageInfo(message);
        if (stateModelFactory != null && (customizedExecutorService = stateModelFactory.getExecutorService(msgInfo)) != null && (msgInfoBasedKey = msgInfo.getMessageIdentifier(customizedExecutorService.getBase())) != null) {
            this._msgInfoBasedThreadpoolChecked.add(msgInfoBasedKey);
            this._executorMap.put(msgInfoBasedKey, customizedExecutorService.getExecutorService());
            return;
        }
        String perStateTransitionTypeKey = msgInfo.getMessageIdentifier(Message.MessageInfo.MessageIdentifierBase.PER_STATE_TRANSITION_TYPE);
        if (perStateTransitionTypeKey != null && stateModelFactory != null && !this._transitionTypeThreadpoolChecked.contains(perStateTransitionTypeKey)) {
            ExecutorService perStateTransitionTypeExecutor = stateModelFactory.getExecutorService(resourceName, message.getFromState(), message.getToState());
            this._transitionTypeThreadpoolChecked.add(perStateTransitionTypeKey);
            if (perStateTransitionTypeExecutor != null) {
                this._executorMap.put(perStateTransitionTypeKey, perStateTransitionTypeExecutor);
                LOG.info(String.format("Added client specified dedicate threadpool for resource %s from %s to %s", msgInfo.getMessageIdentifier(Message.MessageInfo.MessageIdentifierBase.PER_RESOURCE), message.getFromState(), message.getToState()));
                return;
            }
        }
        if (!this._resourcesThreadpoolChecked.contains(resourceName)) {
            int threadpoolSize = -1;
            ConfigAccessor configAccessor = manager.getConfigAccessor();
            if (configAccessor != null) {
                HelixConfigScope scope = new HelixConfigScopeBuilder(HelixConfigScope.ConfigScopeProperty.RESOURCE).forCluster(manager.getClusterName()).forResource(resourceName).build();
                String threadpoolSizeStr = configAccessor.get(scope, MAX_THREADS);
                try {
                    if (threadpoolSizeStr != null) {
                        threadpoolSize = Integer.parseInt(threadpoolSizeStr);
                    }
                }
                catch (Exception e) {
                    LOG.error("Failed to parse ThreadPoolSize from resourceConfig for resource" + resourceName, (Throwable)e);
                }
            }
            String key = msgInfo.getMessageIdentifier(Message.MessageInfo.MessageIdentifierBase.PER_RESOURCE);
            if (threadpoolSize > 0) {
                this._executorMap.put(key, Executors.newFixedThreadPool(threadpoolSize, r -> new Thread(r, "GerenricHelixController-message_handle_" + key)));
                LOG.info("Added dedicate threadpool for resource: " + resourceName + " with size: " + threadpoolSize);
            } else if (stateModelFactory != null) {
                ExecutorService executor = stateModelFactory.getExecutorService(resourceName);
                if (executor != null) {
                    this._executorMap.put(key, executor);
                    LOG.info("Added client specified dedicate threadpool for resource: " + key);
                }
            } else {
                LOG.error(String.format("Fail to get dedicate threadpool defined in stateModelFactory %s: using factoryName: %s for resource %s. No stateModelFactory was found!", stateModelName, factoryName, resourceName));
            }
            this._resourcesThreadpoolChecked.add(resourceName);
        }
    }

    ExecutorService findExecutorServiceForMsg(Message message) {
        ExecutorService executorService = this._executorMap.get(message.getMsgType());
        if (message.getMsgType().equals(Message.MessageType.STATE_TRANSITION.name())) {
            if (message.getBatchMessageMode()) {
                executorService = this._batchMessageExecutorService;
            } else {
                Message.MessageInfo msgInfo = new Message.MessageInfo(message);
                for (int i = Message.MessageInfo.MessageIdentifierBase.values().length - 1; i >= 0; --i) {
                    String msgIdentifer = msgInfo.getMessageIdentifier(Message.MessageInfo.MessageIdentifierBase.values()[i]);
                    if (msgIdentifer == null || !this._executorMap.containsKey(msgIdentifer)) continue;
                    LOG.info(String.format("Find customized threadpool for %s", msgIdentifer));
                    executorService = this._executorMap.get(msgIdentifer);
                    break;
                }
            }
        }
        return executorService;
    }

    @Override
    public List<Future<HelixTaskResult>> invokeAllTasks(List<MessageTask> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        if (tasks == null || tasks.size() == 0) {
            return null;
        }
        ExecutorService exeSvc = this.findExecutorServiceForMsg(tasks.get(0).getMessage());
        for (int i = 1; i < tasks.size(); ++i) {
            MessageTask task = tasks.get(i);
            ExecutorService curExeSvc = this.findExecutorServiceForMsg(task.getMessage());
            if (curExeSvc == exeSvc) continue;
            LOG.error("Fail to invoke all tasks because they are not using the same executor-service");
            return null;
        }
        List<Future<HelixTaskResult>> futures = exeSvc.invokeAll(tasks, timeout, unit);
        return futures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancelTimeoutTask(MessageTask task) {
        Object object = this._lock;
        synchronized (object) {
            String taskId = task.getTaskId();
            if (this._taskMap.containsKey(taskId)) {
                MessageTaskInfo info = this._taskMap.get(taskId);
                this.removeMessageFromTaskAndFutureMap(task.getMessage());
                if (info._timerTask != null) {
                    info._timerTask.cancel();
                }
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean scheduleTask(MessageTask task) {
        String taskId = task.getTaskId();
        Message message = task.getMessage();
        NotificationContext notificationContext = task.getNotificationContext();
        HelixManager manager = notificationContext.getManager();
        try {
            this.updateStateTransitionMessageThreadPool(message, manager);
            LOG.info("Scheduling message {}: {}:{}, {}->{}", new Object[]{taskId, message.getResourceName(), message.getPartitionName(), message.getFromState(), message.getToState()});
            this._statusUpdateUtil.logInfo(message, HelixTaskExecutor.class, "Message handling task scheduled", manager);
            Object object = this._lock;
            synchronized (object) {
                if (!this._taskMap.containsKey(taskId)) {
                    ExecutorService exeSvc = this.findExecutorServiceForMsg(message);
                    if (exeSvc == null) {
                        LOG.warn(String.format("Threadpool is null for type %s of message %s", message.getMsgType(), message.getMsgId()));
                        return false;
                    }
                    LOG.info("Submit task: " + taskId + " to pool: " + exeSvc);
                    Future<HelixTaskResult> future = exeSvc.submit(task);
                    this._messageTaskMap.putIfAbsent(this.getMessageTarget(message.getResourceName(), message.getPartitionName()), taskId);
                    MessageTimeoutTask timerTask = null;
                    if (message.getExecutionTimeout() > 0) {
                        timerTask = new MessageTimeoutTask(this, task);
                        this._timer.schedule((TimerTask)timerTask, message.getExecutionTimeout());
                        LOG.info("Message starts with timeout " + message.getExecutionTimeout() + " MsgId: " + task.getTaskId());
                    } else {
                        LOG.debug("Message does not have timeout. MsgId: " + task.getTaskId());
                    }
                    this._taskMap.put(taskId, new MessageTaskInfo(task, future, timerTask));
                    LOG.info("Message: " + taskId + " handling task scheduled");
                    return true;
                }
                this._statusUpdateUtil.logWarning(message, HelixTaskExecutor.class, "Message handling task already sheduled for " + taskId, manager);
            }
        }
        catch (Exception e) {
            LOG.error("Error while executing task. " + message, (Throwable)e);
            this._statusUpdateUtil.logError(message, HelixTaskExecutor.class, e, "Error while executing task " + e, manager);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancelTask(MessageTask task) {
        Message message = task.getMessage();
        NotificationContext notificationContext = task.getNotificationContext();
        String taskId = task.getTaskId();
        Object object = this._lock;
        synchronized (object) {
            if (this._taskMap.containsKey(taskId)) {
                MessageTaskInfo taskInfo = this._taskMap.get(taskId);
                if (taskInfo._timerTask != null) {
                    taskInfo._timerTask.cancel();
                }
                Future<HelixTaskResult> future = taskInfo.getFuture();
                this.removeMessageFromTaskAndFutureMap(message);
                this._statusUpdateUtil.logInfo(message, HelixTaskExecutor.class, "Canceling task: " + taskId, notificationContext.getManager());
                if (future.cancel(true)) {
                    this._statusUpdateUtil.logInfo(message, HelixTaskExecutor.class, "Canceled task: " + taskId, notificationContext.getManager());
                    this._taskMap.remove(taskId);
                    return true;
                }
                this._statusUpdateUtil.logInfo(message, HelixTaskExecutor.class, "fail to cancel task: " + taskId, notificationContext.getManager());
            } else {
                this._statusUpdateUtil.logWarning(message, HelixTaskExecutor.class, "fail to cancel task: " + taskId + ", future not found", notificationContext.getManager());
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishTask(MessageTask task) {
        Message message = task.getMessage();
        String taskId = task.getTaskId();
        LOG.info("message finished: " + taskId + ", took " + (new Date().getTime() - message.getExecuteStartTimeStamp()));
        Object object = this._lock;
        synchronized (object) {
            if (this._taskMap.containsKey(taskId)) {
                MessageTaskInfo info = this._taskMap.remove(taskId);
                this.removeMessageFromTaskAndFutureMap(message);
                if (info._timerTask != null) {
                    info._timerTask.cancel();
                }
            } else {
                LOG.warn("message " + taskId + " not found in task map");
            }
        }
    }

    private void updateMessageState(Collection<Message> msgsToBeUpdated, HelixDataAccessor accessor, String instanceName) {
        if (msgsToBeUpdated.isEmpty()) {
            return;
        }
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        ArrayList<Message> updateMsgs = new ArrayList<Message>();
        ArrayList<String> updateMsgPaths = new ArrayList<String>();
        ArrayList<DataUpdater<ZNRecord>> updaters = new ArrayList<DataUpdater<ZNRecord>>();
        for (Message msg : msgsToBeUpdated) {
            updateMsgs.add(msg);
            updateMsgPaths.add(msg.getKey(keyBuilder, instanceName).getPath());
            updaters.add(currentData -> {
                if (currentData == null) {
                    LOG.warn("Message {} targets at {} has already been removed before it is set as READ on instance {}", new Object[]{msg.getId(), msg.getTgtName(), instanceName});
                    return null;
                }
                return msg.getRecord();
            });
        }
        boolean[] updateResults = accessor.updateChildren(updateMsgPaths, updaters, AccessOption.PERSISTENT);
        boolean isMessageUpdatedAsNew = false;
        for (int i = 0; i < updateMsgs.size(); ++i) {
            Message msg = (Message)updateMsgs.get(i);
            if (msg.getMsgState().equals((Object)Message.MessageState.NEW)) {
                isMessageUpdatedAsNew = true;
                continue;
            }
            this._knownMessageIds.add(msg.getId());
            if (updateResults[i]) continue;
            LOG.error("Failed to update the message {}.", (Object)msg.getMsgId());
        }
        if (isMessageUpdatedAsNew) {
            this.sendNopMessage(accessor, instanceName);
        }
    }

    private void shutdownAndAwaitTermination(ExecutorService pool, MsgHandlerFactoryRegistryItem handlerItem) {
        LOG.info("Shutting down pool: " + pool);
        int timeout = handlerItem == null ? 200 : handlerItem.getResetTimeout();
        pool.shutdown();
        try {
            if (!pool.awaitTermination(timeout, TimeUnit.MILLISECONDS)) {
                List<Runnable> waitingTasks = pool.shutdownNow();
                LOG.info("Tasks that never commenced execution after {}: {}", (Object)timeout, waitingTasks);
                if (!pool.awaitTermination(timeout, TimeUnit.MILLISECONDS)) {
                    LOG.error("Pool did not fully terminate in {} ms. pool: {}", (Object)timeout, (Object)pool);
                }
            }
        }
        catch (InterruptedException ie) {
            LOG.error("Interrupted when waiting for shutdown pool: " + pool, (Throwable)ie);
            pool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    void unregisterMessageHandlerFactory(String type) {
        MsgHandlerFactoryRegistryItem item = this._hdlrFtyRegistry.remove(type);
        ExecutorService pool = this._executorMap.remove(type);
        this._monitor.removeExecutorMonitor(type);
        LOG.info("Unregistering message handler factory for type: " + type + ", factory: " + item.factory() + ", pool: " + pool);
        if (pool != null) {
            this.shutdownAndAwaitTermination(pool, item);
        }
        if (item != null) {
            item.factory().reset();
        }
        LOG.info("Unregistered message handler factory for type: " + type + ", factory: " + item.factory() + ", pool: " + pool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncFactoryState() {
        LOG.info("Start to sync factory state");
        ConcurrentHashMap<String, MsgHandlerFactoryRegistryItem> concurrentHashMap = this._hdlrFtyRegistry;
        synchronized (concurrentHashMap) {
            for (Map.Entry<String, MsgHandlerFactoryRegistryItem> entry : this._hdlrFtyRegistry.entrySet()) {
                MsgHandlerFactoryRegistryItem item = entry.getValue();
                if (item.factory() == null) continue;
                try {
                    item.factory().sync();
                }
                catch (Exception ex) {
                    LOG.error("Failed to syncState the factory {} of message type {}.", new Object[]{item.factory(), entry.getKey(), ex});
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownExecutors() {
        ConcurrentHashMap<String, MsgHandlerFactoryRegistryItem> concurrentHashMap = this._hdlrFtyRegistry;
        synchronized (concurrentHashMap) {
            for (String msgType : this._hdlrFtyRegistry.keySet()) {
                MsgHandlerFactoryRegistryItem item = this._hdlrFtyRegistry.get(msgType);
                ExecutorService pool = this._executorMap.remove(msgType);
                this._monitor.removeExecutorMonitor(msgType);
                if (pool == null) continue;
                LOG.info("Reset executor for msgType: " + msgType + ", pool: " + pool);
                this.shutdownAndAwaitTermination(pool, item);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void reset() {
        if (this._isCleanState) {
            LOG.info("HelixTaskExecutor is in clean state, no need to reset again");
            return;
        }
        LOG.info("Reset HelixTaskExecutor");
        if (this._messageQueueMonitor != null) {
            this._messageQueueMonitor.reset();
        }
        this.shutdownExecutors();
        ConcurrentHashMap<String, MsgHandlerFactoryRegistryItem> concurrentHashMap = this._hdlrFtyRegistry;
        synchronized (concurrentHashMap) {
            this._hdlrFtyRegistry.values().stream().map(MsgHandlerFactoryRegistryItem::factory).distinct().filter(Objects::nonNull).forEach(factory -> {
                try {
                    factory.reset();
                }
                catch (Exception ex) {
                    LOG.error("Failed to reset the factory {}.", (Object)factory.toString(), (Object)ex);
                }
            });
        }
        StringBuilder sb = new StringBuilder();
        for (String taskId : this._taskMap.keySet()) {
            MessageTaskInfo info = this._taskMap.get(taskId);
            sb.append("Task: " + taskId + " fails to terminate. Message: " + info._task.getMessage() + "\n");
        }
        LOG.info(sb.toString());
        this._taskMap.clear();
        this._messageTaskMap.clear();
        this._knownMessageIds.clear();
        this._lastSessionSyncTime = null;
        this._isCleanState = true;
    }

    void init() {
        LOG.info("Init HelixTaskExecutor");
        if (this._messageQueueMonitor != null) {
            this._messageQueueMonitor.init();
        }
        this._isShuttingDown = false;
        for (String msgType : this._hdlrFtyRegistry.keySet()) {
            MsgHandlerFactoryRegistryItem item = this._hdlrFtyRegistry.get(msgType);
            ExecutorService pool = this._executorMap.computeIfAbsent(msgType, type -> {
                ExecutorService newPool = Executors.newFixedThreadPool(item.threadPoolSize(), r -> new Thread(r, "HelixTaskExecutor-message_handle_" + type));
                this._monitor.createExecutorMonitor((String)type, newPool);
                return newPool;
            });
            LOG.info("Setup the thread pool for type: {}, isShutdown: {}", (Object)msgType, (Object)pool.isShutdown());
        }
    }

    private void syncSessionToController(HelixManager manager) {
        PropertyKey key;
        HelixDataAccessor accessor;
        if ((this._lastSessionSyncTime == null || System.currentTimeMillis() - this._lastSessionSyncTime > 2000L) && (accessor = manager.getHelixDataAccessor()).getProperty(key = new PropertyKey.Builder(manager.getClusterName()).controllerMessage(SESSION_SYNC)) == null) {
            LOG.info(String.format("Participant %s syncs session with controller", manager.getInstanceName()));
            Message msg = new Message(Message.MessageType.PARTICIPANT_SESSION_CHANGE, SESSION_SYNC);
            msg.setSrcName(manager.getInstanceName());
            msg.setTgtSessionId("*");
            msg.setMsgState(Message.MessageState.NEW);
            msg.setMsgId(SESSION_SYNC);
            Criteria cr = new Criteria();
            cr.setRecipientInstanceType(InstanceType.CONTROLLER);
            cr.setSessionSpecific(false);
            manager.getMessagingService().send(cr, msg);
            this._lastSessionSyncTime = System.currentTimeMillis();
        }
    }

    private List<Message> readNewMessagesFromZK(HelixManager manager, String instanceName, HelixConstants.ChangeType changeType) {
        HelixDataAccessor accessor = manager.getHelixDataAccessor();
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        HashSet<String> messageIds = new HashSet<String>();
        if (changeType.equals((Object)HelixConstants.ChangeType.MESSAGE)) {
            messageIds.addAll(accessor.getChildNames(keyBuilder.messages(instanceName)));
        } else if (changeType.equals((Object)HelixConstants.ChangeType.MESSAGES_CONTROLLER)) {
            messageIds.addAll(accessor.getChildNames(keyBuilder.controllerMessages()));
        } else {
            LOG.warn("Unexpected ChangeType for Message Change CallbackHandler: " + changeType);
            return Collections.emptyList();
        }
        messageIds.removeAll(this._knownMessageIds);
        ArrayList<PropertyKey> keys = new ArrayList<PropertyKey>();
        for (String messageId : messageIds) {
            if (changeType.equals((Object)HelixConstants.ChangeType.MESSAGE)) {
                keys.add(keyBuilder.message(instanceName, messageId));
                continue;
            }
            if (!changeType.equals((Object)HelixConstants.ChangeType.MESSAGES_CONTROLLER)) continue;
            keys.add(keyBuilder.controllerMessage(messageId));
        }
        List<Message> newMessages = accessor.getProperty(keys, false);
        Iterator messageIterator = newMessages.iterator();
        while (messageIterator.hasNext()) {
            if (messageIterator.next() != null) continue;
            messageIterator.remove();
        }
        return newMessages;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @PreFetch(enabled=false)
    public void onMessage(String instanceName, List<Message> messages, NotificationContext changeContext) {
        HelixManager manager = changeContext.getManager();
        if (changeContext.getType() == NotificationContext.Type.FINALIZE) {
            this.reset();
            return;
        }
        if (changeContext.getType() == NotificationContext.Type.INIT) {
            this.init();
        }
        this._isCleanState = false;
        if (messages == null || messages.isEmpty()) {
            messages = this.readNewMessagesFromZK(manager, instanceName, changeContext.getChangeType());
        }
        if (this._isShuttingDown) {
            StringBuilder sb = new StringBuilder();
            Iterator<Message> iterator = messages.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    LOG.info("Helix task executor is shutting down, ignore unprocessed messages : " + sb.toString());
                    return;
                }
                Message message = iterator.next();
                sb.append(message.getMsgId() + ",");
            }
        }
        if (this._messageQueueMonitor != null) {
            this._messageQueueMonitor.setMessageQueueBacklog(messages.size());
        }
        if (messages.isEmpty()) {
            LOG.info("No Messages to process");
            return;
        }
        Collections.sort(messages, Message.CREATE_TIME_COMPARATOR);
        HelixDataAccessor accessor = manager.getHelixDataAccessor();
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        HashMap<String, MessageHandler> stateTransitionHandlers = new HashMap<String, MessageHandler>();
        HashMap<String, NotificationContext> stateTransitionContexts = new HashMap<String, NotificationContext>();
        ArrayList<MessageHandler> nonStateTransitionHandlers = new ArrayList<MessageHandler>();
        ArrayList<NotificationContext> nonStateTransitionContexts = new ArrayList<NotificationContext>();
        HashMap<String, Message> msgsToBeUpdated = new HashMap<String, Message>();
        String sessionId = manager.getSessionId();
        List<String> curResourceNames = accessor.getChildNames(keyBuilder.currentStates(instanceName, sessionId));
        List<String> taskCurResourceNames = accessor.getChildNames(keyBuilder.taskCurrentStates(instanceName, sessionId));
        ArrayList<PropertyKey> createCurStateKeys = new ArrayList<PropertyKey>();
        ArrayList<CurrentState> metaCurStates = new ArrayList<CurrentState>();
        HashSet<String> createCurStateNames = new HashSet<String>();
        for (Message message : messages) {
            String resourceName;
            NotificationContext msgWorkingContext;
            block27: {
                if (this.checkAndProcessNoOpMessage(message, instanceName, changeContext, manager, sessionId, stateTransitionHandlers)) continue;
                msgWorkingContext = changeContext.clone();
                MessageHandler msgHandler = null;
                try {
                    msgHandler = this.createMessageHandler(message, msgWorkingContext);
                }
                catch (Exception ex) {
                    int remainingRetryCount = message.getRetryCount();
                    LOG.error("Exception happens when creating Message Handler for message {}. Current remaining retry count is {}.", (Object)message.getMsgId(), (Object)remainingRetryCount);
                    message.setRetryCount(remainingRetryCount - 1);
                    message.setExecuteSessionId(sessionId);
                    if (message.getRetryCount() <= 0) {
                        String errorMsg = String.format("No available message Handler found! Stop processing message %s since it has zero or negative remaining retry count %d!", message.getMsgId(), message.getRetryCount());
                        this.updateUnprocessableMessage(message, null, errorMsg, manager);
                    }
                    msgsToBeUpdated.put(message.getId(), message);
                }
                if (msgHandler == null) {
                    LOG.warn("There is no existing handler for message {}. Skip processing it for now. Will retry on the next callback.", (Object)message.getMsgId());
                    continue;
                }
                if (message.getMsgType().equals(Message.MessageType.STATE_TRANSITION.name()) || message.getMsgType().equals(Message.MessageType.STATE_TRANSITION_CANCELLATION.name())) {
                    if (this.validateAndProcessStateTransitionMessage(message, manager, stateTransitionHandlers, msgHandler)) {
                        String msgTarget = this.getMessageTarget(message.getResourceName(), message.getPartitionName());
                        stateTransitionHandlers.put(msgTarget, msgHandler);
                        stateTransitionContexts.put(msgTarget, msgWorkingContext);
                        break block27;
                    } else {
                        this.removeMessageFromZK(accessor, message, instanceName);
                        continue;
                    }
                }
                nonStateTransitionHandlers.add(msgHandler);
                nonStateTransitionContexts.add(msgWorkingContext);
            }
            Message markedMsg = this.markReadMessage(message, msgWorkingContext, manager);
            msgsToBeUpdated.put(markedMsg.getId(), markedMsg);
            if (message.isControlerMsg() || !message.getMsgType().equals(Message.MessageType.STATE_TRANSITION.name()) || curResourceNames.contains(resourceName = message.getResourceName()) || taskCurResourceNames.contains(resourceName) || createCurStateNames.contains(resourceName)) continue;
            createCurStateNames.add(resourceName);
            PropertyKey curStateKey = keyBuilder.currentState(instanceName, sessionId, resourceName);
            if ("Task".equals(message.getStateModelDef()) && !Boolean.getBoolean("helix.taskCurrentStatePathDisabled")) {
                curStateKey = keyBuilder.taskCurrentState(instanceName, sessionId, resourceName);
            }
            createCurStateKeys.add(curStateKey);
            CurrentState metaCurState = new CurrentState(resourceName);
            metaCurState.setBucketSize(message.getBucketSize());
            metaCurState.setStateModelDefRef(message.getStateModelDef());
            metaCurState.setSessionId(sessionId);
            metaCurState.setBatchMessageMode(message.getBatchMessageMode());
            String ftyName = message.getStateModelFactoryName();
            if (ftyName != null) {
                metaCurState.setStateModelFactoryName(ftyName);
            } else {
                metaCurState.setStateModelFactoryName("DEFAULT");
            }
            metaCurStates.add(metaCurState);
        }
        if (createCurStateKeys.size() > 0) {
            try {
                accessor.createChildren(createCurStateKeys, metaCurStates);
            }
            catch (Exception e) {
                LOG.error("fail to create cur-state znodes for messages: " + msgsToBeUpdated, (Throwable)e);
            }
        }
        this.updateMessageState(msgsToBeUpdated.values(), accessor, instanceName);
        for (Map.Entry handlerEntry : stateTransitionHandlers.entrySet()) {
            NotificationContext context;
            MessageHandler handler = (MessageHandler)handlerEntry.getValue();
            if (this.scheduleTaskForMessage(instanceName, accessor, handler, context = (NotificationContext)stateTransitionContexts.get(handlerEntry.getKey())) || this._isShuttingDown) continue;
            try {
                handler.onError(new HelixException(String.format("Failed to schedule the task for executing message handler for %s.", handler._message.getMsgId())), MessageHandler.ErrorCode.ERROR, MessageHandler.ErrorType.FRAMEWORK);
            }
            catch (Exception ex) {
                LOG.error("Failed to trigger onError method of the message handler for {}", (Object)handler._message.getMsgId(), (Object)ex);
            }
        }
        int i = 0;
        while (i < nonStateTransitionHandlers.size()) {
            MessageHandler handler = (MessageHandler)nonStateTransitionHandlers.get(i);
            NotificationContext context = (NotificationContext)nonStateTransitionContexts.get(i);
            this.scheduleTaskForMessage(instanceName, accessor, handler, context);
            ++i;
        }
        return;
    }

    private boolean checkAndProcessNoOpMessage(Message message, String instanceName, NotificationContext changeContext, HelixManager manager, String sessionId, Map<String, MessageHandler> stateTransitionHandlers) {
        HelixDataAccessor accessor = manager.getHelixDataAccessor();
        try {
            boolean success;
            if (message.getMsgType().equalsIgnoreCase(Message.MessageType.NO_OP.toString())) {
                LOG.info("Dropping NO-OP message. mid: " + message.getId() + ", from: " + message.getMsgSrc());
                this.reportAndRemoveMessage(message, accessor, instanceName, ParticipantMessageMonitor.ProcessedMessageState.DISCARDED);
                return true;
            }
            String tgtSessionId = message.getTgtSessionId();
            if (!sessionId.equals(tgtSessionId) && !tgtSessionId.equals("*")) {
                String warningMessage = "SessionId does NOT match. expected sessionId: " + sessionId + ", tgtSessionId in message: " + tgtSessionId + ", messageId: " + message.getMsgId();
                LOG.warn(warningMessage);
                this.reportAndRemoveMessage(message, accessor, instanceName, ParticipantMessageMonitor.ProcessedMessageState.DISCARDED);
                this._statusUpdateUtil.logWarning(message, HelixStateMachineEngine.class, warningMessage, manager);
                if ((manager.getInstanceType() == InstanceType.PARTICIPANT || manager.getInstanceType() == InstanceType.CONTROLLER_PARTICIPANT) && message.getCreateTimeStamp() > manager.getSessionStartTime()) {
                    this.syncSessionToController(manager);
                }
                return true;
            }
            if ((manager.getInstanceType() == InstanceType.CONTROLLER || manager.getInstanceType() == InstanceType.CONTROLLER_PARTICIPANT) && Message.MessageType.PARTICIPANT_SESSION_CHANGE.name().equals(message.getMsgType())) {
                LOG.info(String.format("Controller received PARTICIPANT_SESSION_CHANGE msg from src: %s", message.getMsgSrc()));
                PropertyKey key = new PropertyKey.Builder(manager.getClusterName()).liveInstances();
                List<LiveInstance> liveInstances = manager.getHelixDataAccessor().getChildValues(key, true);
                this._controller.onLiveInstanceChange(liveInstances, changeContext);
                this.reportAndRemoveMessage(message, accessor, instanceName, ParticipantMessageMonitor.ProcessedMessageState.COMPLETED);
                return true;
            }
            if (Message.MessageState.NEW != message.getMsgState()) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Message already read. msgId: " + message.getMsgId());
                }
                return true;
            }
            if (message.isExpired()) {
                LOG.info("Dropping expired message. mid: " + message.getId() + ", from: " + message.getMsgSrc() + " relayed from: " + message.getRelaySrcHost());
                this.reportAndRemoveMessage(message, accessor, instanceName, ParticipantMessageMonitor.ProcessedMessageState.DISCARDED);
                return true;
            }
            if (message.getMsgType().equals(Message.MessageType.STATE_TRANSITION_CANCELLATION.name()) && (success = this.cancelNotStartedStateTransition(message, stateTransitionHandlers, accessor, instanceName))) {
                return true;
            }
            if (Message.MessageType.PARTICIPANT_STATUS_CHANGE.name().equals(message.getMsgType())) {
                LiveInstance.LiveInstanceStatus toStatus = LiveInstance.LiveInstanceStatus.valueOf(message.getToState());
                this.changeParticipantStatus(instanceName, toStatus, manager);
                this.reportAndRemoveMessage(message, accessor, instanceName, ParticipantMessageMonitor.ProcessedMessageState.COMPLETED);
                return true;
            }
            this._monitor.reportReceivedMessage(message);
        }
        catch (Exception e) {
            LOG.error("Failed to process the message {}. Deleting the message from ZK. Exception: {}", (Object)message, (Object)e);
            this.removeMessageFromTaskAndFutureMap(message);
            this.removeMessageFromZK(accessor, message, instanceName);
            return true;
        }
        return false;
    }

    private boolean validateAndProcessStateTransitionMessage(Message message, HelixManager manager, Map<String, MessageHandler> stateTransitionHandlers, MessageHandler createHandler) {
        String messageTarget = this.getMessageTarget(message.getResourceName(), message.getPartitionName());
        try {
            if (message.getMsgType().equals(Message.MessageType.STATE_TRANSITION.name()) && this.isStateTransitionInProgress(messageTarget)) {
                String taskId = this._messageTaskMap.get(messageTarget);
                Message msg = this._taskMap.get(taskId).getTask().getMessage();
                String errMsg = String.format("Another state transition for %s:%s is in progress with msg: %s, p2p: %s, read: %d, current:%d. Discarding %s->%s message", message.getResourceName(), message.getPartitionName(), msg.getMsgId(), msg.isRelayMessage(), msg.getReadTimeStamp(), System.currentTimeMillis(), message.getFromState(), message.getToState());
                this.updateUnprocessableMessage(message, null, errMsg, manager);
                return false;
            }
            if (createHandler instanceof HelixStateTransitionHandler) {
                HelixStateTransitionHandler.StaleMessageValidateResult result = ((HelixStateTransitionHandler)createHandler).staleMessageValidator();
                if (!result.isValid) {
                    this.updateUnprocessableMessage(message, null, result.exception.getMessage(), manager);
                    return false;
                }
            }
            if (stateTransitionHandlers.containsKey(messageTarget)) {
                Message duplicatedMessage = stateTransitionHandlers.get((Object)messageTarget)._message;
                String errMsg = String.format("Duplicated state transition message: %s. Existing: %s->%s; New (Discarded): %s->%s", message.getMsgId(), duplicatedMessage.getFromState(), duplicatedMessage.getToState(), message.getFromState(), message.getToState());
                this.updateUnprocessableMessage(message, null, errMsg, manager);
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            this.updateUnprocessableMessage(message, ex, "State transition validation failed with Exception.", manager);
            return false;
        }
    }

    private boolean scheduleTaskForMessage(String instanceName, HelixDataAccessor accessor, MessageHandler handler, NotificationContext context) {
        Message msg = handler._message;
        if (!this.scheduleTask(new HelixTask(msg, context, handler, this))) {
            this.removeMessageFromTaskAndFutureMap(msg);
            this.removeMessageFromZK(accessor, msg, instanceName);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isStateTransitionInProgress(String messageTarget) {
        Object object = this._lock;
        synchronized (object) {
            if (this._messageTaskMap.containsKey(messageTarget)) {
                String taskId = this._messageTaskMap.get(messageTarget);
                boolean bl = !this._taskMap.get(taskId).getFuture().isDone();
                return bl;
            }
            return false;
        }
    }

    private boolean cancelNotStartedStateTransition(Message message, Map<String, MessageHandler> stateTransitionHandlers, HelixDataAccessor accessor, String instanceName) {
        ParticipantMessageMonitor.ProcessedMessageState messageState;
        Message targetStateTransitionMessage;
        String targetMessageName = this.getMessageTarget(message.getResourceName(), message.getPartitionName());
        if (stateTransitionHandlers.containsKey(targetMessageName)) {
            targetStateTransitionMessage = stateTransitionHandlers.get(targetMessageName).getMessage();
            if (this.isCancelingSameStateTransition(targetStateTransitionMessage, message)) {
                stateTransitionHandlers.remove(targetMessageName);
                messageState = ParticipantMessageMonitor.ProcessedMessageState.COMPLETED;
            } else {
                messageState = ParticipantMessageMonitor.ProcessedMessageState.DISCARDED;
            }
        } else if (this._messageTaskMap.containsKey(targetMessageName)) {
            String taskId = this._messageTaskMap.get(targetMessageName);
            HelixTask task = (HelixTask)this._taskMap.get(taskId).getTask();
            Future<HelixTaskResult> future = this._taskMap.get(taskId).getFuture();
            targetStateTransitionMessage = task.getMessage();
            if (this.isCancelingSameStateTransition(task.getMessage(), message)) {
                boolean success = task.cancel();
                if (!success) {
                    return false;
                }
                future.cancel(false);
                this._messageTaskMap.remove(targetMessageName);
                this._taskMap.remove(taskId);
                messageState = ParticipantMessageMonitor.ProcessedMessageState.COMPLETED;
            } else {
                messageState = ParticipantMessageMonitor.ProcessedMessageState.DISCARDED;
            }
        } else {
            return false;
        }
        this.removeMessageFromZK(accessor, targetStateTransitionMessage, instanceName);
        this._monitor.reportProcessedMessage(targetStateTransitionMessage, ParticipantMessageMonitor.ProcessedMessageState.DISCARDED);
        this.reportAndRemoveMessage(message, accessor, instanceName, messageState);
        return true;
    }

    private void reportAndRemoveMessage(Message message, HelixDataAccessor accessor, String instanceName, ParticipantMessageMonitor.ProcessedMessageState messageProcessState) {
        this._monitor.reportReceivedMessage(message);
        this._monitor.reportProcessedMessage(message, messageProcessState);
        this.removeMessageFromZK(accessor, message, instanceName);
    }

    private Message markReadMessage(Message message, NotificationContext context, HelixManager manager) {
        message.setMsgState(Message.MessageState.READ);
        message.setReadTimeStamp(new Date().getTime());
        message.setExecuteSessionId(context.getManager().getSessionId());
        this._statusUpdateUtil.logInfo(message, HelixStateMachineEngine.class, "New Message", manager);
        return message;
    }

    private void updateUnprocessableMessage(Message message, Exception exception, String errorMsg, HelixManager manager) {
        String error = "Message " + message.getMsgId() + " cannot be processed: " + message.getRecord();
        if (exception != null) {
            LOG.error(error, (Throwable)exception);
            this._statusUpdateUtil.logError(message, HelixStateMachineEngine.class, exception, error, manager);
        } else {
            LOG.error(error + errorMsg);
            this._statusUpdateUtil.logError(message, HelixStateMachineEngine.class, errorMsg, manager);
        }
        message.setMsgState(Message.MessageState.UNPROCESSABLE);
        this._monitor.reportProcessedMessage(message, ParticipantMessageMonitor.ProcessedMessageState.FAILED);
    }

    public MessageHandler createMessageHandler(Message message, NotificationContext changeContext) {
        String msgType = message.getMsgType();
        MsgHandlerFactoryRegistryItem item = this._hdlrFtyRegistry.get(msgType);
        if (item == null) {
            LOG.warn("Fail to find message handler factory for type: " + msgType + " msgId: " + message.getMsgId());
            return null;
        }
        MessageHandlerFactory handlerFactory = item.factory();
        changeContext.add(NotificationContext.MapKey.TASK_EXECUTOR.toString(), this);
        return handlerFactory.createHandler(message, changeContext);
    }

    private void removeMessageFromTaskAndFutureMap(Message message) {
        this._knownMessageIds.remove(message.getId());
        String messageTarget = this.getMessageTarget(message.getResourceName(), message.getPartitionName());
        if (this._messageTaskMap.containsKey(messageTarget)) {
            this._messageTaskMap.remove(messageTarget);
        }
    }

    private boolean isCancelingSameStateTransition(Message stateTranstionMessage, Message cancellationMessage) {
        return stateTranstionMessage.getFromState().equalsIgnoreCase(cancellationMessage.getFromState()) && stateTranstionMessage.getToState().equalsIgnoreCase(cancellationMessage.getToState());
    }

    String getMessageTarget(String resourceName, String partitionName) {
        return String.format("%s_%s", resourceName, partitionName);
    }

    private void changeParticipantStatus(String instanceName, LiveInstance.LiveInstanceStatus toStatus, HelixManager manager) {
        if (toStatus == null) {
            LOG.warn("To status is null! Skip participant status change.");
            return;
        }
        LOG.info("Changing participant {} status to {} from {}", new Object[]{instanceName, toStatus, this._liveInstanceStatus});
        HelixDataAccessor accessor = manager.getHelixDataAccessor();
        String sessionId = manager.getSessionId();
        String path = accessor.keyBuilder().liveInstance(instanceName).getPath();
        boolean success = false;
        switch (toStatus) {
            case FROZEN: {
                this._freezeSessionId = sessionId;
                this._liveInstanceStatus = toStatus;
                success = accessor.getBaseDataAccessor().update(path, record -> {
                    record.setEnumField(LiveInstance.LiveInstanceProperty.STATUS.name(), toStatus);
                    return record;
                }, AccessOption.EPHEMERAL);
                break;
            }
            case NORMAL: {
                if (this._freezeSessionId != null && !this._freezeSessionId.equals(sessionId)) {
                    this.syncFactoryState();
                    ParticipantManager.carryOverPreviousCurrentState(accessor, instanceName, sessionId, manager.getStateMachineEngine(), false);
                }
                this._freezeSessionId = null;
                this._liveInstanceStatus = toStatus;
                success = accessor.getBaseDataAccessor().update(path, record -> {
                    record.getSimpleFields().remove(LiveInstance.LiveInstanceProperty.STATUS.name());
                    return record;
                }, AccessOption.EPHEMERAL);
                break;
            }
            default: {
                LOG.warn("To status {} is not supported", (Object)toStatus);
            }
        }
        LOG.info("Changed participant {} status to {}. FreezeSessionId={}, update success={}", new Object[]{instanceName, this._liveInstanceStatus, this._freezeSessionId, success});
    }

    public LiveInstance.LiveInstanceStatus getLiveInstanceStatus() {
        return this._liveInstanceStatus;
    }

    private void removeMessageFromZK(HelixDataAccessor accessor, Message message, String instanceName) {
        if (HelixUtil.removeMessageFromZK(accessor, message, instanceName)) {
            LOG.info("Successfully removed message {} from ZK.", (Object)message.getMsgId());
        } else {
            LOG.warn("Failed to remove message {} from ZK.", (Object)message.getMsgId());
        }
    }

    private void sendNopMessage(HelixDataAccessor accessor, String instanceName) {
        try {
            Message nopMsg = new Message(Message.MessageType.NO_OP, UUID.randomUUID().toString());
            nopMsg.setSrcName(instanceName);
            nopMsg.setTgtName(instanceName);
            accessor.setProperty(accessor.keyBuilder().message(nopMsg.getTgtName(), nopMsg.getId()), nopMsg);
            LOG.info("Send NO_OP message to {}, msgId: {}.", (Object)nopMsg.getTgtName(), (Object)nopMsg.getId());
        }
        catch (Exception e) {
            LOG.error("Failed to send NO_OP message to {}.", (Object)instanceName, (Object)e);
        }
    }

    @Override
    public void shutdown() {
        LOG.info("Shutting down HelixTaskExecutor");
        this._isShuttingDown = true;
        this._timer.cancel();
        this.shutdownExecutors();
        this.reset();
        this._monitor.shutDown();
        LOG.info("Shutdown HelixTaskExecutor finished");
    }

    class MsgHandlerFactoryRegistryItem {
        private final MessageHandlerFactory _factory;
        private final int _threadPoolSize;
        private final int _resetTimeout;

        public MsgHandlerFactoryRegistryItem(MessageHandlerFactory factory, int threadPoolSize, int resetTimeout) {
            if (factory == null) {
                throw new NullPointerException("Message handler factory is null");
            }
            if (threadPoolSize <= 0) {
                throw new IllegalArgumentException("Illegal thread pool size: " + threadPoolSize);
            }
            if (resetTimeout < 0) {
                throw new IllegalArgumentException("Illegal reset timeout: " + resetTimeout);
            }
            this._factory = factory;
            this._threadPoolSize = threadPoolSize;
            this._resetTimeout = resetTimeout;
        }

        int threadPoolSize() {
            return this._threadPoolSize;
        }

        int getResetTimeout() {
            return this._resetTimeout;
        }

        MessageHandlerFactory factory() {
            return this._factory;
        }
    }
}

