/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.view.aggregator;

import java.util.logging.Level;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.helix.view.aggregator.HelixViewAggregator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelixViewAggregatorMain {
    private static Logger logger = LoggerFactory.getLogger(HelixViewAggregatorMain.class);
    private static final String HELP = "help";
    private static final String ZK_ADDR = "zookeeper-address";
    private static final String VIEW_CLUSTER_NAME = "view-cluster-name";

    private static void printUsage(Options cliOptions) {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.printHelp("java " + HelixViewAggregatorMain.class.getName(), cliOptions);
    }

    private static Options constructCommandLineOptions() {
        OptionBuilder.withLongOpt((String)HELP);
        OptionBuilder.withDescription((String)"Prints command-line options info");
        Option helpOption = OptionBuilder.create();
        helpOption.setArgs(0);
        helpOption.setRequired(false);
        helpOption.setArgName("print help message");
        OptionBuilder.withLongOpt((String)ZK_ADDR);
        OptionBuilder.withDescription((String)"Provide zookeeper address");
        Option zkServerOption = OptionBuilder.create();
        zkServerOption.setArgs(1);
        zkServerOption.setRequired(true);
        zkServerOption.setArgName("ZooKeeper server connection string (Required)");
        OptionBuilder.withLongOpt((String)VIEW_CLUSTER_NAME);
        OptionBuilder.withDescription((String)"Name of the view cluster");
        Option portOption = OptionBuilder.create();
        portOption.setArgs(1);
        portOption.setRequired(true);
        portOption.setArgName("Name of the view cluster");
        Options options = new Options();
        options.addOption(helpOption);
        options.addOption(zkServerOption);
        options.addOption(portOption);
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        java.util.logging.Logger topJavaLogger = java.util.logging.Logger.getLogger("");
        topJavaLogger.setLevel(Level.INFO);
        GnuParser cliParser = new GnuParser();
        Options cliOptions = HelixViewAggregatorMain.constructCommandLineOptions();
        CommandLine cmd = null;
        try {
            cmd = cliParser.parse(cliOptions, args);
        }
        catch (ParseException pe) {
            logger.error("HelixViewAggregatorMain: failed to parse command-line options.", (Throwable)pe);
            HelixViewAggregatorMain.printUsage(cliOptions);
            System.exit(1);
        }
        if (cmd.hasOption(HELP)) {
            HelixViewAggregatorMain.printUsage(cliOptions);
            return;
        }
        String zkAddr = String.valueOf(cmd.getOptionValue(ZK_ADDR));
        String viewClusterName = String.valueOf(cmd.getOptionValue(VIEW_CLUSTER_NAME));
        final HelixViewAggregator aggregator = new HelixViewAggregator(viewClusterName, zkAddr);
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                aggregator.shutdown();
            }
        }));
        try {
            aggregator.start();
            Thread.currentThread().join();
        }
        catch (Exception e) {
            logger.error("HelixViewAggregator caught exception.", (Throwable)e);
        }
        finally {
            aggregator.shutdown();
        }
        System.exit(1);
    }
}

