/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.cloud.azure;

import java.util.HashMap;
import java.util.Map;
import org.apache.helix.api.cloud.CloudInstanceInformation;

public class AzureCloudInstanceInformation
implements CloudInstanceInformation {
    private Map<String, String> _cloudInstanceInfoMap;

    protected AzureCloudInstanceInformation(Map<String, String> cloudInstanceInfoMap) {
        this._cloudInstanceInfoMap = cloudInstanceInfoMap;
    }

    @Override
    public String get(String key) {
        return this._cloudInstanceInfoMap.get(key);
    }

    public static class Builder {
        private final Map<String, String> _cloudInstanceInfoMap = new HashMap<String, String>();

        public AzureCloudInstanceInformation build() {
            return new AzureCloudInstanceInformation(new HashMap<String, String>(this._cloudInstanceInfoMap));
        }

        public Builder setInstanceName(String name) {
            this._cloudInstanceInfoMap.put(CloudInstanceInformation.CloudInstanceField.INSTANCE_NAME.name(), name);
            return this;
        }

        public Builder setFaultDomain(String faultDomain) {
            this._cloudInstanceInfoMap.put(CloudInstanceInformation.CloudInstanceField.FAULT_DOMAIN.name(), faultDomain);
            return this;
        }

        public Builder setInstanceSetName(String instanceSetName) {
            this._cloudInstanceInfoMap.put(CloudInstanceInformation.CloudInstanceField.INSTANCE_SET_NAME.name(), instanceSetName);
            return this;
        }

        public Builder setCloudInstanceInfoField(String key, String value) {
            this._cloudInstanceInfoMap.put(key, value);
            return this;
        }
    }
}

