/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.rebalancer.strategy;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.helix.HelixException;
import org.apache.helix.controller.LogUtil;
import org.apache.helix.controller.dataproviders.ResourceControllerDataProvider;
import org.apache.helix.controller.rebalancer.strategy.RebalanceStrategy;
import org.apache.helix.controller.rebalancer.strategy.crushMapping.CRUSHPlacementAlgorithm;
import org.apache.helix.controller.rebalancer.topology.InstanceNode;
import org.apache.helix.controller.rebalancer.topology.Node;
import org.apache.helix.controller.rebalancer.topology.Topology;
import org.apache.helix.model.InstanceConfig;
import org.apache.helix.util.JenkinsHash;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrushRebalanceStrategy
implements RebalanceStrategy<ResourceControllerDataProvider> {
    private static final Logger Log = LoggerFactory.getLogger((String)CrushRebalanceStrategy.class.getName());
    private String _resourceName;
    private List<String> _partitions;
    private Topology _clusterTopo;
    private int _replicas;
    private static final int MAX_RETRY = 10;
    private final JenkinsHash hashFun = new JenkinsHash();
    private CRUSHPlacementAlgorithm placementAlgorithm = new CRUSHPlacementAlgorithm();

    @Override
    public void init(String resourceName, List<String> partitions, LinkedHashMap<String, Integer> states, int maximumPerNode) {
        this._resourceName = resourceName;
        this._partitions = partitions;
        this._replicas = this.countStateReplicas(states);
    }

    @Override
    public ZNRecord computePartitionAssignment(List<String> allNodes, List<String> liveNodes, Map<String, Map<String, String>> currentMapping, ResourceControllerDataProvider clusterData) throws HelixException {
        Map<String, InstanceConfig> instanceConfigMap = clusterData.getInstanceConfigMap();
        this._clusterTopo = new Topology(allNodes, liveNodes, instanceConfigMap, clusterData.getClusterConfig());
        Node topNode = this._clusterTopo.getRootNode();
        String eventId = clusterData.getClusterEventId();
        HashMap<String, List<String>> newPreferences = new HashMap<String, List<String>>();
        for (int i = 0; i < this._partitions.size(); ++i) {
            List<Node> selected;
            String partitionName = this._partitions.get(i);
            long data = partitionName.hashCode();
            try {
                selected = this.select(topNode, data, this._replicas, eventId);
            }
            catch (IllegalStateException e) {
                String errorMessage = String.format("Could not select enough number of nodes. %s partition %s, required %d", this._resourceName, partitionName, this._replicas);
                throw new HelixException(errorMessage, e);
            }
            if (selected.size() < this._replicas) {
                LogUtil.logError(Log, eventId, String.format("Can not find enough node for resource %s partition %s, required %d, find %d", this._resourceName, partitionName, this._replicas, selected.size()));
            }
            ArrayList<String> nodeList = new ArrayList<String>();
            for (int j = 0; j < selected.size(); ++j) {
                Node selectedNode = selected.get(j);
                if (selectedNode instanceof InstanceNode) {
                    nodeList.add(((InstanceNode)selectedNode).getInstanceName());
                    continue;
                }
                LogUtil.logError(Log, eventId, "Selected node is not associated with an instance: " + selectedNode.toString());
            }
            newPreferences.put(partitionName, nodeList);
        }
        ZNRecord result = new ZNRecord(this._resourceName);
        result.setListFields(newPreferences);
        return result;
    }

    private List<Node> select(Node topNode, long data, int rf, String eventId) throws HelixException {
        ArrayList<Node> nodes = new ArrayList<Node>(rf);
        HashSet<Node> selectedZones = new HashSet<Node>();
        long input = data;
        int count = rf;
        int tries = 0;
        while (nodes.size() < rf) {
            this.doSelect(topNode, input, count, nodes, selectedZones);
            count = rf - nodes.size();
            if (count <= 0) continue;
            input = this.hashFun.hash(input);
            if (++tries < 10) continue;
            LogUtil.logError(Log, eventId, String.format("Could not find all mappings after %d tries", tries));
            break;
        }
        return nodes;
    }

    private void doSelect(Node topNode, long input, int rf, List<Node> selectedNodes, Set<Node> selectedZones) {
        String endNodeType;
        String zoneType = this._clusterTopo.getFaultZoneType();
        if (!zoneType.equals(endNodeType = this._clusterTopo.getEndNodeType())) {
            List<Node> zones = this.placementAlgorithm.select(topNode, input, rf, zoneType, this.nodeAlreadySelected(selectedZones));
            selectedZones.addAll(zones);
            for (Node zone : zones) {
                List<Node> endNode = this.placementAlgorithm.select(zone, input, 1, endNodeType);
                selectedNodes.addAll(endNode);
            }
        } else {
            List<Node> nodes = this.placementAlgorithm.select(topNode, input, rf, endNodeType, this.nodeAlreadySelected(new HashSet<Node>(selectedNodes)));
            selectedNodes.addAll(nodes);
        }
    }

    private Predicate<Node> nodeAlreadySelected(Set<Node> selectedNodes) {
        return Predicates.not((Predicate)Predicates.in(selectedNodes));
    }

    private int countStateReplicas(Map<String, Integer> stateCountMap) {
        int total = 0;
        for (Integer count : stateCountMap.values()) {
            total += count.intValue();
        }
        return total;
    }
}

