/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.tools.commandtools;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.helix.HelixManager;
import org.apache.helix.HelixManagerFactory;
import org.apache.helix.InstanceType;
import org.apache.helix.task.JobConfig;
import org.apache.helix.task.JobContext;
import org.apache.helix.task.TaskConfig;
import org.apache.helix.task.TaskDriver;
import org.apache.helix.task.TaskPartitionState;
import org.apache.helix.task.TaskState;
import org.apache.helix.task.Workflow;
import org.apache.helix.task.WorkflowConfig;
import org.apache.helix.task.WorkflowContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskAdmin {
    private static final Logger LOG = LoggerFactory.getLogger(TaskAdmin.class);
    private static final String ZK_ADDRESS = "zk";
    private static final String CLUSTER_NAME_OPTION = "cluster";
    private static final String RESOURCE_OPTION = "resource";
    private static final String WORKFLOW_FILE_OPTION = "file";

    public static void main(String[] args) throws Exception {
        String[] cmdArgs = Arrays.copyOfRange(args, 1, args.length);
        CommandLine cl = TaskAdmin.parseOptions(cmdArgs, TaskAdmin.constructOptions(), args[0]);
        String zkAddr = cl.getOptionValue(ZK_ADDRESS);
        String clusterName = cl.getOptionValue(CLUSTER_NAME_OPTION);
        String workflow = cl.getOptionValue(RESOURCE_OPTION);
        if (zkAddr == null || clusterName == null || workflow == null) {
            TaskAdmin.printUsage(TaskAdmin.constructOptions(), "[cmd]");
            throw new IllegalArgumentException("zk, cluster, and resource must all be non-null for all commands");
        }
        HelixManager helixMgr = HelixManagerFactory.getZKHelixManager(clusterName, "Admin", InstanceType.ADMINISTRATOR, zkAddr);
        helixMgr.connect();
        TaskDriver driver = new TaskDriver(helixMgr);
        TaskDriver.DriverCommand cmd = TaskDriver.DriverCommand.valueOf(args[0]);
        switch (cmd) {
            case start: {
                if (cl.hasOption(WORKFLOW_FILE_OPTION)) {
                    driver.start(Workflow.parse(new File(cl.getOptionValue(WORKFLOW_FILE_OPTION))));
                    break;
                }
                throw new IllegalArgumentException("Workflow file is required to start flow.");
            }
            case stop: {
                driver.stop(workflow);
                break;
            }
            case resume: {
                driver.resume(workflow);
                break;
            }
            case delete: {
                driver.delete(workflow);
                break;
            }
            case list: {
                TaskAdmin.list(driver, workflow);
                break;
            }
            case flush: {
                driver.flushQueue(workflow);
                break;
            }
            case clean: {
                driver.cleanupQueue(workflow);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown command " + args[0]);
            }
        }
        helixMgr.disconnect();
    }

    private static void list(TaskDriver taskDriver, String workflow) {
        WorkflowConfig wCfg = taskDriver.getWorkflowConfig(workflow);
        if (wCfg == null) {
            LOG.error("Workflow " + workflow + " does not exist!");
            return;
        }
        WorkflowContext wCtx = taskDriver.getWorkflowContext(workflow);
        LOG.info("Workflow " + workflow + " consists of the following tasks: " + wCfg.getJobDag().getAllNodes());
        String workflowState = wCtx != null ? wCtx.getWorkflowState().name() : TaskState.NOT_STARTED.name();
        LOG.info("Current state of workflow is " + workflowState);
        LOG.info("Job states are: ");
        LOG.info("-------");
        for (String job : wCfg.getJobDag().getAllNodes()) {
            TaskState jobState = wCtx != null ? wCtx.getJobState(job) : TaskState.NOT_STARTED;
            LOG.info("Job " + job + " is " + jobState);
            JobConfig jCfg = taskDriver.getJobConfig(job);
            JobContext jCtx = taskDriver.getJobContext(job);
            if (jCfg == null || jCtx == null) {
                LOG.info("-------");
                continue;
            }
            ArrayList partitions = Lists.newArrayList(jCtx.getPartitionSet());
            Collections.sort(partitions);
            for (Integer partition : partitions) {
                TaskPartitionState state;
                String taskId = jCtx.getTaskIdForPartition(partition);
                taskId = taskId != null ? taskId : jCtx.getTargetForPartition(partition);
                LOG.info("Task: " + taskId);
                TaskConfig taskConfig = jCfg.getTaskConfig(taskId);
                if (taskConfig != null) {
                    LOG.info("Configuration: " + taskConfig.getConfigMap());
                }
                state = (state = jCtx.getPartitionState(partition)) != null ? state : TaskPartitionState.INIT;
                LOG.info("State: " + state);
                String assignedParticipant = jCtx.getAssignedParticipant(partition);
                if (assignedParticipant != null) {
                    LOG.info("Assigned participant: " + assignedParticipant);
                }
                LOG.info("-------");
            }
            LOG.info("-------");
        }
    }

    private static OptionGroup contructGenericRequiredOptionGroup() {
        OptionBuilder.isRequired();
        OptionBuilder.withLongOpt((String)ZK_ADDRESS);
        OptionBuilder.withDescription((String)"ZK address managing cluster");
        Option zkAddressOption = OptionBuilder.create();
        zkAddressOption.setArgs(1);
        zkAddressOption.setArgName("zkAddress");
        OptionBuilder.isRequired();
        OptionBuilder.withLongOpt((String)CLUSTER_NAME_OPTION);
        OptionBuilder.withDescription((String)"Cluster name");
        Option clusterNameOption = OptionBuilder.create();
        clusterNameOption.setArgs(1);
        clusterNameOption.setArgName("clusterName");
        OptionBuilder.isRequired();
        OptionBuilder.withLongOpt((String)RESOURCE_OPTION);
        OptionBuilder.withDescription((String)"Workflow or job name");
        Option taskResourceOption = OptionBuilder.create();
        taskResourceOption.setArgs(1);
        taskResourceOption.setArgName("resourceName");
        OptionGroup group = new OptionGroup();
        group.addOption(zkAddressOption);
        group.addOption(clusterNameOption);
        group.addOption(taskResourceOption);
        return group;
    }

    private static Options constructOptions() {
        Options options = new Options();
        options.addOptionGroup(TaskAdmin.contructGenericRequiredOptionGroup());
        options.addOptionGroup(TaskAdmin.constructStartOptionGroup());
        return options;
    }

    private static OptionGroup constructStartOptionGroup() {
        OptionBuilder.withLongOpt((String)WORKFLOW_FILE_OPTION);
        OptionBuilder.withDescription((String)"Local file describing workflow");
        Option workflowFileOption = OptionBuilder.create();
        workflowFileOption.setArgs(1);
        workflowFileOption.setArgName("workflowFile");
        OptionGroup group = new OptionGroup();
        group.addOption(workflowFileOption);
        return group;
    }

    private static CommandLine parseOptions(String[] args, Options options, String cmdStr) {
        GnuParser cliParser = new GnuParser();
        CommandLine cmd = null;
        try {
            cmd = cliParser.parse(options, args);
        }
        catch (ParseException pe) {
            LOG.error("CommandLineClient: failed to parse command-line options: " + pe.toString());
            TaskAdmin.printUsage(options, cmdStr);
            System.exit(1);
        }
        boolean ret = TaskAdmin.checkOptionArgsNumber(cmd.getOptions());
        if (!ret) {
            TaskAdmin.printUsage(options, cmdStr);
            System.exit(1);
        }
        return cmd;
    }

    private static boolean checkOptionArgsNumber(Option[] options) {
        for (Option option : options) {
            int argNb = option.getArgs();
            Object[] args = option.getValues();
            if (argNb == 0) {
                if (args == null || args.length <= 0) continue;
                System.err.println(option.getArgName() + " shall have " + argNb + " arguments (was " + Arrays.toString(args) + ")");
                return false;
            }
            if (args != null && args.length == argNb) continue;
            System.err.println(option.getArgName() + " shall have " + argNb + " arguments (was " + Arrays.toString(args) + ")");
            return false;
        }
        return true;
    }

    private static void printUsage(Options cliOptions, String cmd) {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.setWidth(1000);
        helpFormatter.printHelp("java " + TaskAdmin.class.getName() + " " + cmd, cliOptions);
    }
}

