/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.rebalancer.waged;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.helix.BucketDataAccessor;
import org.apache.helix.HelixException;
import org.apache.helix.HelixProperty;
import org.apache.helix.manager.zk.ZkBucketDataAccessor;
import org.apache.helix.model.ResourceAssignment;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.helix.zookeeper.datamodel.serializer.ZNRecordJacksonSerializer;
import org.apache.helix.zookeeper.zkclient.exception.ZkNoNodeException;
import org.apache.helix.zookeeper.zkclient.serialize.ZkSerializer;

public class AssignmentMetadataStore {
    private static final String ASSIGNMENT_METADATA_KEY = "ASSIGNMENT_METADATA";
    private static final String BASELINE_TEMPLATE = "/%s/%s/BASELINE";
    private static final String BEST_POSSIBLE_TEMPLATE = "/%s/%s/BEST_POSSIBLE";
    private static final String BASELINE_KEY = "BASELINE";
    private static final String BEST_POSSIBLE_KEY = "BEST_POSSIBLE";
    private static final ZkSerializer SERIALIZER = new ZNRecordJacksonSerializer();
    private final BucketDataAccessor _dataAccessor;
    private final String _baselinePath;
    private final String _bestPossiblePath;
    protected volatile Map<String, ResourceAssignment> _globalBaseline;
    protected volatile Map<String, ResourceAssignment> _bestPossibleAssignment;
    protected volatile int _bestPossibleVersion = 0;
    protected volatile int _lastPersistedBestPossibleVersion = 0;

    AssignmentMetadataStore(String metadataStoreAddrs, String clusterName) {
        this(new ZkBucketDataAccessor(metadataStoreAddrs), clusterName);
    }

    protected AssignmentMetadataStore(BucketDataAccessor bucketDataAccessor, String clusterName) {
        this._dataAccessor = bucketDataAccessor;
        this._baselinePath = String.format(BASELINE_TEMPLATE, clusterName, ASSIGNMENT_METADATA_KEY);
        this._bestPossiblePath = String.format(BEST_POSSIBLE_TEMPLATE, clusterName, ASSIGNMENT_METADATA_KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, ResourceAssignment> getBaseline() {
        if (this._globalBaseline == null) {
            AssignmentMetadataStore assignmentMetadataStore = this;
            synchronized (assignmentMetadataStore) {
                if (this._globalBaseline == null) {
                    this._globalBaseline = this.fetchAssignmentOrDefault(this._baselinePath);
                }
            }
        }
        return this._globalBaseline;
    }

    protected boolean hasPersistedLatestBestPossibleAssignment() {
        return this._lastPersistedBestPossibleVersion == this._bestPossibleVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, ResourceAssignment> getBestPossibleAssignment() {
        if (this._bestPossibleAssignment == null) {
            AssignmentMetadataStore assignmentMetadataStore = this;
            synchronized (assignmentMetadataStore) {
                if (this._bestPossibleAssignment == null) {
                    this._bestPossibleAssignment = this.fetchAssignmentOrDefault(this._bestPossiblePath);
                }
            }
        }
        return this._bestPossibleAssignment;
    }

    private Map<String, ResourceAssignment> fetchAssignmentOrDefault(String path) {
        try {
            HelixProperty assignment = this._dataAccessor.compressedBucketRead(path, HelixProperty.class);
            return this.splitAssignments(assignment);
        }
        catch (ZkNoNodeException ex) {
            return new HashMap<String, ResourceAssignment>();
        }
    }

    private void persistAssignmentToMetadataStore(Map<String, ResourceAssignment> newAssignment, String path, String key) throws HelixException {
        HelixProperty combinedAssignments = this.combineAssignments(key, newAssignment);
        try {
            this._dataAccessor.compressedBucketWrite(path, combinedAssignments);
        }
        catch (IOException e) {
            throw new HelixException(String.format("Failed to persist %s assignment to path %s", key, path), e);
        }
    }

    public synchronized void persistBaseline(Map<String, ResourceAssignment> globalBaseline) {
        this.persistAssignmentToMetadataStore(globalBaseline, this._baselinePath, BASELINE_KEY);
        this.getBaseline().clear();
        this.getBaseline().putAll(globalBaseline);
    }

    public synchronized void persistBestPossibleAssignment(Map<String, ResourceAssignment> bestPossibleAssignment) {
        this.persistAssignmentToMetadataStore(bestPossibleAssignment, this._bestPossiblePath, BEST_POSSIBLE_KEY);
        this.getBestPossibleAssignment().clear();
        this.getBestPossibleAssignment().putAll(bestPossibleAssignment);
        ++this._bestPossibleVersion;
        this._lastPersistedBestPossibleVersion = this._bestPossibleVersion;
    }

    public synchronized boolean asyncUpdateBestPossibleAssignmentCache(Map<String, ResourceAssignment> bestPossibleAssignment, int newVersion) {
        if (newVersion > this._bestPossibleVersion) {
            this.getBestPossibleAssignment().clear();
            this.getBestPossibleAssignment().putAll(bestPossibleAssignment);
            this._bestPossibleVersion = newVersion;
            return true;
        }
        return false;
    }

    public int getBestPossibleVersion() {
        return this._bestPossibleVersion;
    }

    public synchronized void clearAssignmentMetadata() {
        this.persistAssignmentToMetadataStore(Collections.emptyMap(), this._baselinePath, BASELINE_KEY);
        this.persistAssignmentToMetadataStore(Collections.emptyMap(), this._bestPossiblePath, BEST_POSSIBLE_KEY);
        this.getBaseline().clear();
        this.getBestPossibleAssignment().clear();
    }

    protected synchronized void reset() {
        if (this._bestPossibleAssignment != null) {
            this._bestPossibleAssignment.clear();
            this._bestPossibleAssignment = null;
        }
        if (this._globalBaseline != null) {
            this._globalBaseline.clear();
            this._globalBaseline = null;
        }
    }

    protected void finalize() {
        this.close();
    }

    public void close() {
        this._dataAccessor.disconnect();
    }

    private HelixProperty combineAssignments(String name, Map<String, ResourceAssignment> assignmentMap) {
        HelixProperty property = new HelixProperty(name);
        assignmentMap.forEach((resource, assignment) -> property.getRecord().setSimpleField((String)resource, new String(SERIALIZER.serialize(assignment.getRecord()))));
        return property;
    }

    private Map<String, ResourceAssignment> splitAssignments(HelixProperty property) {
        HashMap<String, ResourceAssignment> assignmentMap = new HashMap<String, ResourceAssignment>();
        property.getRecord().getSimpleFields().forEach((resource, assignmentStr) -> assignmentMap.put((String)resource, new ResourceAssignment((ZNRecord)SERIALIZER.deserialize(assignmentStr.getBytes()))));
        return assignmentMap;
    }

    protected boolean isBaselineChanged(Map<String, ResourceAssignment> newBaseline) {
        return !this.getBaseline().equals(newBaseline);
    }

    protected boolean isBestPossibleChanged(Map<String, ResourceAssignment> newBestPossible) {
        return !this.getBestPossibleAssignment().equals(newBestPossible);
    }
}

