/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql;

public enum EclipseLinkVersion {
    DEFAULT_VERSION(4.0),
    VERSION_1_x(1.0),
    VERSION_2_0(2.0),
    VERSION_2_1(2.1),
    VERSION_2_2(2.2),
    VERSION_2_3(2.3),
    VERSION_2_4(2.4),
    VERSION_2_5(2.5),
    VERSION_2_6(2.6),
    VERSION_3_0(3.0),
    VERSION_4_0(4.0);

    private final double version;

    private EclipseLinkVersion(double version) {
        this.version = version;
    }

    public static EclipseLinkVersion value(String value) {
        for (EclipseLinkVersion version : EclipseLinkVersion.versions()) {
            if (!version.getVersion().equals(value)) continue;
            return version;
        }
        return DEFAULT_VERSION;
    }

    public static EclipseLinkVersion[] versions() {
        EclipseLinkVersion[] values = new EclipseLinkVersion[]{VERSION_1_x, VERSION_2_0, VERSION_2_1, VERSION_2_2, VERSION_2_3, VERSION_2_4, VERSION_2_5, VERSION_3_0, VERSION_4_0};
        return values;
    }

    public String getVersion() {
        return String.valueOf(this.version);
    }

    public boolean isNewerThan(EclipseLinkVersion version) {
        return this.version > version.version;
    }

    public boolean isNewerThanOrEqual(EclipseLinkVersion version) {
        return this.version >= version.version;
    }

    public boolean isOlderThan(EclipseLinkVersion version) {
        return this.version < version.version;
    }

    public boolean isOlderThanOrEqual(EclipseLinkVersion version) {
        return this.version <= version.version;
    }

    public EclipseLinkVersion toCurrentVersion() {
        if (this == DEFAULT_VERSION) {
            String currentVersion = this.getVersion();
            for (EclipseLinkVersion version : EclipseLinkVersion.versions()) {
                if (!currentVersion.equals(String.valueOf(version.version))) continue;
                return version;
            }
        }
        return this;
    }

    public String toString() {
        return String.valueOf(this.version);
    }
}

