/*
 * Decompiled with CFR 0.152.
 */
package com.github.jinahya.bit.io;

final class BitIoConstraints {
    static final int MIN_EXPONENT = 3;
    static final int MAX_EXPONENT = 6;
    static final int MIN_SIZE = 1;
    private static final int[] MAX_SIZES = new int[4];

    static int requireValidSizeUnsigned8(int size) {
        if (size < 1) {
            throw new IllegalArgumentException("size(" + size + ") < 1");
        }
        if (size > 8) {
            throw new IllegalArgumentException("size(" + size + ") > " + 8);
        }
        return size;
    }

    static int requireValidSizeUnsigned16(int size) {
        if (size < 1) {
            throw new IllegalArgumentException("size(" + size + ") < 1");
        }
        if (size > 16) {
            throw new IllegalArgumentException("size(" + size + ") > " + 16);
        }
        return size;
    }

    static int requireValidExponent(int exponent) {
        if (exponent < 3) {
            throw new IllegalArgumentException("exponent(" + exponent + ") < " + 3);
        }
        if (exponent > 6) {
            throw new IllegalArgumentException("exponent(" + exponent + ") > " + 6);
        }
        return exponent;
    }

    static int maxSize(boolean unsigned, int exponent) {
        return MAX_SIZES[BitIoConstraints.requireValidExponent(exponent) - 3] - (unsigned ? 1 : 0);
    }

    static int requireValidSize(boolean unsigned, int exponent, int size) {
        if (size < 1) {
            throw new IllegalArgumentException("size(" + size + ") < " + 1);
        }
        int maxSize = BitIoConstraints.maxSize(unsigned, exponent);
        if (size > maxSize) {
            throw new IllegalArgumentException("size(" + size + ") > " + maxSize + "; unsigned=" + unsigned + "; exponent=" + exponent);
        }
        return size;
    }

    static int requireValidSizeByte(boolean unsigned, int size) {
        return BitIoConstraints.requireValidSize(unsigned, 3, size);
    }

    static int requireValidSizeShort(boolean unsigned, int size) {
        return BitIoConstraints.requireValidSize(unsigned, 4, size);
    }

    static int requireValidSizeInt(boolean unsigned, int size) {
        return BitIoConstraints.requireValidSize(unsigned, 5, size);
    }

    static int requireValidSizeLong(boolean unsigned, int size) {
        return BitIoConstraints.requireValidSize(unsigned, 6, size);
    }

    static int requireValidSizeChar(int size) {
        return BitIoConstraints.requireValidSizeUnsigned16(size);
    }

    private BitIoConstraints() {
    }

    static {
        BitIoConstraints.MAX_SIZES[0] = (int)Math.pow(2.0, 3.0);
        for (int i = 1; i < MAX_SIZES.length; ++i) {
            BitIoConstraints.MAX_SIZES[i] = MAX_SIZES[i - 1] * 2;
        }
    }
}

