/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.calculate;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hertzbeat.alert.calculate.AlarmCacheManager;
import org.apache.hertzbeat.alert.reduce.AlarmCommonReduce;
import org.apache.hertzbeat.alert.service.DataSourceService;
import org.apache.hertzbeat.alert.util.AlertTemplateUtil;
import org.apache.hertzbeat.alert.util.AlertUtil;
import org.apache.hertzbeat.common.entity.alerter.AlertDefine;
import org.apache.hertzbeat.common.entity.alerter.SingleAlert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PeriodicAlertCalculator {
    private static final Logger log = LoggerFactory.getLogger(PeriodicAlertCalculator.class);
    private static final String VALUE = "__value__";
    private static final String TIMESTAMP = "__timestamp__";
    private final DataSourceService dataSourceService;
    private final AlarmCommonReduce alarmCommonReduce;
    private final AlarmCacheManager alarmCacheManager;

    public PeriodicAlertCalculator(DataSourceService dataSourceService, AlarmCommonReduce alarmCommonReduce, AlarmCacheManager alarmCacheManager) {
        this.dataSourceService = dataSourceService;
        this.alarmCommonReduce = alarmCommonReduce;
        this.alarmCacheManager = alarmCacheManager;
    }

    public void calculate(AlertDefine define) {
        if (!define.isEnable() || StringUtils.isEmpty((CharSequence)define.getExpr())) {
            log.error("Periodic define {} is disabled or expression is empty", (Object)define.getName());
            return;
        }
        long currentTimeMilli = System.currentTimeMillis();
        try {
            try {
                List<Map<String, Object>> results = this.dataSourceService.calculate(define.getDatasource(), define.getExpr());
                if (CollectionUtils.isEmpty(results)) {
                    return;
                }
                for (Map<String, Object> result : results) {
                    HashMap<String, String> fingerPrints = new HashMap<String, String>(8);
                    fingerPrints.put("defineid", String.valueOf(define.getId()));
                    fingerPrints.put("alertname", define.getName());
                    fingerPrints.putAll(define.getLabels());
                    for (Map.Entry<String, Object> entry : result.entrySet()) {
                        if (entry.getValue() == null || VALUE.equals(entry.getKey()) || TIMESTAMP.equals(entry.getKey())) continue;
                        fingerPrints.put(entry.getKey(), entry.getValue().toString());
                    }
                    if (result.get(VALUE) == null) {
                        this.handleRecoveredAlert(define.getId(), fingerPrints);
                        continue;
                    }
                    HashMap<String, Object> fieldValueMap = new HashMap<String, Object>(8);
                    fieldValueMap.putAll(define.getLabels());
                    fieldValueMap.put("alertname", define.getName());
                    for (Map.Entry<String, Object> entry : result.entrySet()) {
                        if (entry.getValue() == null) continue;
                        fieldValueMap.put(entry.getKey(), entry.getValue());
                    }
                    this.afterThresholdRuleMatch(currentTimeMilli, fingerPrints, fieldValueMap, define);
                }
            }
            catch (Exception ignored) {
                return;
            }
        }
        catch (Exception e) {
            log.error("Calculate periodic define {} failed: {}", (Object)define.getName(), (Object)e.getMessage());
        }
    }

    private void afterThresholdRuleMatch(long currentTimeMilli, Map<String, String> fingerPrints, Map<String, Object> fieldValueMap, AlertDefine define) {
        int requiredTimes;
        Long defineId = define.getId();
        String fingerprint = AlertUtil.calculateFingerprint(fingerPrints);
        SingleAlert existingAlert = this.alarmCacheManager.getPending(defineId, fingerprint);
        HashMap<String, String> labels = new HashMap<String, String>(8);
        fieldValueMap.putAll(define.getLabels());
        labels.putAll(fingerPrints);
        int n = requiredTimes = define.getTimes() == null ? 1 : define.getTimes();
        if (existingAlert == null) {
            SingleAlert newAlert = SingleAlert.builder().labels(labels).annotations(define.getAnnotations()).content(AlertTemplateUtil.render(define.getTemplate(), fieldValueMap)).status("pending").triggerTimes(Integer.valueOf(1)).startAt(Long.valueOf(currentTimeMilli)).activeAt(Long.valueOf(currentTimeMilli)).build();
            if (requiredTimes <= 1) {
                newAlert.setStatus("firing");
                this.alarmCacheManager.putFiring(defineId, fingerprint, newAlert);
                this.alarmCommonReduce.reduceAndSendAlarm(newAlert.clone());
            } else {
                this.alarmCacheManager.putPending(defineId, fingerprint, newAlert);
            }
        } else {
            existingAlert.setTriggerTimes(Integer.valueOf(existingAlert.getTriggerTimes() + 1));
            existingAlert.setActiveAt(Long.valueOf(currentTimeMilli));
            if (existingAlert.getStatus().equals("pending") && existingAlert.getTriggerTimes() >= requiredTimes) {
                this.alarmCacheManager.removePending(defineId, fingerprint);
                existingAlert.setStatus("firing");
                this.alarmCacheManager.putFiring(defineId, fingerprint, existingAlert);
                this.alarmCommonReduce.reduceAndSendAlarm(existingAlert.clone());
            }
        }
    }

    private void handleRecoveredAlert(Long defineId, Map<String, String> fingerprints) {
        String fingerprint = AlertUtil.calculateFingerprint(fingerprints);
        SingleAlert firingAlert = this.alarmCacheManager.removeFiring(defineId, fingerprint);
        if (firingAlert != null) {
            firingAlert.setTriggerTimes(Integer.valueOf(1));
            firingAlert.setEndAt(Long.valueOf(System.currentTimeMillis()));
            firingAlert.setStatus("resolved");
            this.alarmCommonReduce.reduceAndSendAlarm(firingAlert.clone());
        }
        this.alarmCacheManager.removePending(defineId, fingerprint);
    }
}

