/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.hadoop.hive.ql.exec;

import java.io.Serializable;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ForwardDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;

/**
 * Forward Operator Just forwards. Doesn't do anything itself.
 **/
public class ForwardOperator extends Operator<ForwardDesc> implements
    Serializable {
  private static final long serialVersionUID = 1L;

  @Override
  public void process(Object row, int tag) throws HiveException {
    forward(row, inputObjInspectors[tag]);
  }

  @Override
  public OperatorType getType() {
    return OperatorType.FORWARD;
  }

  @Override
  public boolean acceptLimitPushdown() {
    return true;
  }

  /**
   * @return the name of the operator
   */
  @Override
  public String getName() {
    return ForwardOperator.getOperatorName();
  }

  static public String getOperatorName() {
    return "FOR";
  }

  /** Kryo ctor. */
  protected ForwardOperator() {
    super();
  }

  public ForwardOperator(CompilationOpContext ctx) {
    super(ctx);
  }

  @Override
  protected void initializeOp(Configuration hconf) throws HiveException {
    super.initializeOp(hconf);
  }

  @Override
  public boolean logicalEquals(Operator other) {
    return getClass().getName().equals(other.getClass().getName());
  }
}
