/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.reactor;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hc.core5.http.ConnectionClosedException;
import org.apache.hc.core5.http.nio.command.CommandSupport;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.reactor.Command;
import org.apache.hc.core5.reactor.IOEventHandler;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.reactor.IOSessionRequest;
import org.apache.hc.core5.reactor.SocksProxyProtocolHandler;
import org.apache.hc.core5.util.Timeout;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestSocksProxyProtocolHandler {
    TestSocksProxyProtocolHandler() {
    }

    @Test
    @org.junit.jupiter.api.Timeout(value=5L)
    void socksProxyEOFDuringConnectResponseCompletesSessionRequestExceptionally() throws Exception {
        IOReactorConfig reactorConfig = IOReactorConfig.custom().build();
        NamedEndpoint remoteEndpoint = new NamedEndpoint(){

            public String getHostName() {
                return "example";
            }

            public int getPort() {
                return 443;
            }
        };
        InetSocketAddress targetAddress = new InetSocketAddress(InetAddress.getLoopbackAddress(), 443);
        IOSessionRequest sessionRequest = new IOSessionRequest(remoteEndpoint, (SocketAddress)targetAddress, null, Timeout.ofSeconds((long)1L), null, null);
        SocksProxyProtocolHandler handler = new SocksProxyProtocolHandler(null, sessionRequest, null, reactorConfig);
        TestIOSession session = new TestIOSession();
        Assertions.assertEquals((int)0, (int)session.getEventMask());
        handler.connected((IOSession)session);
        Assertions.assertEquals((int)4, (int)session.getEventMask());
        handler.outputReady((IOSession)session);
        Assertions.assertEquals((int)1, (int)session.getEventMask());
        handler.inputReady((IOSession)session, ByteBuffer.wrap(new byte[]{5, 0}));
        Assertions.assertEquals((int)4, (int)session.getEventMask());
        handler.outputReady((IOSession)session);
        Assertions.assertEquals((int)1, (int)session.getEventMask());
        ConnectionClosedException ex = (ConnectionClosedException)Assertions.assertThrows(ConnectionClosedException.class, () -> handler.inputReady((IOSession)session, null), (String)"EOF during SOCKS handshake must fail the exchange");
        handler.exception((IOSession)session, (Exception)ex);
        Assertions.assertTrue((boolean)sessionRequest.isDone(), (String)"Session request future must be completed");
        ExecutionException ee = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> ((IOSessionRequest)sessionRequest).get());
        Assertions.assertSame((Object)ex, (Object)ee.getCause(), (String)"Cause must be the original EOF/close exception");
        Assertions.assertEquals((Object)CloseMode.IMMEDIATE, (Object)session.getLastCloseMode(), (String)"Session must be closed immediately");
    }

    private static final class TestIOSession
    implements IOSession {
        private final Lock lock = new ReentrantLock();
        private final Deque<Command> commands = new ArrayDeque<Command>();
        private volatile boolean open = true;
        private volatile int eventMask = 0;
        private volatile IOEventHandler handler;
        private volatile Timeout socketTimeout = Timeout.DISABLED;
        private volatile long lastReadTime;
        private volatile long lastWriteTime = this.lastReadTime = System.currentTimeMillis();
        private volatile long lastEventTime = this.lastReadTime;
        private volatile CloseMode lastCloseMode;

        TestIOSession() {
        }

        CloseMode getLastCloseMode() {
            return this.lastCloseMode;
        }

        public ByteChannel channel() {
            return this;
        }

        public void setEventMask(int ops) {
            this.eventMask = ops;
            this.lastEventTime = System.currentTimeMillis();
        }

        public int getEventMask() {
            return this.eventMask;
        }

        public void setEvent(int op) {
            this.setEventMask(this.eventMask | op);
        }

        public void clearEvent(int op) {
            this.setEventMask(this.eventMask & ~op);
        }

        public IOEventHandler getHandler() {
            return this.handler;
        }

        public void upgrade(IOEventHandler handler) {
            this.handler = handler;
        }

        public Lock getLock() {
            return this.lock;
        }

        public void enqueue(Command command, Command.Priority priority) {
            this.commands.add(command);
        }

        public boolean hasCommands() {
            return !this.commands.isEmpty();
        }

        public Command poll() {
            return this.commands.poll();
        }

        public SocketAddress getRemoteAddress() {
            return null;
        }

        public SocketAddress getLocalAddress() {
            return null;
        }

        public Timeout getSocketTimeout() {
            return this.socketTimeout;
        }

        public void setSocketTimeout(Timeout timeout) {
            this.socketTimeout = timeout;
            this.lastEventTime = System.currentTimeMillis();
        }

        public long getLastReadTime() {
            return this.lastReadTime;
        }

        public long getLastWriteTime() {
            return this.lastWriteTime;
        }

        public long getLastEventTime() {
            return this.lastEventTime;
        }

        public void updateReadTime() {
            this.lastEventTime = this.lastReadTime = System.currentTimeMillis();
        }

        public void updateWriteTime() {
            this.lastEventTime = this.lastWriteTime = System.currentTimeMillis();
        }

        public IOSession.Status getStatus() {
            return this.open ? IOSession.Status.ACTIVE : IOSession.Status.CLOSED;
        }

        public String getId() {
            return "test";
        }

        public int read(ByteBuffer dst) throws IOException {
            return -1;
        }

        public int write(ByteBuffer src) throws IOException {
            int n = src.remaining();
            src.position(src.limit());
            this.updateWriteTime();
            return n;
        }

        public boolean isOpen() {
            return this.open;
        }

        public void close() {
            this.open = false;
        }

        public void close(CloseMode closeMode) {
            this.lastCloseMode = closeMode;
            this.open = false;
            CommandSupport.cancelCommands((IOSession)this);
        }
    }
}

