/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.jdbc;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.jdbc.JdbcBaseSchema;
import org.apache.calcite.adapter.jdbc.JdbcConvention;
import org.apache.calcite.adapter.jdbc.JdbcSchema;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Schemas;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.Wrapper;
import org.apache.calcite.schema.lookup.IgnoreCaseLookup;
import org.apache.calcite.schema.lookup.LikePattern;
import org.apache.calcite.schema.lookup.LoadingCacheLookup;
import org.apache.calcite.schema.lookup.Lookup;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlDialectFactory;
import org.apache.calcite.sql.SqlDialectFactoryImpl;
import org.apache.calcite.util.BuiltInMethod;
import org.checkerframework.checker.nullness.qual.Nullable;

public class JdbcCatalogSchema
extends JdbcBaseSchema
implements Wrapper {
    final DataSource dataSource;
    public final SqlDialect dialect;
    final JdbcConvention convention;
    final String catalog;
    private final Lookup<JdbcSchema> subSchemas;
    private final Supplier<Optional<String>> defaultSchemaName = Suppliers.memoize(() -> Optional.ofNullable(this.computeDefaultSchemaName()));

    public JdbcCatalogSchema(final DataSource dataSource, final SqlDialect dialect, final JdbcConvention convention, final String catalog) {
        this.dataSource = Objects.requireNonNull(dataSource, "dataSource");
        this.dialect = Objects.requireNonNull(dialect, "dialect");
        this.convention = Objects.requireNonNull(convention, "convention");
        this.catalog = catalog;
        this.subSchemas = new LoadingCacheLookup<JdbcSchema>(new IgnoreCaseLookup<JdbcSchema>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public @Nullable JdbcSchema get(String name) {
                try (Connection connection = dataSource.getConnection();
                     ResultSet resultSet = connection.getMetaData().getSchemas(catalog, name);){
                    if (!resultSet.next()) return null;
                    String schemaName = Objects.requireNonNull(resultSet.getString(1), "got null schemaName from the database");
                    JdbcSchema jdbcSchema = new JdbcSchema(dataSource, dialect, convention, catalog, schemaName);
                    return jdbcSchema;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public Set<String> getNames(LikePattern pattern) {
                ImmutableSet.Builder builder = ImmutableSet.builder();
                try (Connection connection = dataSource.getConnection();
                     ResultSet resultSet = connection.getMetaData().getSchemas(catalog, pattern.pattern);){
                    while (resultSet.next()) {
                        builder.add((Object)Objects.requireNonNull(resultSet.getString(1), "got null schemaName from the database"));
                    }
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
                return builder.build();
            }
        });
    }

    public static JdbcCatalogSchema create(@Nullable SchemaPlus parentSchema, String name, DataSource dataSource, String catalog) {
        return JdbcCatalogSchema.create(parentSchema, name, dataSource, SqlDialectFactoryImpl.INSTANCE, catalog);
    }

    public static JdbcCatalogSchema create(@Nullable SchemaPlus parentSchema, String name, DataSource dataSource, SqlDialectFactory dialectFactory, String catalog) {
        Expression expression = parentSchema != null ? Schemas.subSchemaExpression(parentSchema, name, JdbcCatalogSchema.class) : Expressions.call((Expression)DataContext.ROOT, (Method)BuiltInMethod.DATA_CONTEXT_GET_ROOT_SCHEMA.method, (Expression[])new Expression[0]);
        SqlDialect dialect = JdbcSchema.createDialect(dialectFactory, dataSource);
        JdbcConvention convention = JdbcConvention.of(dialect, expression, name);
        return new JdbcCatalogSchema(dataSource, dialect, convention, catalog);
    }

    @Override
    public Lookup<Table> tables() {
        return Lookup.empty();
    }

    @Override
    public Lookup<? extends Schema> subSchemas() {
        return this.subSchemas;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private @Nullable String computeDefaultSchemaName() {
        try (Connection connection = this.dataSource.getConnection();){
            String string = connection.getSchema();
            return string;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public @Nullable String getDefaultSubSchemaName() {
        return this.defaultSchemaName.get().orElse(null);
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public <T> @Nullable T unwrap(Class<T> clazz) {
        if (clazz.isInstance(this)) {
            return clazz.cast(this);
        }
        if (clazz == DataSource.class) {
            return clazz.cast(this.getDataSource());
        }
        return null;
    }
}

