/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.schema.lookup;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Named<T> {
    private final String name;
    private final @NonNull T entity;

    public Named(String name, T entity) {
        this.name = name;
        this.entity = Objects.requireNonNull(entity, "entity");
    }

    public final String name() {
        return this.name;
    }

    public final T entity() {
        return this.entity;
    }

    public static <T> @Nullable T entityOrNull(@Nullable Named<T> named) {
        return named == null ? null : (T)named.entity;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Named named = (Named)o;
        return this.name.equals(named.name) && this.entity.equals(named.entity);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.entity.hashCode();
        return result;
    }
}

