/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.storage;

import java.util.Collection;
import java.util.List;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.commands.CatalogUtils;
import org.apache.ignite.internal.catalog.descriptors.CatalogZoneDescriptor;
import org.apache.ignite.internal.catalog.events.CatalogEvent;
import org.apache.ignite.internal.catalog.events.CatalogEventParameters;
import org.apache.ignite.internal.catalog.events.CreateZoneEventParameters;
import org.apache.ignite.internal.catalog.storage.Fireable;
import org.apache.ignite.internal.catalog.storage.UpdateEntry;
import org.apache.ignite.internal.catalog.storage.serialization.MarshallableEntryType;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.util.CollectionUtils;

public class NewZoneEntry
implements UpdateEntry,
Fireable {
    private final CatalogZoneDescriptor descriptor;

    public NewZoneEntry(CatalogZoneDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public CatalogZoneDescriptor descriptor() {
        return this.descriptor;
    }

    @Override
    public int typeId() {
        return MarshallableEntryType.NEW_ZONE.id();
    }

    @Override
    public CatalogEvent eventType() {
        return CatalogEvent.ZONE_CREATE;
    }

    @Override
    public CatalogEventParameters createEventParameters(long causalityToken, int catalogVersion) {
        return new CreateZoneEventParameters(causalityToken, catalogVersion, this.descriptor);
    }

    @Override
    public Catalog applyUpdate(Catalog catalog, HybridTimestamp timestamp) {
        this.descriptor.updateTimestamp(timestamp);
        return new Catalog(catalog.version(), catalog.time(), catalog.objectIdGenState(), CollectionUtils.concat((Collection[])new Collection[]{catalog.zones(), List.of(this.descriptor)}), catalog.schemas(), CatalogUtils.defaultZoneIdOpt(catalog));
    }

    public String toString() {
        return S.toString((Object)this);
    }
}

