/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.message;

import java.util.UUID;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;
import org.apache.ignite.internal.sql.engine.message.QueryBatchRequestMessage;
import org.apache.ignite.internal.sql.engine.message.QueryBatchRequestMessageBuilder;
import org.apache.ignite.internal.sql.engine.message.SqlQueryMessagesFactory;

class QueryBatchRequestMessageDeserializer
implements MessageDeserializer<QueryBatchRequestMessage> {
    private final QueryBatchRequestMessageBuilder msg;

    QueryBatchRequestMessageDeserializer(SqlQueryMessagesFactory messageFactory) {
        this.msg = messageFactory.queryBatchRequestMessage();
    }

    public Class<QueryBatchRequestMessage> klass() {
        return QueryBatchRequestMessage.class;
    }

    public QueryBatchRequestMessage getMessage() {
        return this.msg.build();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                int tmp = reader.readInt("amountOfBatches");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.amountOfBatches(tmp);
                reader.incrementState();
            }
            case 1: {
                long tmp = reader.readLong("exchangeId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.exchangeId(tmp);
                reader.incrementState();
            }
            case 2: {
                int tmp = reader.readInt("executionToken");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.executionToken(tmp);
                reader.incrementState();
            }
            case 3: {
                long tmp = reader.readLong("fragmentId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.fragmentId(tmp);
                reader.incrementState();
            }
            case 4: {
                Object tmp = reader.readUuid("queryId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.queryId((UUID)tmp);
                reader.incrementState();
            }
            case 5: {
                Object tmp = reader.readByteArray("sharedStateByteArray");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.sharedStateByteArray((byte[])tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(QueryBatchRequestMessage.class);
    }
}

