/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.prepare.ddl;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.ignite.internal.cluster.management.topology.api.LogicalNode;
import org.apache.ignite.internal.cluster.management.topology.api.LogicalTopologyService;
import org.apache.ignite.internal.cluster.management.topology.api.LogicalTopologySnapshot;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.sql.engine.prepare.ddl.StorageProfileValidator;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.sql.SqlException;

public class ClusterWideStorageProfileValidator
implements StorageProfileValidator {
    private final LogicalTopologyService logicalTopologyService;

    public ClusterWideStorageProfileValidator(LogicalTopologyService logicalTopologyService) {
        this.logicalTopologyService = logicalTopologyService;
    }

    @Override
    public CompletableFuture<Void> validate(Collection<String> storageProfiles) {
        LogicalTopologySnapshot localLogicalTopologySnapshot = this.logicalTopologyService.localLogicalTopology();
        Set<String> missedStorageProfileNames = ClusterWideStorageProfileValidator.findStorageProfileNotPresentedInLogicalTopologySnapshot(storageProfiles, localLogicalTopologySnapshot);
        if (missedStorageProfileNames.isEmpty()) {
            return CompletableFutures.nullCompletedFuture();
        }
        return ((CompletableFuture)this.logicalTopologyService.logicalTopologyOnLeader().thenApply(topologySnapshot -> ClusterWideStorageProfileValidator.findStorageProfileNotPresentedInLogicalTopologySnapshot(storageProfiles, topologySnapshot))).handle((missedProfileNames, e) -> {
            if (e != null) {
                String msg = IgniteStringFormatter.format((String)"Storage profiles {} don't exist in local topology snapshot with profiles [{}], and distributed refresh failed.", (Object[])new Object[]{missedStorageProfileNames, localLogicalTopologySnapshot.nodes().stream().map(LogicalNode::storageProfiles).collect(Collectors.toSet())});
                throw new SqlException(ErrorGroups.Common.INTERNAL_ERR, msg, e);
            }
            if (!missedProfileNames.isEmpty()) {
                throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, IgniteStringFormatter.format((String)"Some storage profiles don't exist [missedProfileNames={}].", (Object[])new Object[]{missedProfileNames}));
            }
            return null;
        });
    }

    private static Set<String> findStorageProfileNotPresentedInLogicalTopologySnapshot(Collection<String> storageProfiles, LogicalTopologySnapshot snapshot) {
        Set<String> topologyWideProfiles = ClusterWideStorageProfileValidator.extractStorageProfileNamesFromLogicalTopologySnapshot(snapshot);
        HashSet<String> missedProfiles = new HashSet<String>();
        for (String profileName : storageProfiles) {
            if (topologyWideProfiles.contains(profileName)) continue;
            missedProfiles.add(profileName);
        }
        return missedProfiles;
    }

    private static Set<String> extractStorageProfileNamesFromLogicalTopologySnapshot(LogicalTopologySnapshot snapshot) {
        Set logicalNodes = snapshot.nodes();
        HashSet<String> topologyWideProfiles = new HashSet<String>(logicalNodes.size() * 3);
        for (LogicalNode logicalNode : logicalNodes) {
            topologyWideProfiles.addAll(logicalNode.storageProfiles());
        }
        return topologyWideProfiles;
    }
}

