/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network.raft;

import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;
import org.apache.ignite.internal.partition.replicator.network.PartitionReplicationMessagesFactory;
import org.apache.ignite.internal.partition.replicator.network.raft.PartitionSnapshotMeta;
import org.apache.ignite.internal.partition.replicator.network.raft.PartitionSnapshotMetaBuilder;

class PartitionSnapshotMetaDeserializer
implements MessageDeserializer<PartitionSnapshotMeta> {
    private final PartitionSnapshotMetaBuilder msg;

    PartitionSnapshotMetaDeserializer(PartitionReplicationMessagesFactory messageFactory) {
        this.msg = messageFactory.partitionSnapshotMeta();
    }

    public Class<PartitionSnapshotMeta> klass() {
        return PartitionSnapshotMeta.class;
    }

    public PartitionSnapshotMeta getMessage() {
        return this.msg.build();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                long tmp = reader.readLong("cfgIndex");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.cfgIndex(tmp);
                reader.incrementState();
            }
            case 1: {
                long tmp = reader.readLong("cfgTerm");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.cfgTerm(tmp);
                reader.incrementState();
            }
            case 2: {
                long tmp = reader.readLong("lastIncludedIndex");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.lastIncludedIndex(tmp);
                reader.incrementState();
            }
            case 3: {
                long tmp = reader.readLong("lastIncludedTerm");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.lastIncludedTerm(tmp);
                reader.incrementState();
            }
            case 4: {
                Collection tmp = reader.readCollection("learnersList", MessageCollectionItemType.STRING);
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.learnersList(tmp);
                reader.incrementState();
            }
            case 5: {
                long tmp = reader.readLong("leaseStartTime");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.leaseStartTime(tmp);
                reader.incrementState();
            }
            case 6: {
                Object tmp = reader.readMap("nextRowIdToBuildByIndexId", MessageCollectionItemType.INT, MessageCollectionItemType.UUID, false);
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.nextRowIdToBuildByIndexId((Map<Integer, UUID>)tmp);
                reader.incrementState();
            }
            case 7: {
                Object tmp = reader.readCollection("oldLearnersList", MessageCollectionItemType.STRING);
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.oldLearnersList((Collection<String>)tmp);
                reader.incrementState();
            }
            case 8: {
                Object tmp = reader.readCollection("oldPeersList", MessageCollectionItemType.STRING);
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.oldPeersList((Collection<String>)tmp);
                reader.incrementState();
            }
            case 9: {
                Object tmp = reader.readCollection("peersList", MessageCollectionItemType.STRING);
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.peersList((Collection<String>)tmp);
                reader.incrementState();
            }
            case 10: {
                Object tmp = reader.readUuid("primaryReplicaNodeId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.primaryReplicaNodeId((UUID)tmp);
                reader.incrementState();
            }
            case 11: {
                Object tmp = reader.readString("primaryReplicaNodeName");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.primaryReplicaNodeName((String)tmp);
                reader.incrementState();
            }
            case 12: {
                int tmp = reader.readInt("requiredCatalogVersion");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.requiredCatalogVersion(tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(PartitionSnapshotMeta.class);
    }
}

