/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.util;

import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelNode;
import org.apache.ignite.internal.sql.engine.prepare.IgniteRelShuttle;
import org.apache.ignite.internal.sql.engine.prepare.RelWithSources;
import org.apache.ignite.internal.sql.engine.rel.IgniteRel;
import org.apache.ignite.internal.sql.engine.rel.IgniteTableModify;
import org.apache.ignite.internal.sql.engine.rel.SourceAwareIgniteRel;
import org.apache.ignite.internal.sql.engine.schema.IgniteTable;
import org.apache.ignite.internal.sql.engine.util.Commons;

public class Cloner {
    private final RelOptCluster cluster;

    private Cloner(RelOptCluster cluster) {
        this.cluster = cluster;
    }

    public static IgniteRel clone(IgniteRel root, RelOptCluster cluster) {
        Cloner c = new Cloner(cluster);
        return c.visit(root);
    }

    private IgniteRel visit(IgniteRel rel) {
        return rel.clone(this.cluster, Commons.transform(rel.getInputs(), rel0 -> this.visit((IgniteRel)rel0)));
    }

    public static RelWithSources cloneAndAssignSourceId(IgniteRel root, RelOptCluster cluster) {
        CloneAndAssignIds assigner = new CloneAndAssignIds(cluster);
        IgniteRel result = assigner.visit(root);
        return new RelWithSources(result, assigner.sources, assigner.modifiedTables);
    }

    private static class CloneAndAssignIds
    extends IgniteRelShuttle {
        private final RelOptCluster cluster;
        private long sourceIndex;
        private final Long2ObjectMap<IgniteRel> sources = new Long2ObjectOpenHashMap();
        private IntSet modifiedTables = IntSets.emptySet();

        private CloneAndAssignIds(RelOptCluster cluster) {
            this.cluster = cluster;
        }

        @Override
        public IgniteRel visit(IgniteRel rel) {
            if (rel instanceof SourceAwareIgniteRel) {
                SourceAwareIgniteRel src = (SourceAwareIgniteRel)rel;
                long sourceId = this.sourceIndex++;
                IgniteRel relWithSourceId = src.clone(sourceId);
                if (rel instanceof IgniteTableModify) {
                    RelOptTable relOptTable = rel.getTable();
                    assert (relOptTable != null);
                    IgniteTable table = (IgniteTable)relOptTable.unwrap(IgniteTable.class);
                    assert (table != null);
                    if (this.modifiedTables.isEmpty()) {
                        this.modifiedTables = new IntArraySet(1);
                    }
                    this.modifiedTables.add(table.id());
                }
                for (int i = 0; i < rel.getInputs().size(); ++i) {
                    IgniteRel childNode = this.visit((IgniteRel)rel.getInput(i));
                    relWithSourceId.replaceInput(i, (RelNode)childNode);
                }
                this.sources.put(sourceId, (Object)rel);
                return relWithSourceId;
            }
            ArrayList<IgniteRel> newChildren = new ArrayList<IgniteRel>(rel.getInputs().size());
            for (int i = 0; i < rel.getInputs().size(); ++i) {
                IgniteRel childNode = this.visit((IgniteRel)rel.getInput(i));
                newChildren.add(childNode);
            }
            return rel.clone(this.cluster, newChildren);
        }
    }
}

