/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.runtime;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.calcite.linq4j.MemoryFactory;
import org.apache.calcite.runtime.Automaton;
import org.apache.calcite.runtime.DeterministicAutomaton;
import org.apache.calcite.util.ImmutableBitSet;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Matcher<E> {
    private final DeterministicAutomaton dfa;
    private final ImmutableMap<String, Predicate<MemoryFactory.Memory<E>>> predicates;

    private Matcher(Automaton automaton, ImmutableMap<String, Predicate<MemoryFactory.Memory<E>>> predicates) {
        this.predicates = Objects.requireNonNull(predicates, "predicates");
        ImmutableBitSet.Builder startSetBuilder = ImmutableBitSet.builder();
        startSetBuilder.set(automaton.startState.id);
        automaton.epsilonSuccessors(automaton.startState.id, startSetBuilder);
        ImmutableBitSet unusedStartSet = startSetBuilder.build();
        this.dfa = new DeterministicAutomaton(automaton);
    }

    public static <E> Builder<E> builder(Automaton automaton) {
        return new Builder(automaton);
    }

    public List<PartialMatch<E>> match(E ... rows) {
        return this.match(Arrays.asList(rows));
    }

    public List<PartialMatch<E>> match(Iterable<E> rows) {
        ImmutableList.Builder resultMatchBuilder = ImmutableList.builder();
        Consumer<PartialMatch<E>> resultMatchConsumer = arg_0 -> ((ImmutableList.Builder)resultMatchBuilder).add(arg_0);
        PartitionState<E> partitionState = this.createPartitionState(0, 0);
        for (E row : rows) {
            partitionState.getMemoryFactory().add(row);
            this.matchOne(partitionState.getRows(), partitionState, resultMatchConsumer);
        }
        return resultMatchBuilder.build();
    }

    public PartitionState<E> createPartitionState(int history, int future) {
        return new PartitionState(history, future);
    }

    protected void matchOne(MemoryFactory.Memory<E> rows, PartitionState<E> partitionState, Consumer<PartialMatch<E>> resultMatches) {
        List<PartialMatch<E>> matches = this.matchOneWithSymbols(rows, partitionState);
        for (PartialMatch<E> pm : matches) {
            resultMatches.accept(pm);
        }
    }

    protected List<PartialMatch<E>> matchOneWithSymbols(MemoryFactory.Memory<E> rows, PartitionState<E> partitionState) {
        HashSet newMatches = new HashSet();
        for (Map.Entry predicate : this.predicates.entrySet()) {
            for (PartialMatch<Object> partialMatch : partitionState.getPartialMatches()) {
                if (!((Predicate)predicate.getValue()).test(rows)) continue;
                List transitions = this.dfa.getTransitions().stream().filter(t -> ((String)predicate.getKey()).equals(t.symbol)).filter(t -> pm.currentState.equals(t.fromState)).collect(Collectors.toList());
                for (DeterministicAutomaton.Transition transition : transitions) {
                    PartialMatch<Object> newMatch = partialMatch.append(transition.symbol, rows.get(), transition.toState);
                    newMatches.add(newMatch);
                }
            }
            if (!((Predicate)predicate.getValue()).test(rows)) continue;
            List list = this.dfa.getTransitions().stream().filter(t -> ((String)predicate.getKey()).equals(t.symbol)).filter(t -> this.dfa.startState.equals(t.fromState)).collect(Collectors.toList());
            for (DeterministicAutomaton.Transition transition : list) {
                PartialMatch newMatch = new PartialMatch(-1L, (ImmutableList<String>)ImmutableList.of((Object)transition.symbol), ImmutableList.of((Object)rows.get()), transition.toState);
                newMatches.add(newMatch);
            }
        }
        partitionState.clearPartitions();
        partitionState.addPartialMatches(newMatches);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (PartialMatch partialMatch : newMatches) {
            if (!this.dfa.getEndStates().contains((Object)partialMatch.currentState)) continue;
            builder.add(partialMatch);
        }
        return builder.build();
    }

    static class Tuple<E> {
        final String symbol;
        final E row;

        Tuple(String symbol, E row) {
            this.symbol = symbol;
            this.row = row;
        }

        public boolean equals(@Nullable Object o) {
            return o == this || o instanceof Tuple && ((Tuple)o).symbol.equals(this.symbol) && Objects.equals(this.row, ((Tuple)o).row);
        }

        public int hashCode() {
            return Objects.hash(this.symbol, this.row);
        }

        public String toString() {
            return "(" + this.symbol + ", " + this.row + ")";
        }
    }

    public static class Builder<E> {
        final Automaton automaton;
        final Map<String, Predicate<MemoryFactory.Memory<E>>> symbolPredicates = new HashMap<String, Predicate<MemoryFactory.Memory<E>>>();

        Builder(Automaton automaton) {
            this.automaton = automaton;
        }

        public Builder<E> add(String symbolName, Predicate<MemoryFactory.Memory<E>> predicate) {
            this.symbolPredicates.put(symbolName, predicate);
            return this;
        }

        public Matcher<E> build() {
            TreeSet predicateSymbolsNotInGraph = Sets.newTreeSet(this.symbolPredicates.keySet());
            predicateSymbolsNotInGraph.removeAll((Collection<?>)this.automaton.symbolNames);
            if (!predicateSymbolsNotInGraph.isEmpty()) {
                throw new IllegalArgumentException("not all predicate symbols [" + predicateSymbolsNotInGraph + "] are in graph [" + this.automaton.symbolNames + "]");
            }
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (String symbolName : this.automaton.symbolNames) {
                builder.put((Object)symbolName, this.symbolPredicates.getOrDefault(symbolName, e -> true));
            }
            return new Matcher(this.automaton, builder.build());
        }
    }

    static class PartialMatch<E> {
        final long startRow;
        final ImmutableList<String> symbols;
        final ImmutableList<E> rows;
        final DeterministicAutomaton.MultiState currentState;

        PartialMatch(long startRow, ImmutableList<String> symbols, ImmutableList<E> rows, DeterministicAutomaton.MultiState currentState) {
            this.startRow = startRow;
            this.symbols = symbols;
            this.rows = rows;
            this.currentState = currentState;
        }

        public PartialMatch<E> copy() {
            return new PartialMatch<E>(this.startRow, this.symbols, this.rows, this.currentState);
        }

        public PartialMatch<E> append(String symbol, E row, DeterministicAutomaton.MultiState toState) {
            ImmutableList symbols = ImmutableList.builder().addAll(this.symbols).add((Object)symbol).build();
            ImmutableList rows = ImmutableList.builder().addAll(this.rows).add(row).build();
            return new PartialMatch<E>(this.startRow, (ImmutableList<String>)symbols, rows, toState);
        }

        public boolean equals(@Nullable Object o) {
            return o == this || o instanceof PartialMatch && this.startRow == ((PartialMatch)o).startRow && Objects.equals(this.symbols, ((PartialMatch)o).symbols) && Objects.equals(this.rows, ((PartialMatch)o).rows) && Objects.equals(this.currentState, ((PartialMatch)o).currentState);
        }

        public int hashCode() {
            return Objects.hash(this.startRow, this.symbols, this.rows, this.currentState);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            for (int i = 0; i < this.rows.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append("(");
                sb.append((String)this.symbols.get(i));
                sb.append(", ");
                sb.append(this.rows.get(i));
                sb.append(")");
            }
            sb.append("]");
            return sb.toString();
        }
    }

    static class PartitionState<E> {
        private final Set<PartialMatch<E>> partialMatches = new HashSet<PartialMatch<E>>();
        private final MemoryFactory<E> memoryFactory;

        PartitionState(int history, int future) {
            this.memoryFactory = new MemoryFactory(history, future);
        }

        public void addPartialMatches(Collection<PartialMatch<E>> matches) {
            this.partialMatches.addAll(matches);
        }

        public Set<PartialMatch<E>> getPartialMatches() {
            return ImmutableSet.copyOf(this.partialMatches);
        }

        public void removePartialMatch(PartialMatch<E> pm) {
            this.partialMatches.remove(pm);
        }

        public void clearPartitions() {
            this.partialMatches.clear();
        }

        public MemoryFactory.Memory<E> getRows() {
            return this.memoryFactory.create();
        }

        public MemoryFactory<E> getMemoryFactory() {
            return this.memoryFactory;
        }
    }
}

