/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.compute;

import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.compute.JobExecution;
import org.apache.ignite3.compute.JobState;
import org.apache.ignite3.internal.compute.ComputeUtils;
import org.apache.ignite3.internal.compute.MarshallerProvider;
import org.apache.ignite3.internal.lang.IgniteExceptionMapperUtil;
import org.apache.ignite3.marshalling.Marshaller;
import org.apache.ignite3.network.ClusterNode;
import org.jetbrains.annotations.Nullable;

public class JobExecutionWrapper<R>
implements JobExecution<R>,
MarshallerProvider<R> {
    private final JobExecution<R> delegate;

    JobExecutionWrapper(JobExecution<R> delegate) {
        this.delegate = delegate;
    }

    @Override
    public CompletableFuture<R> resultAsync() {
        return ComputeUtils.convertToComputeFuture(this.delegate.resultAsync());
    }

    @Override
    public CompletableFuture<@Nullable JobState> stateAsync() {
        return IgniteExceptionMapperUtil.convertToPublicFuture(this.delegate.stateAsync());
    }

    @Override
    public CompletableFuture<@Nullable Boolean> changePriorityAsync(int newPriority) {
        return IgniteExceptionMapperUtil.convertToPublicFuture(this.delegate.changePriorityAsync(newPriority));
    }

    @Override
    public ClusterNode node() {
        return this.delegate.node();
    }

    @Override
    @Nullable
    public Marshaller<R, byte[]> resultMarshaller() {
        if (this.delegate instanceof MarshallerProvider) {
            return ((MarshallerProvider)((Object)this.delegate)).resultMarshaller();
        }
        return null;
    }

    @Override
    public boolean marshalResult() {
        return this.delegate instanceof MarshallerProvider && ((MarshallerProvider)((Object)this.delegate)).marshalResult();
    }
}

